/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BlockStateLoader;

@OnlyIn(value=Dist.CLIENT)
public class ModelBlockDefinition {
    private final Map<String, VariantList> field_178332_b = Maps.newLinkedHashMap();
    private Multipart field_188005_c;

    @Deprecated
    public static ModelBlockDefinition func_209577_a(ContainerHolder containerHolderIn, Reader readerIn) {
        return ModelBlockDefinition.fromJson(containerHolderIn, readerIn, null);
    }

    public static ModelBlockDefinition fromJson(ContainerHolder containerHolderIn, Reader readerIn, @Nullable ResourceLocation location) {
        return BlockStateLoader.load((Reader)readerIn, (ResourceLocation)location, (Gson)containerHolderIn.field_209575_a);
    }

    public ModelBlockDefinition(Map<String, VariantList> variants, Multipart multipartIn) {
        this.field_188005_c = multipartIn;
        this.field_178332_b.putAll(variants);
    }

    public ModelBlockDefinition(List<ModelBlockDefinition> definitions) {
        ModelBlockDefinition modelblockdefinition = null;
        for (ModelBlockDefinition modelblockdefinition1 : definitions) {
            if (modelblockdefinition1.func_188002_b()) {
                this.field_178332_b.clear();
                modelblockdefinition = modelblockdefinition1;
            }
            this.field_178332_b.putAll(modelblockdefinition1.field_178332_b);
        }
        if (modelblockdefinition != null) {
            this.field_188005_c = modelblockdefinition.field_188005_c;
        }
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof ModelBlockDefinition) {
            ModelBlockDefinition modelblockdefinition = (ModelBlockDefinition)p_equals_1_;
            if (this.field_178332_b.equals(modelblockdefinition.field_178332_b)) {
                return this.func_188002_b() ? this.field_188005_c.equals(modelblockdefinition.field_188005_c) : !modelblockdefinition.func_188002_b();
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.field_178332_b.hashCode() + (this.func_188002_b() ? this.field_188005_c.hashCode() : 0);
    }

    public Map<String, VariantList> func_209578_a() {
        return this.field_178332_b;
    }

    public boolean func_188002_b() {
        return this.field_188005_c != null;
    }

    public Multipart func_188001_c() {
        return this.field_188005_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ModelBlockDefinition> {
        public ModelBlockDefinition deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            Map<String, VariantList> map = this.func_187999_a(p_deserialize_3_, jsonobject);
            Multipart multipart = this.func_187998_b(p_deserialize_3_, jsonobject);
            if (!map.isEmpty() || multipart != null && !multipart.func_188137_b().isEmpty()) {
                return new ModelBlockDefinition(map, multipart);
            }
            throw new JsonParseException("Neither 'variants' nor 'multipart' found");
        }

        protected Map<String, VariantList> func_187999_a(JsonDeserializationContext deserializationContext, JsonObject object) {
            HashMap map = Maps.newHashMap();
            if (object.has("variants")) {
                JsonObject jsonobject = JsonUtils.func_152754_s((JsonObject)object, (String)"variants");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put(entry.getKey(), deserializationContext.deserialize((JsonElement)entry.getValue(), VariantList.class));
                }
            }
            return map;
        }

        @Nullable
        protected Multipart func_187998_b(JsonDeserializationContext deserializationContext, JsonObject object) {
            if (!object.has("multipart")) {
                return null;
            }
            JsonArray jsonarray = JsonUtils.func_151214_t((JsonObject)object, (String)"multipart");
            return (Multipart)deserializationContext.deserialize((JsonElement)jsonarray, Multipart.class);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class ContainerHolder {
        @VisibleForTesting
        final Gson field_209575_a = new GsonBuilder().registerTypeAdapter(ModelBlockDefinition.class, (Object)new Deserializer()).registerTypeAdapter(Variant.class, (Object)new Variant.Deserializer()).registerTypeAdapter(VariantList.class, (Object)new VariantList.Deserializer()).registerTypeAdapter(Multipart.class, (Object)new Multipart.Deserializer(this)).registerTypeAdapter(Selector.class, (Object)new Selector.Deserializer()).create();
        private StateContainer<Block, IBlockState> field_209576_b;

        public StateContainer<Block, IBlockState> func_209574_a() {
            return this.field_209576_b;
        }

        public void func_209573_a(StateContainer<Block, IBlockState> stateContainerIn) {
            this.field_209576_b = stateContainerIn;
        }
    }
}

