/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.color;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockShearableDoublePlant;
import net.minecraft.block.BlockStem;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.registries.IRegistryDelegate;

@OnlyIn(value=Dist.CLIENT)
public class BlockColors {
    private final Map<IRegistryDelegate<Block>, IBlockColor> field_186725_a = new HashMap<IRegistryDelegate<Block>, IBlockColor>();

    public static BlockColors func_186723_a() {
        BlockColors blockcolors = new BlockColors();
        blockcolors.func_186722_a((p_210234_0_, p_210234_1_, p_210234_2_, p_210234_3_) -> p_210234_1_ != null && p_210234_2_ != null ? BiomeColors.func_180286_a((IWorldReaderBase)p_210234_1_, (BlockPos)(p_210234_0_.func_177229_b((IProperty)BlockShearableDoublePlant.field_208063_b) == DoubleBlockHalf.UPPER ? p_210234_2_.func_177977_b() : p_210234_2_)) : -1, Blocks.field_196805_gi, Blocks.field_196804_gh);
        blockcolors.func_186722_a((p_210225_0_, p_210225_1_, p_210225_2_, p_210225_3_) -> p_210225_1_ != null && p_210225_2_ != null ? BiomeColors.func_180286_a((IWorldReaderBase)p_210225_1_, (BlockPos)p_210225_2_) : GrassColors.func_77480_a((double)0.5, (double)1.0), Blocks.field_196658_i, Blocks.field_196554_aH, Blocks.field_150349_c, Blocks.field_196683_eB);
        blockcolors.func_186722_a((p_210227_0_, p_210227_1_, p_210227_2_, p_210227_3_) -> FoliageColors.func_77466_a(), Blocks.field_196645_X);
        blockcolors.func_186722_a((p_210232_0_, p_210232_1_, p_210232_2_, p_210232_3_) -> FoliageColors.func_77469_b(), Blocks.field_196647_Y);
        blockcolors.func_186722_a((p_210229_0_, p_210229_1_, p_210229_2_, p_210229_3_) -> p_210229_1_ != null && p_210229_2_ != null ? BiomeColors.func_180287_b((IWorldReaderBase)p_210229_1_, (BlockPos)p_210229_2_) : FoliageColors.func_77468_c(), Blocks.field_196642_W, Blocks.field_196648_Z, Blocks.field_196572_aa, Blocks.field_196574_ab, Blocks.field_150395_bd);
        blockcolors.func_186722_a((p_210226_0_, p_210226_1_, p_210226_2_, p_210226_3_) -> p_210226_1_ != null && p_210226_2_ != null ? BiomeColors.func_180288_c((IWorldReaderBase)p_210226_1_, (BlockPos)p_210226_2_) : -1, Blocks.field_150355_j, Blocks.field_203203_C, Blocks.field_150383_bp);
        blockcolors.func_186722_a((p_210231_0_, p_210231_1_, p_210231_2_, p_210231_3_) -> BlockRedstoneWire.func_176337_b((Integer)p_210231_0_.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)), Blocks.field_150488_af);
        blockcolors.func_186722_a((p_210230_0_, p_210230_1_, p_210230_2_, p_210230_3_) -> p_210230_1_ != null && p_210230_2_ != null ? BiomeColors.func_180286_a((IWorldReaderBase)p_210230_1_, (BlockPos)p_210230_2_) : -1, Blocks.field_196608_cF);
        blockcolors.func_186722_a((p_210224_0_, p_210224_1_, p_210224_2_, p_210224_3_) -> 14731036, Blocks.field_196713_dt, Blocks.field_196711_ds);
        blockcolors.func_186722_a((p_210233_0_, p_210233_1_, p_210233_2_, p_210233_3_) -> {
            int i = (Integer)p_210233_0_.func_177229_b((IProperty)BlockStem.field_176484_a);
            int j = i * 32;
            int k = 255 - i * 8;
            int l = i * 4;
            return j << 16 | k << 8 | l;
        }, Blocks.field_150394_bc, Blocks.field_150393_bb);
        blockcolors.func_186722_a((p_210228_0_, p_210228_1_, p_210228_2_, p_210228_3_) -> p_210228_1_ != null && p_210228_2_ != null ? 2129968 : 7455580, Blocks.field_196651_dG);
        ForgeHooksClient.onBlockColorsInit((BlockColors)blockcolors);
        return blockcolors;
    }

    public int func_189991_a(IBlockState state, World p_189991_2_, BlockPos p_189991_3_) {
        IBlockColor iblockcolor = this.field_186725_a.get(state.func_177230_c().delegate);
        if (iblockcolor != null) {
            return iblockcolor.getColor(state, (IWorldReaderBase)null, (BlockPos)null, 0);
        }
        MaterialColor materialcolor = state.func_185909_g((IBlockReader)p_189991_2_, p_189991_3_);
        return materialcolor != null ? materialcolor.field_76291_p : -1;
    }

    public int func_186724_a(IBlockState state, @Nullable IWorldReaderBase blockAccess, @Nullable BlockPos pos, int tintIndex) {
        IBlockColor iblockcolor = this.field_186725_a.get(state.func_177230_c().delegate);
        return iblockcolor == null ? -1 : iblockcolor.getColor(state, blockAccess, pos, tintIndex);
    }

    public void func_186722_a(IBlockColor blockColor, Block ... blocksIn) {
        for (Block block : blocksIn) {
            this.field_186725_a.put((IRegistryDelegate<Block>)block.delegate, blockColor);
        }
    }
}

