/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Ordering;
import java.util.Collection;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class InventoryEffectRenderer
extends GuiContainer {
    protected boolean field_147045_u;

    public InventoryEffectRenderer(Container inventorySlotsIn) {
        super(inventorySlotsIn);
    }

    @Override
    protected void func_73866_w_() {
        super.func_73866_w_();
        this.func_175378_g();
    }

    protected void func_175378_g() {
        boolean hasVisibleEffect = false;
        for (PotionEffect potioneffect : this.field_146297_k.field_71439_g.func_70651_bq()) {
            Potion potion = potioneffect.func_188419_a();
            if (!potion.shouldRender(potioneffect)) continue;
            hasVisibleEffect = true;
            break;
        }
        if (this.field_146297_k.field_71439_g.func_70651_bq().isEmpty() || !hasVisibleEffect) {
            this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
            this.field_147045_u = false;
        } else {
            this.field_147003_i = MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.PotionShiftEvent((GuiScreen)this)) ? (this.field_146294_l - this.field_146999_f) / 2 : 160 + (this.field_146294_l - this.field_146999_f - 200) / 2;
            this.field_147045_u = true;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.field_147045_u) {
            this.func_147044_g();
        }
    }

    private void func_147044_g() {
        int i = this.field_147003_i - 124;
        int j = this.field_147009_r;
        int k = 166;
        Collection<PotionEffect> collection = this.field_146297_k.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            int l = 33;
            if (collection.size() > 5) {
                l = 132 / (collection.size() - 1);
            }
            for (PotionEffect potioneffect : Ordering.natural().sortedCopy(collection)) {
                Potion potion = potioneffect.func_188419_a();
                if (!potion.shouldRender(potioneffect)) continue;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(field_147001_a);
                this.func_73729_b(i, j, 0, 166, 140, 32);
                if (potion.func_76400_d()) {
                    int i1 = potion.func_76392_e();
                    this.func_73729_b(i + 6, j + 7, i1 % 12 * 18, 198 + i1 / 12 * 18, 18, 18);
                }
                potion.renderInventoryEffect(potioneffect, (Gui)this, i, j, this.field_73735_i);
                if (!potion.shouldRenderInvText(potioneffect)) {
                    j += l;
                    continue;
                }
                String s1 = I18n.func_135052_a(potion.func_76393_a(), new Object[0]);
                if (potioneffect.func_76458_c() == 1) {
                    s1 = s1 + ' ' + I18n.func_135052_a("enchantment.level.2", new Object[0]);
                } else if (potioneffect.func_76458_c() == 2) {
                    s1 = s1 + ' ' + I18n.func_135052_a("enchantment.level.3", new Object[0]);
                } else if (potioneffect.func_76458_c() == 3) {
                    s1 = s1 + ' ' + I18n.func_135052_a("enchantment.level.4", new Object[0]);
                }
                this.field_146289_q.func_175063_a(s1, (float)(i + 10 + 18), (float)(j + 6), 0xFFFFFF);
                String s = PotionUtil.func_188410_a((PotionEffect)potioneffect, (float)1.0f);
                this.field_146289_q.func_175063_a(s, (float)(i + 10 + 18), (float)(j + 6 + 10), 0x7F7F7F);
                j += l;
            }
        }
    }
}

