/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockFluidRenderer {
    private final TextureAtlasSprite[] field_178272_a = new TextureAtlasSprite[2];
    private final TextureAtlasSprite[] field_178271_b = new TextureAtlasSprite[2];
    private TextureAtlasSprite field_187501_d;

    public BlockFluidRenderer() {
        this.func_178268_a();
    }

    protected void func_178268_a() {
        TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
        this.field_178272_a[0] = Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(Blocks.field_150353_l.func_176223_P()).func_177554_e();
        this.field_178272_a[1] = texturemap.func_195424_a(ModelBakery.field_207766_d);
        this.field_178271_b[0] = Minecraft.func_71410_x().func_209506_al().func_174954_c().func_178125_b(Blocks.field_150355_j.func_176223_P()).func_177554_e();
        this.field_178271_b[1] = texturemap.func_195424_a(ModelBakery.field_207768_f);
        this.field_187501_d = texturemap.func_195424_a(ModelBakery.field_207769_g);
    }

    private static boolean func_209557_a(IBlockReader worldIn, BlockPos pos, EnumFacing side, IFluidState state) {
        BlockPos blockpos = pos.func_177972_a(side);
        IFluidState ifluidstate = worldIn.func_204610_c(blockpos);
        return ifluidstate.func_206886_c().func_207187_a(state.func_206886_c());
    }

    private static boolean func_209556_a(IBlockReader reader, BlockPos pos, EnumFacing face, float heightIn) {
        BlockPos blockpos = pos.func_177972_a(face);
        IBlockState iblockstate = reader.func_180495_p(blockpos);
        if (iblockstate.func_200132_m()) {
            VoxelShape voxelshape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)heightIn, (double)1.0);
            VoxelShape voxelshape1 = iblockstate.func_196951_e(reader, blockpos);
            return VoxelShapes.func_197875_a((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (EnumFacing)face);
        }
        return false;
    }

    public boolean func_205346_a(IWorldReader worldIn, BlockPos pos, BufferBuilder buffer, IFluidState state) {
        boolean flag6;
        boolean flag = state.func_206884_a(FluidTags.field_206960_b);
        TextureAtlasSprite[] atextureatlassprite = flag ? this.field_178272_a : this.field_178271_b;
        int i = flag ? 0xFFFFFF : BiomeColors.func_180288_c((IWorldReaderBase)worldIn, (BlockPos)pos);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        boolean flag1 = !BlockFluidRenderer.func_209557_a((IBlockReader)worldIn, pos, EnumFacing.UP, state);
        boolean flag2 = !BlockFluidRenderer.func_209557_a((IBlockReader)worldIn, pos, EnumFacing.DOWN, state) && !BlockFluidRenderer.func_209556_a((IBlockReader)worldIn, pos, EnumFacing.DOWN, 0.8888889f);
        boolean flag3 = !BlockFluidRenderer.func_209557_a((IBlockReader)worldIn, pos, EnumFacing.NORTH, state);
        boolean flag4 = !BlockFluidRenderer.func_209557_a((IBlockReader)worldIn, pos, EnumFacing.SOUTH, state);
        boolean flag5 = !BlockFluidRenderer.func_209557_a((IBlockReader)worldIn, pos, EnumFacing.WEST, state);
        boolean bl = flag6 = !BlockFluidRenderer.func_209557_a((IBlockReader)worldIn, pos, EnumFacing.EAST, state);
        if (!(flag1 || flag2 || flag6 || flag5 || flag3 || flag4)) {
            return false;
        }
        boolean flag7 = false;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = this.func_204504_a((IWorldReaderBase)worldIn, pos, state.func_206886_c());
        float f8 = this.func_204504_a((IWorldReaderBase)worldIn, pos.func_177968_d(), state.func_206886_c());
        float f9 = this.func_204504_a((IWorldReaderBase)worldIn, pos.func_177974_f().func_177968_d(), state.func_206886_c());
        float f10 = this.func_204504_a((IWorldReaderBase)worldIn, pos.func_177974_f(), state.func_206886_c());
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        float f11 = 0.001f;
        if (flag1 && !BlockFluidRenderer.func_209556_a((IBlockReader)worldIn, pos, EnumFacing.UP, Math.min(Math.min(f7, f8), Math.min(f9, f10)))) {
            float f19;
            float f15;
            float f18;
            float f14;
            float f17;
            float f13;
            float f16;
            float f12;
            flag7 = true;
            f7 -= 0.001f;
            f8 -= 0.001f;
            f9 -= 0.001f;
            f10 -= 0.001f;
            Vec3d vec3d = state.func_206887_a((IWorldReaderBase)worldIn, pos);
            if (vec3d.field_72450_a == 0.0 && vec3d.field_72449_c == 0.0) {
                TextureAtlasSprite textureatlassprite1 = atextureatlassprite[0];
                f12 = textureatlassprite1.func_94214_a(0.0);
                f16 = textureatlassprite1.func_94207_b(0.0);
                f13 = f12;
                f17 = textureatlassprite1.func_94207_b(16.0);
                f14 = textureatlassprite1.func_94214_a(16.0);
                f18 = f17;
                f15 = f14;
                f19 = f16;
            } else {
                TextureAtlasSprite textureatlassprite = atextureatlassprite[1];
                float f20 = (float)MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) - 1.5707964f;
                float f21 = MathHelper.func_76126_a((float)f20) * 0.25f;
                float f22 = MathHelper.func_76134_b((float)f20) * 0.25f;
                float f23 = 8.0f;
                f12 = textureatlassprite.func_94214_a(8.0f + (-f22 - f21) * 16.0f);
                f16 = textureatlassprite.func_94207_b(8.0f + (-f22 + f21) * 16.0f);
                f13 = textureatlassprite.func_94214_a(8.0f + (-f22 + f21) * 16.0f);
                f17 = textureatlassprite.func_94207_b(8.0f + (f22 + f21) * 16.0f);
                f14 = textureatlassprite.func_94214_a(8.0f + (f22 + f21) * 16.0f);
                f18 = textureatlassprite.func_94207_b(8.0f + (f22 - f21) * 16.0f);
                f15 = textureatlassprite.func_94214_a(8.0f + (f22 - f21) * 16.0f);
                f19 = textureatlassprite.func_94207_b(8.0f + (-f22 - f21) * 16.0f);
            }
            int i2 = this.func_204835_a(worldIn, pos);
            int j2 = i2 >> 16 & 0xFFFF;
            int k2 = i2 & 0xFFFF;
            float f42 = 1.0f * f;
            float f43 = 1.0f * f1;
            float f24 = 1.0f * f2;
            buffer.func_181662_b(d0 + 0.0, d1 + (double)f7, d2 + 0.0).func_181666_a(f42, f43, f24, 1.0f).func_187315_a(f12, f16).func_187314_a(j2, k2).func_181675_d();
            buffer.func_181662_b(d0 + 0.0, d1 + (double)f8, d2 + 1.0).func_181666_a(f42, f43, f24, 1.0f).func_187315_a(f13, f17).func_187314_a(j2, k2).func_181675_d();
            buffer.func_181662_b(d0 + 1.0, d1 + (double)f9, d2 + 1.0).func_181666_a(f42, f43, f24, 1.0f).func_187315_a(f14, f18).func_187314_a(j2, k2).func_181675_d();
            buffer.func_181662_b(d0 + 1.0, d1 + (double)f10, d2 + 0.0).func_181666_a(f42, f43, f24, 1.0f).func_187315_a(f15, f19).func_187314_a(j2, k2).func_181675_d();
            if (state.func_205586_a((IBlockReader)worldIn, pos.func_177984_a())) {
                buffer.func_181662_b(d0 + 0.0, d1 + (double)f7, d2 + 0.0).func_181666_a(f42, f43, f24, 1.0f).func_187315_a(f12, f16).func_187314_a(j2, k2).func_181675_d();
                buffer.func_181662_b(d0 + 1.0, d1 + (double)f10, d2 + 0.0).func_181666_a(f42, f43, f24, 1.0f).func_187315_a(f15, f19).func_187314_a(j2, k2).func_181675_d();
                buffer.func_181662_b(d0 + 1.0, d1 + (double)f9, d2 + 1.0).func_181666_a(f42, f43, f24, 1.0f).func_187315_a(f14, f18).func_187314_a(j2, k2).func_181675_d();
                buffer.func_181662_b(d0 + 0.0, d1 + (double)f8, d2 + 1.0).func_181666_a(f42, f43, f24, 1.0f).func_187315_a(f13, f17).func_187314_a(j2, k2).func_181675_d();
            }
        }
        if (flag2) {
            float f33 = atextureatlassprite[0].func_94209_e();
            float f34 = atextureatlassprite[0].func_94212_f();
            float f36 = atextureatlassprite[0].func_94206_g();
            float f38 = atextureatlassprite[0].func_94210_h();
            int j1 = this.func_204835_a(worldIn, pos.func_177977_b());
            int k1 = j1 >> 16 & 0xFFFF;
            int l1 = j1 & 0xFFFF;
            float f39 = 0.5f * f;
            float f40 = 0.5f * f1;
            float f41 = 0.5f * f2;
            buffer.func_181662_b(d0, d1, d2 + 1.0).func_181666_a(f39, f40, f41, 1.0f).func_187315_a(f33, f38).func_187314_a(k1, l1).func_181675_d();
            buffer.func_181662_b(d0, d1, d2).func_181666_a(f39, f40, f41, 1.0f).func_187315_a(f33, f36).func_187314_a(k1, l1).func_181675_d();
            buffer.func_181662_b(d0 + 1.0, d1, d2).func_181666_a(f39, f40, f41, 1.0f).func_187315_a(f34, f36).func_187314_a(k1, l1).func_181675_d();
            buffer.func_181662_b(d0 + 1.0, d1, d2 + 1.0).func_181666_a(f39, f40, f41, 1.0f).func_187315_a(f34, f38).func_187314_a(k1, l1).func_181675_d();
            flag7 = true;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            IBlockState blockstate;
            boolean flag8;
            EnumFacing enumfacing;
            double d6;
            double d4;
            double d5;
            double d3;
            float f37;
            float f35;
            if (i1 == 0) {
                f35 = f7;
                f37 = f10;
                d3 = d0;
                d5 = d0 + 1.0;
                d4 = d2 + (double)0.001f;
                d6 = d2 + (double)0.001f;
                enumfacing = EnumFacing.NORTH;
                flag8 = flag3;
            } else if (i1 == 1) {
                f35 = f9;
                f37 = f8;
                d3 = d0 + 1.0;
                d5 = d0;
                d4 = d2 + 1.0 - (double)0.001f;
                d6 = d2 + 1.0 - (double)0.001f;
                enumfacing = EnumFacing.SOUTH;
                flag8 = flag4;
            } else if (i1 == 2) {
                f35 = f8;
                f37 = f7;
                d3 = d0 + (double)0.001f;
                d5 = d0 + (double)0.001f;
                d4 = d2 + 1.0;
                d6 = d2;
                enumfacing = EnumFacing.WEST;
                flag8 = flag5;
            } else {
                f35 = f10;
                f37 = f9;
                d3 = d0 + 1.0 - (double)0.001f;
                d5 = d0 + 1.0 - (double)0.001f;
                d4 = d2;
                d6 = d2 + 1.0;
                enumfacing = EnumFacing.EAST;
                flag8 = flag6;
            }
            if (!flag8 || BlockFluidRenderer.func_209556_a((IBlockReader)worldIn, pos, enumfacing, Math.max(f35, f37))) continue;
            flag7 = true;
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
            if (!flag && (blockstate = worldIn.func_180495_p(blockpos)).func_193401_d((IBlockReader)worldIn, blockpos, enumfacing) == BlockFaceShape.SOLID) {
                textureatlassprite2 = this.field_187501_d;
            }
            float f44 = textureatlassprite2.func_94214_a(0.0);
            float f25 = textureatlassprite2.func_94214_a(8.0);
            float f26 = textureatlassprite2.func_94207_b((1.0f - f35) * 16.0f * 0.5f);
            float f27 = textureatlassprite2.func_94207_b((1.0f - f37) * 16.0f * 0.5f);
            float f28 = textureatlassprite2.func_94207_b(8.0);
            int j = this.func_204835_a(worldIn, blockpos);
            int k = j >> 16 & 0xFFFF;
            int l = j & 0xFFFF;
            float f29 = i1 < 2 ? 0.8f : 0.6f;
            float f30 = 1.0f * f29 * f;
            float f31 = 1.0f * f29 * f1;
            float f32 = 1.0f * f29 * f2;
            buffer.func_181662_b(d3, d1 + (double)f35, d4).func_181666_a(f30, f31, f32, 1.0f).func_187315_a(f44, f26).func_187314_a(k, l).func_181675_d();
            buffer.func_181662_b(d5, d1 + (double)f37, d6).func_181666_a(f30, f31, f32, 1.0f).func_187315_a(f25, f27).func_187314_a(k, l).func_181675_d();
            buffer.func_181662_b(d5, d1 + 0.0, d6).func_181666_a(f30, f31, f32, 1.0f).func_187315_a(f25, f28).func_187314_a(k, l).func_181675_d();
            buffer.func_181662_b(d3, d1 + 0.0, d4).func_181666_a(f30, f31, f32, 1.0f).func_187315_a(f44, f28).func_187314_a(k, l).func_181675_d();
            if (textureatlassprite2 == this.field_187501_d) continue;
            buffer.func_181662_b(d3, d1 + 0.0, d4).func_181666_a(f30, f31, f32, 1.0f).func_187315_a(f44, f28).func_187314_a(k, l).func_181675_d();
            buffer.func_181662_b(d5, d1 + 0.0, d6).func_181666_a(f30, f31, f32, 1.0f).func_187315_a(f25, f28).func_187314_a(k, l).func_181675_d();
            buffer.func_181662_b(d5, d1 + (double)f37, d6).func_181666_a(f30, f31, f32, 1.0f).func_187315_a(f25, f27).func_187314_a(k, l).func_181675_d();
            buffer.func_181662_b(d3, d1 + (double)f35, d4).func_181666_a(f30, f31, f32, 1.0f).func_187315_a(f44, f26).func_187314_a(k, l).func_181675_d();
        }
        return flag7;
    }

    private int func_204835_a(IWorldReader reader, BlockPos pos) {
        int i = reader.func_175626_b(pos, 0);
        int j = reader.func_175626_b(pos.func_177984_a(), 0);
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    private float func_204504_a(IWorldReaderBase reader, BlockPos pos, Fluid fluidIn) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = pos.func_177982_a(-(j & 1), 0, -(j >> 1 & 1));
            if (reader.func_204610_c(blockpos.func_177984_a()).func_206886_c().func_207187_a(fluidIn)) {
                return 1.0f;
            }
            IFluidState ifluidstate = reader.func_204610_c(blockpos);
            if (ifluidstate.func_206886_c().func_207187_a(fluidIn)) {
                if (ifluidstate.func_206885_f() >= 0.8f) {
                    f += ifluidstate.func_206885_f() * 10.0f;
                    i += 10;
                    continue;
                }
                f += ifluidstate.func_206885_f();
                ++i;
                continue;
            }
            if (reader.func_180495_p(blockpos).func_185904_a().func_76220_a()) continue;
            ++i;
        }
        return f / (float)i;
    }
}

