/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.inventory;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiContainer
extends GuiScreen {
    public static final ResourceLocation field_147001_a = new ResourceLocation("textures/gui/container/inventory.png");
    protected int field_146999_f = 176;
    protected int field_147000_g = 166;
    public Container field_147002_h;
    protected int field_147003_i;
    protected int field_147009_r;
    protected Slot field_147006_u;
    private Slot field_147005_v;
    private boolean field_147004_w;
    private ItemStack field_147012_x = ItemStack.field_190927_a;
    private int field_147011_y;
    private int field_147010_z;
    private Slot field_146989_A;
    private long field_146990_B;
    private ItemStack field_146991_C = ItemStack.field_190927_a;
    private Slot field_146985_D;
    private long field_146986_E;
    protected final Set<Slot> field_147008_s = Sets.newHashSet();
    protected boolean field_147007_t;
    private int field_146987_F;
    private int field_146988_G;
    private boolean field_146995_H;
    private int field_146996_I;
    private long field_146997_J;
    private Slot field_146998_K;
    private int field_146992_L;
    private boolean field_146993_M;
    private ItemStack field_146994_N = ItemStack.field_190927_a;
    public int slotColor = -2130706433;

    public GuiContainer(Container inventorySlotsIn) {
        this.field_147002_h = inventorySlotsIn;
        this.field_146995_H = true;
    }

    @Override
    protected void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ItemStack itemstack;
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_146976_a(partialTicks, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawBackground(this, mouseX, mouseY));
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)i, (float)j, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        this.field_147006_u = null;
        int k = 240;
        int l = 240;
        OpenGlHelper.func_77475_a(OpenGlHelper.field_77476_b, 240.0f, 240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i1 = 0; i1 < this.field_147002_h.field_75151_b.size(); ++i1) {
            Slot slot = this.field_147002_h.field_75151_b.get(i1);
            if (slot.func_111238_b()) {
                this.func_146977_a(slot);
            }
            if (!this.func_195362_a(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            this.field_147006_u = slot;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int j1 = slot.field_75223_e;
            int k1 = slot.field_75221_f;
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int slotColor = this.getSlotColor(i1);
            this.func_73733_a(j1, k1, j1 + 16, k1 + 16, slotColor, slotColor);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        RenderHelper.func_74518_a();
        this.func_146979_b(mouseX, mouseY);
        RenderHelper.func_74520_c();
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground(this, mouseX, mouseY));
        InventoryPlayer inventoryplayer = this.field_146297_k.field_71439_g.field_71071_by;
        ItemStack itemStack = itemstack = this.field_147012_x.func_190926_b() ? inventoryplayer.func_70445_o() : this.field_147012_x;
        if (!itemstack.func_190926_b()) {
            int j2 = 8;
            int k2 = this.field_147012_x.func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.field_147012_x.func_190926_b() && this.field_147004_w) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(MathHelper.func_76123_f((float)((float)itemstack.func_190916_E() / 2.0f)));
            } else if (this.field_147007_t && this.field_147008_s.size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(this.field_146996_I);
                if (itemstack.func_190926_b()) {
                    s = "" + TextFormatting.YELLOW + "0";
                }
            }
            this.func_146982_a(itemstack, mouseX - i - 8, mouseY - j - k2, s);
        }
        if (!this.field_146991_C.func_190926_b()) {
            float f = (float)(Util.func_211177_b() - this.field_146990_B) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.field_146991_C = ItemStack.field_190927_a;
            }
            int l2 = this.field_146989_A.field_75223_e - this.field_147011_y;
            int i3 = this.field_146989_A.field_75221_f - this.field_147010_z;
            int l1 = this.field_147011_y + (int)((float)l2 * f);
            int i2 = this.field_147010_z + (int)((float)i3 * f);
            this.func_146982_a(this.field_146991_C, l1, i2, null);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    protected void func_191948_b(int p_191948_1_, int p_191948_2_) {
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            this.func_146285_a(this.field_147006_u.func_75211_c(), p_191948_1_, p_191948_2_);
        }
    }

    private void func_146982_a(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y - (this.field_147012_x.func_190926_b() ? 0 : 8), altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }

    protected abstract void func_146976_a(float var1, int var2, int var3);

    private void func_146977_a(Slot slotIn) {
        TextureAtlasSprite textureatlassprite;
        int i = slotIn.field_75223_e;
        int j = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == this.field_147005_v && !this.field_147012_x.func_190926_b() && !this.field_147004_w;
        ItemStack itemstack1 = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (slotIn == this.field_147005_v && !this.field_147012_x.func_190926_b() && this.field_147004_w && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.field_147007_t && this.field_147008_s.contains(slotIn) && !itemstack1.func_190926_b()) {
            if (this.field_147008_s.size() == 1) {
                return;
            }
            if (Container.func_94527_a(slotIn, itemstack1, true) && this.field_147002_h.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a(this.field_147008_s, this.field_146987_F, itemstack, slotIn.func_75211_c().func_190926_b() ? 0 : slotIn.func_75211_c().func_190916_E());
                int k = Math.min(itemstack.func_77976_d(), slotIn.func_178170_b(itemstack));
                if (itemstack.func_190916_E() > k) {
                    s = TextFormatting.YELLOW.toString() + k;
                    itemstack.func_190920_e(k);
                }
            } else {
                this.field_147008_s.remove(slotIn);
                this.func_146980_g();
            }
        }
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slotIn.func_111238_b() && (textureatlassprite = slotIn.getBackgroundSprite()) != null) {
            GlStateManager.func_179140_f();
            this.field_146297_k.func_110434_K().func_110577_a(slotIn.getBackgroundLocation());
            this.func_175175_a(i, j, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                GuiContainer.func_73734_a((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a(this.field_146297_k.field_71439_g, itemstack, i, j);
            this.field_146296_j.func_180453_a(this.field_146289_q, itemstack, i, j, s);
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    private void func_146980_g() {
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!itemstack.func_190926_b() && this.field_147007_t) {
            if (this.field_146987_F == 2) {
                this.field_146996_I = itemstack.func_77976_d();
            } else {
                this.field_146996_I = itemstack.func_190916_E();
                for (Slot slot : this.field_147008_s) {
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    ItemStack itemstack2 = slot.func_75211_c();
                    int i = itemstack2.func_190926_b() ? 0 : itemstack2.func_190916_E();
                    Container.func_94525_a(this.field_147008_s, this.field_146987_F, itemstack1, i);
                    int j = Math.min(itemstack1.func_77976_d(), slot.func_178170_b(itemstack1));
                    if (itemstack1.func_190916_E() > j) {
                        itemstack1.func_190920_e(j);
                    }
                    this.field_146996_I -= itemstack1.func_190916_E() - i;
                }
            }
        }
    }

    private Slot func_195360_a(double p_195360_1_, double p_195360_3_) {
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = this.field_147002_h.field_75151_b.get(i);
            if (!this.func_195362_a(slot, p_195360_1_, p_195360_3_) || !slot.func_111238_b()) continue;
            return slot;
        }
        return null;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.Type.MOUSE.func_197944_a(p_mouseClicked_5_);
        boolean flag = this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey);
        Slot slot = this.func_195360_a(p_mouseClicked_1_, p_mouseClicked_3_);
        long i = Util.func_211177_b();
        this.field_146993_M = this.field_146998_K == slot && i - this.field_146997_J < 250L && this.field_146992_L == p_mouseClicked_5_;
        this.field_146995_H = false;
        if (p_mouseClicked_5_ == 0 || p_mouseClicked_5_ == 1 || flag) {
            int j = this.field_147003_i;
            int k = this.field_147009_r;
            boolean flag1 = this.func_195361_a(p_mouseClicked_1_, p_mouseClicked_3_, j, k, p_mouseClicked_5_);
            if (slot != null) {
                flag1 = false;
            }
            int l = -1;
            if (slot != null) {
                l = slot.field_75222_d;
            }
            if (flag1) {
                l = -999;
            }
            if (this.field_146297_k.field_71474_y.field_85185_A && flag1 && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.field_146297_k.func_147108_a(null);
                return true;
            }
            if (l != -1) {
                if (this.field_146297_k.field_71474_y.field_85185_A) {
                    if (slot != null && slot.func_75216_d()) {
                        this.field_147005_v = slot;
                        this.field_147012_x = ItemStack.field_190927_a;
                        this.field_147004_w = p_mouseClicked_5_ == 1;
                    } else {
                        this.field_147005_v = null;
                    }
                } else if (!this.field_147007_t) {
                    if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                        if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                            this.func_184098_a(slot, l, p_mouseClicked_5_, ClickType.CLONE);
                        } else {
                            boolean flag2 = l != -999 && (InputMappings.func_197956_a((int)340) || InputMappings.func_197956_a((int)344));
                            ClickType clicktype = ClickType.PICKUP;
                            if (flag2) {
                                this.field_146994_N = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                                clicktype = ClickType.QUICK_MOVE;
                            } else if (l == -999) {
                                clicktype = ClickType.THROW;
                            }
                            this.func_184098_a(slot, l, p_mouseClicked_5_, clicktype);
                        }
                        this.field_146995_H = true;
                    } else {
                        this.field_147007_t = true;
                        this.field_146988_G = p_mouseClicked_5_;
                        this.field_147008_s.clear();
                        if (p_mouseClicked_5_ == 0) {
                            this.field_146987_F = 0;
                        } else if (p_mouseClicked_5_ == 1) {
                            this.field_146987_F = 1;
                        } else if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                            this.field_146987_F = 2;
                        }
                    }
                }
            }
        }
        this.field_146998_K = slot;
        this.field_146997_J = i;
        this.field_146992_L = p_mouseClicked_5_;
        return true;
    }

    protected boolean func_195361_a(double p_195361_1_, double p_195361_3_, int p_195361_5_, int p_195361_6_, int p_195361_7_) {
        return p_195361_1_ < (double)p_195361_5_ || p_195361_3_ < (double)p_195361_6_ || p_195361_1_ >= (double)(p_195361_5_ + this.field_146999_f) || p_195361_3_ >= (double)(p_195361_6_ + this.field_147000_g);
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        Slot slot = this.func_195360_a(p_mouseDragged_1_, p_mouseDragged_3_);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.field_147005_v != null && this.field_146297_k.field_71474_y.field_85185_A) {
            if (p_mouseDragged_5_ == 0 || p_mouseDragged_5_ == 1) {
                if (this.field_147012_x.func_190926_b()) {
                    if (slot != this.field_147005_v && !this.field_147005_v.func_75211_c().func_190926_b()) {
                        this.field_147012_x = this.field_147005_v.func_75211_c().func_77946_l();
                    }
                } else if (this.field_147012_x.func_190916_E() > 1 && slot != null && Container.func_94527_a(slot, this.field_147012_x, false)) {
                    long i = Util.func_211177_b();
                    if (this.field_146985_D == slot) {
                        if (i - this.field_146986_E > 500L) {
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, 0, ClickType.PICKUP);
                            this.func_184098_a(slot, slot.field_75222_d, 1, ClickType.PICKUP);
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, 0, ClickType.PICKUP);
                            this.field_146986_E = i + 750L;
                            this.field_147012_x.func_190918_g(1);
                        }
                    } else {
                        this.field_146985_D = slot;
                        this.field_146986_E = i;
                    }
                }
            }
        } else if (this.field_147007_t && slot != null && !itemstack.func_190926_b() && (itemstack.func_190916_E() > this.field_147008_s.size() || this.field_146987_F == 2) && Container.func_94527_a(slot, itemstack, true) && slot.func_75214_a(itemstack) && this.field_147002_h.func_94531_b(slot)) {
            this.field_147008_s.add(slot);
            this.func_146980_g();
        }
        return true;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        Slot slot = this.func_195360_a(p_mouseReleased_1_, p_mouseReleased_3_);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        boolean flag = this.func_195361_a(p_mouseReleased_1_, p_mouseReleased_3_, i, j, p_mouseReleased_5_);
        if (slot != null) {
            flag = false;
        }
        InputMappings.Input mouseKey = InputMappings.Type.MOUSE.func_197944_a(p_mouseReleased_5_);
        int k = -1;
        if (slot != null) {
            k = slot.field_75222_d;
        }
        if (flag) {
            k = -999;
        }
        if (this.field_146993_M && slot != null && p_mouseReleased_5_ == 0 && this.field_147002_h.func_94530_a(ItemStack.field_190927_a, slot)) {
            if (GuiContainer.func_146272_n()) {
                if (!this.field_146994_N.func_190926_b()) {
                    for (Slot slot2 : this.field_147002_h.field_75151_b) {
                        if (slot2 == null || !slot2.func_82869_a(this.field_146297_k.field_71439_g) || !slot2.func_75216_d() || !slot2.isSameInventory(slot) || !Container.func_94527_a(slot2, this.field_146994_N, true)) continue;
                        this.func_184098_a(slot2, slot2.field_75222_d, p_mouseReleased_5_, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.func_184098_a(slot, k, p_mouseReleased_5_, ClickType.PICKUP_ALL);
            }
            this.field_146993_M = false;
            this.field_146997_J = 0L;
        } else {
            if (this.field_147007_t && this.field_146988_G != p_mouseReleased_5_) {
                this.field_147007_t = false;
                this.field_147008_s.clear();
                this.field_146995_H = true;
                return true;
            }
            if (this.field_146995_H) {
                this.field_146995_H = false;
                return true;
            }
            if (this.field_147005_v != null && this.field_146297_k.field_71474_y.field_85185_A) {
                if (p_mouseReleased_5_ == 0 || p_mouseReleased_5_ == 1) {
                    if (this.field_147012_x.func_190926_b() && slot != this.field_147005_v) {
                        this.field_147012_x = this.field_147005_v.func_75211_c();
                    }
                    boolean flag2 = Container.func_94527_a(slot, this.field_147012_x, false);
                    if (k != -1 && !this.field_147012_x.func_190926_b() && flag2) {
                        this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, p_mouseReleased_5_, ClickType.PICKUP);
                        this.func_184098_a(slot, k, 0, ClickType.PICKUP);
                        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            this.field_146991_C = ItemStack.field_190927_a;
                        } else {
                            this.func_184098_a(this.field_147005_v, this.field_147005_v.field_75222_d, p_mouseReleased_5_, ClickType.PICKUP);
                            this.field_147011_y = MathHelper.func_76128_c((double)(p_mouseReleased_1_ - (double)i));
                            this.field_147010_z = MathHelper.func_76128_c((double)(p_mouseReleased_3_ - (double)j));
                            this.field_146989_A = this.field_147005_v;
                            this.field_146991_C = this.field_147012_x;
                            this.field_146990_B = Util.func_211177_b();
                        }
                    } else if (!this.field_147012_x.func_190926_b()) {
                        this.field_147011_y = MathHelper.func_76128_c((double)(p_mouseReleased_1_ - (double)i));
                        this.field_147010_z = MathHelper.func_76128_c((double)(p_mouseReleased_3_ - (double)j));
                        this.field_146989_A = this.field_147005_v;
                        this.field_146991_C = this.field_147012_x;
                        this.field_146990_B = Util.func_211177_b();
                    }
                    this.field_147012_x = ItemStack.field_190927_a;
                    this.field_147005_v = null;
                }
            } else if (this.field_147007_t && !this.field_147008_s.isEmpty()) {
                this.func_184098_a(null, -999, Container.func_94534_d(0, this.field_146987_F), ClickType.QUICK_CRAFT);
                for (Slot slot1 : this.field_147008_s) {
                    this.func_184098_a(slot1, slot1.field_75222_d, Container.func_94534_d(1, this.field_146987_F), ClickType.QUICK_CRAFT);
                }
                this.func_184098_a(null, -999, Container.func_94534_d(2, this.field_146987_F), ClickType.QUICK_CRAFT);
            } else if (!this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                    this.func_184098_a(slot, k, p_mouseReleased_5_, ClickType.CLONE);
                } else {
                    boolean flag1;
                    boolean bl = flag1 = k != -999 && (InputMappings.func_197956_a((int)340) || InputMappings.func_197956_a((int)344));
                    if (flag1) {
                        this.field_146994_N = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                    }
                    this.func_184098_a(slot, k, p_mouseReleased_5_, flag1 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.field_146997_J = 0L;
        }
        this.field_147007_t = false;
        return true;
    }

    private boolean func_195362_a(Slot p_195362_1_, double p_195362_2_, double p_195362_4_) {
        return this.func_195359_a(p_195362_1_.field_75223_e, p_195362_1_.field_75221_f, 16, 16, p_195362_2_, p_195362_4_);
    }

    protected boolean func_195359_a(int p_195359_1_, int p_195359_2_, int p_195359_3_, int p_195359_4_, double p_195359_5_, double p_195359_7_) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        return (p_195359_5_ -= (double)i) >= (double)(p_195359_1_ - 1) && p_195359_5_ < (double)(p_195359_1_ + p_195359_3_ + 1) && (p_195359_7_ -= (double)j) >= (double)(p_195359_2_ - 1) && p_195359_7_ < (double)(p_195359_2_ + p_195359_4_ + 1);
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null) {
            slotId = slotIn.field_75222_d;
        }
        this.field_146297_k.field_71442_b.func_187098_a(this.field_147002_h.field_75152_c, slotId, mouseButton, type, this.field_146297_k.field_71439_g);
    }

    @Override
    public boolean func_195120_Y_() {
        return false;
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ == 256 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return true;
        }
        if (this.func_195363_d(p_keyPressed_1_, p_keyPressed_2_)) {
            return true;
        }
        if (this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, 0, ClickType.CLONE);
                return true;
            }
            if (this.field_146297_k.field_71474_y.field_74316_C.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, GuiContainer.func_146271_m() ? 1 : 0, ClickType.THROW);
                return true;
            }
        }
        return false;
    }

    protected boolean func_195363_d(int p_195363_1_, int p_195363_2_) {
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null) {
            for (int i = 0; i < 9; ++i) {
                if (!this.field_146297_k.field_71474_y.field_151456_ac[i].isActiveAndMatches(InputMappings.func_197954_a((int)p_195363_1_, (int)p_195363_2_))) continue;
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, i, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_146281_b() {
        if (this.field_146297_k.field_71439_g != null) {
            this.field_147002_h.func_75134_a(this.field_146297_k.field_71439_g);
        }
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        return this.field_147006_u;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public int getSlotColor(int index) {
        return this.slotColor;
    }
}

