/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.renderer.VideoMode;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ResourcePackInfoClient;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.ClientModLoader;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GameSettings {
    private static final Logger field_151454_ax = LogManager.getLogger();
    private static final Gson field_151450_ay = new Gson();
    private static final Type field_151449_az = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    public static final Splitter field_189990_a = Splitter.on((char)':');
    private static final String[] field_74364_ag = new String[]{"options.particles.all", "options.particles.decreased", "options.particles.minimal"};
    private static final String[] field_98303_au = new String[]{"options.ao.off", "options.ao.min", "options.ao.max"};
    private static final String[] field_181149_aW = new String[]{"options.off", "options.clouds.fast", "options.clouds.fancy"};
    private static final String[] field_186713_aK = new String[]{"options.off", "options.attack.crosshair", "options.attack.hotbar"};
    public static final String[] field_193632_b = new String[]{"options.narrator.off", "options.narrator.all", "options.narrator.chat", "options.narrator.system"};
    public double field_74341_c = 0.5;
    public boolean field_74338_d;
    public int field_151451_c = -1;
    public boolean field_74336_f = true;
    public boolean field_151448_g = true;
    public int field_74350_i = 120;
    public int field_74345_l = 2;
    public boolean field_74347_j = true;
    public int field_74348_k = 2;
    public List<String> field_151453_l = Lists.newArrayList();
    public List<String> field_183018_l = Lists.newArrayList();
    public EntityPlayer.EnumChatVisibility field_74343_n = EntityPlayer.EnumChatVisibility.FULL;
    public boolean field_74344_o = true;
    public boolean field_74359_p = true;
    public boolean field_74358_q = true;
    public double field_74357_r = 1.0;
    public boolean field_74355_t = true;
    public boolean field_74353_u;
    @Nullable
    public String field_198019_u;
    public boolean field_74352_v = true;
    public boolean field_178881_t = true;
    public boolean field_178879_v;
    public boolean field_80005_w;
    public boolean field_82882_x;
    public boolean field_82881_y = true;
    private final Set<EnumPlayerModelParts> field_178882_aU = Sets.newHashSet((Object[])EnumPlayerModelParts.values());
    public boolean field_85185_A;
    public EnumHandSide field_186715_A = EnumHandSide.RIGHT;
    public int field_92118_B;
    public int field_92119_C;
    public boolean field_92117_D = true;
    public double field_96691_E = 1.0;
    public double field_96692_F = 1.0;
    public double field_96693_G = 0.44366195797920227;
    public double field_96694_H = 1.0;
    public int field_151442_I = 4;
    private final Map<SoundCategory, Float> field_186714_aM = Maps.newEnumMap(SoundCategory.class);
    public boolean field_181150_U = true;
    public boolean field_181151_V = true;
    public int field_186716_M = 1;
    public boolean field_189422_N;
    public boolean field_186717_N;
    public boolean field_183509_X = true;
    public boolean field_189989_R = true;
    public TutorialSteps field_193631_S = TutorialSteps.MOVEMENT;
    public boolean field_198018_T = true;
    public int field_205217_U = 2;
    public double field_208033_V = 1.0;
    public int field_209231_W = 1;
    public KeyBinding field_74351_w = new KeyBinding("key.forward", 87, "key.categories.movement");
    public KeyBinding field_74370_x = new KeyBinding("key.left", 65, "key.categories.movement");
    public KeyBinding field_74368_y = new KeyBinding("key.back", 83, "key.categories.movement");
    public KeyBinding field_74366_z = new KeyBinding("key.right", 68, "key.categories.movement");
    public KeyBinding field_74314_A = new KeyBinding("key.jump", 32, "key.categories.movement");
    public KeyBinding field_74311_E = new KeyBinding("key.sneak", 340, "key.categories.movement");
    public KeyBinding field_151444_V = new KeyBinding("key.sprint", 341, "key.categories.movement");
    public KeyBinding field_151445_Q = new KeyBinding("key.inventory", 69, "key.categories.inventory");
    public KeyBinding field_186718_X = new KeyBinding("key.swapHands", 70, "key.categories.inventory");
    public KeyBinding field_74316_C = new KeyBinding("key.drop", 81, "key.categories.inventory");
    public KeyBinding field_74313_G = new KeyBinding("key.use", InputMappings.Type.MOUSE, 1, "key.categories.gameplay");
    public KeyBinding field_74312_F = new KeyBinding("key.attack", InputMappings.Type.MOUSE, 0, "key.categories.gameplay");
    public KeyBinding field_74322_I = new KeyBinding("key.pickItem", InputMappings.Type.MOUSE, 2, "key.categories.gameplay");
    public KeyBinding field_74310_D = new KeyBinding("key.chat", 84, "key.categories.multiplayer");
    public KeyBinding field_74321_H = new KeyBinding("key.playerlist", 258, "key.categories.multiplayer");
    public KeyBinding field_74323_J = new KeyBinding("key.command", 47, "key.categories.multiplayer");
    public KeyBinding field_151447_Z = new KeyBinding("key.screenshot", 291, "key.categories.misc");
    public KeyBinding field_151457_aa = new KeyBinding("key.togglePerspective", 294, "key.categories.misc");
    public KeyBinding field_151458_ab = new KeyBinding("key.smoothCamera", -1, "key.categories.misc");
    public KeyBinding field_152395_am = new KeyBinding("key.fullscreen", 300, "key.categories.misc");
    public KeyBinding field_178883_an = new KeyBinding("key.spectatorOutlines", -1, "key.categories.misc");
    public KeyBinding field_194146_ao = new KeyBinding("key.advancements", 76, "key.categories.misc");
    public KeyBinding[] field_151456_ac = new KeyBinding[]{new KeyBinding("key.hotbar.1", 49, "key.categories.inventory"), new KeyBinding("key.hotbar.2", 50, "key.categories.inventory"), new KeyBinding("key.hotbar.3", 51, "key.categories.inventory"), new KeyBinding("key.hotbar.4", 52, "key.categories.inventory"), new KeyBinding("key.hotbar.5", 53, "key.categories.inventory"), new KeyBinding("key.hotbar.6", 54, "key.categories.inventory"), new KeyBinding("key.hotbar.7", 55, "key.categories.inventory"), new KeyBinding("key.hotbar.8", 56, "key.categories.inventory"), new KeyBinding("key.hotbar.9", 57, "key.categories.inventory")};
    public KeyBinding field_193629_ap = new KeyBinding("key.saveToolbarActivator", 67, "key.categories.creative");
    public KeyBinding field_193630_aq = new KeyBinding("key.loadToolbarActivator", 88, "key.categories.creative");
    public KeyBinding[] field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])new KeyBinding[]{this.field_74312_F, this.field_74313_G, this.field_74351_w, this.field_74370_x, this.field_74368_y, this.field_74366_z, this.field_74314_A, this.field_74311_E, this.field_151444_V, this.field_74316_C, this.field_151445_Q, this.field_74310_D, this.field_74321_H, this.field_74322_I, this.field_74323_J, this.field_151447_Z, this.field_151457_aa, this.field_151458_ab, this.field_152395_am, this.field_178883_an, this.field_186718_X, this.field_193629_ap, this.field_193630_aq, this.field_194146_ao}, (Object[])this.field_151456_ac);
    protected Minecraft field_74317_L;
    private File field_74354_ai;
    public EnumDifficulty field_74318_M = EnumDifficulty.NORMAL;
    public boolean field_74319_N;
    public int field_74320_O;
    public boolean field_74330_P;
    public boolean field_74329_Q;
    public boolean field_181657_aC;
    public String field_74332_R = "";
    public boolean field_74326_T;
    public boolean field_74325_U;
    public double field_74334_X = 70.0;
    public double field_74333_Y;
    public float field_151452_as;
    public int field_74335_Z;
    public int field_74362_aa;
    public int field_192571_R;
    public String field_74363_ab = "en_us";
    public boolean field_211842_aO;
    private boolean needsBlockModelRefresh = false;

    public GameSettings(Minecraft mcIn, File mcDataDir) {
        this.setForgeKeybindProperties();
        this.field_74317_L = mcIn;
        this.field_74354_ai = new File(mcDataDir, "options.txt");
        if (mcIn.func_147111_S() && Runtime.getRuntime().maxMemory() >= 1000000000L) {
            Options.RENDER_DISTANCE.func_148263_a(32.0f);
        } else {
            Options.RENDER_DISTANCE.func_148263_a(16.0f);
        }
        this.field_151451_c = mcIn.func_147111_S() ? 12 : 8;
        this.func_74300_a();
    }

    public GameSettings() {
        this.setForgeKeybindProperties();
    }

    public void func_198014_a(KeyBinding keyBindingIn, InputMappings.Input inputIn) {
        keyBindingIn.func_197979_b(inputIn);
        this.func_74303_b();
    }

    public void func_198016_a(Options option, double value) {
        if (option == Options.SENSITIVITY) {
            this.field_74341_c = value;
        }
        if (option == Options.FOV) {
            this.field_74334_X = value;
        }
        if (option == Options.GAMMA) {
            this.field_74333_Y = value;
        }
        if (option == Options.FRAMERATE_LIMIT) {
            this.field_74350_i = (int)value;
        }
        if (option == Options.CHAT_OPACITY) {
            this.field_74357_r = value;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (option == Options.CHAT_HEIGHT_FOCUSED) {
            this.field_96694_H = value;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (option == Options.CHAT_HEIGHT_UNFOCUSED) {
            this.field_96693_G = value;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (option == Options.CHAT_WIDTH) {
            this.field_96692_F = value;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (option == Options.CHAT_SCALE) {
            this.field_96691_E = value;
            this.field_74317_L.field_71456_v.func_146158_b().func_146245_b();
        }
        if (option == Options.MIPMAP_LEVELS) {
            int i = this.field_151442_I;
            this.field_151442_I = (int)value;
            if ((double)i != value) {
                this.field_74317_L.func_147117_R().func_147633_a(this.field_151442_I);
                this.field_74317_L.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                this.field_74317_L.func_147117_R().func_174937_a(false, this.field_151442_I > 0);
                this.needsBlockModelRefresh = true;
            }
        }
        if (option == Options.RENDER_DISTANCE) {
            this.field_151451_c = (int)value;
            this.field_74317_L.field_71438_f.func_174979_m();
        }
        if (option == Options.BIOME_BLEND_RADIUS) {
            this.field_205217_U = MathHelper.func_76125_a((int)((int)value), (int)0, (int)7);
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (option == Options.FULLSCREEN_RESOLUTION) {
            this.field_74317_L.field_195558_d.func_198104_b((int)value);
        }
        if (option == Options.MOUSE_WHEEL_SENSITIVITY) {
            this.field_208033_V = value;
        }
    }

    public void func_74306_a(Options settingsOption, int value) {
        if (settingsOption == Options.RENDER_DISTANCE) {
            this.func_198016_a(settingsOption, MathHelper.func_151237_a((double)(this.field_151451_c + value), (double)settingsOption.func_198007_e(), (double)settingsOption.func_198009_f()));
        }
        if (settingsOption == Options.MAIN_HAND) {
            this.field_186715_A = this.field_186715_A.func_188468_a();
        }
        if (settingsOption == Options.INVERT_MOUSE) {
            boolean bl = this.field_74338_d = !this.field_74338_d;
        }
        if (settingsOption == Options.GUI_SCALE) {
            this.field_74335_Z = Integer.remainderUnsigned(this.field_74335_Z + value, this.field_74317_L.field_195558_d.func_198078_c(0) + 1);
        }
        if (settingsOption == Options.PARTICLES) {
            this.field_74362_aa = (this.field_74362_aa + value) % 3;
        }
        if (settingsOption == Options.VIEW_BOBBING) {
            boolean bl = this.field_74336_f = !this.field_74336_f;
        }
        if (settingsOption == Options.RENDER_CLOUDS) {
            this.field_74345_l = (this.field_74345_l + value) % 3;
        }
        if (settingsOption == Options.FORCE_UNICODE_FONT) {
            this.field_211842_aO = !this.field_211842_aO;
            this.field_74317_L.func_211500_ak().func_211825_a(this.field_211842_aO);
        }
        if (settingsOption == Options.FBO_ENABLE) {
            boolean bl = this.field_151448_g = !this.field_151448_g;
        }
        if (settingsOption == Options.GRAPHICS) {
            this.field_74347_j = !this.field_74347_j;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (settingsOption == Options.AMBIENT_OCCLUSION) {
            this.field_74348_k = (this.field_74348_k + value) % 3;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (settingsOption == Options.CHAT_VISIBILITY) {
            this.field_74343_n = EntityPlayer.EnumChatVisibility.func_151426_a((this.field_74343_n.func_151428_a() + value) % 3);
        }
        if (settingsOption == Options.CHAT_COLOR) {
            boolean bl = this.field_74344_o = !this.field_74344_o;
        }
        if (settingsOption == Options.CHAT_LINKS) {
            boolean bl = this.field_74359_p = !this.field_74359_p;
        }
        if (settingsOption == Options.CHAT_LINKS_PROMPT) {
            boolean bl = this.field_74358_q = !this.field_74358_q;
        }
        if (settingsOption == Options.SNOOPER_ENABLED) {
            boolean bl = this.field_74355_t = !this.field_74355_t;
        }
        if (settingsOption == Options.TOUCHSCREEN) {
            boolean bl = this.field_85185_A = !this.field_85185_A;
        }
        if (settingsOption == Options.USE_FULLSCREEN) {
            boolean bl = this.field_74353_u = !this.field_74353_u;
            if (this.field_74317_L.field_195558_d.func_198113_j() != this.field_74353_u) {
                this.field_74317_L.field_195558_d.func_198077_g();
            }
        }
        if (settingsOption == Options.ENABLE_VSYNC) {
            this.field_74352_v = !this.field_74352_v;
            this.field_74317_L.field_195558_d.func_209548_c();
        }
        if (settingsOption == Options.USE_VBO) {
            this.field_178881_t = !this.field_178881_t;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (settingsOption == Options.REDUCED_DEBUG_INFO) {
            boolean bl = this.field_178879_v = !this.field_178879_v;
        }
        if (settingsOption == Options.ENTITY_SHADOWS) {
            boolean bl = this.field_181151_V = !this.field_181151_V;
        }
        if (settingsOption == Options.ATTACK_INDICATOR) {
            this.field_186716_M = (this.field_186716_M + value) % 3;
        }
        if (settingsOption == Options.SHOW_SUBTITLES) {
            boolean bl = this.field_186717_N = !this.field_186717_N;
        }
        if (settingsOption == Options.REALMS_NOTIFICATIONS) {
            boolean bl = this.field_183509_X = !this.field_183509_X;
        }
        if (settingsOption == Options.AUTO_JUMP) {
            boolean bl = this.field_189989_R = !this.field_189989_R;
        }
        if (settingsOption == Options.AUTO_SUGGESTIONS) {
            boolean bl = this.field_198018_T = !this.field_198018_T;
        }
        if (settingsOption == Options.NARRATOR) {
            this.field_192571_R = NarratorChatListener.field_193643_a.func_193640_a() ? (this.field_192571_R + value) % field_193632_b.length : 0;
            NarratorChatListener.field_193643_a.func_193641_a(this.field_192571_R);
        }
        this.func_74303_b();
    }

    public double func_198015_a(Options option) {
        if (option == Options.BIOME_BLEND_RADIUS) {
            return this.field_205217_U;
        }
        if (option == Options.FOV) {
            return this.field_74334_X;
        }
        if (option == Options.GAMMA) {
            return this.field_74333_Y;
        }
        if (option == Options.SATURATION) {
            return this.field_151452_as;
        }
        if (option == Options.SENSITIVITY) {
            return this.field_74341_c;
        }
        if (option == Options.CHAT_OPACITY) {
            return this.field_74357_r;
        }
        if (option == Options.CHAT_HEIGHT_FOCUSED) {
            return this.field_96694_H;
        }
        if (option == Options.CHAT_HEIGHT_UNFOCUSED) {
            return this.field_96693_G;
        }
        if (option == Options.CHAT_SCALE) {
            return this.field_96691_E;
        }
        if (option == Options.CHAT_WIDTH) {
            return this.field_96692_F;
        }
        if (option == Options.FRAMERATE_LIMIT) {
            return this.field_74350_i;
        }
        if (option == Options.MIPMAP_LEVELS) {
            return this.field_151442_I;
        }
        if (option == Options.RENDER_DISTANCE) {
            return this.field_151451_c;
        }
        if (option == Options.FULLSCREEN_RESOLUTION) {
            return this.field_74317_L.field_195558_d.func_198090_e();
        }
        return option == Options.MOUSE_WHEEL_SENSITIVITY ? this.field_208033_V : 0.0;
    }

    public boolean func_74308_b(Options settingOption) {
        switch (settingOption) {
            case INVERT_MOUSE: {
                return this.field_74338_d;
            }
            case VIEW_BOBBING: {
                return this.field_74336_f;
            }
            case FBO_ENABLE: {
                return this.field_151448_g;
            }
            case CHAT_COLOR: {
                return this.field_74344_o;
            }
            case CHAT_LINKS: {
                return this.field_74359_p;
            }
            case CHAT_LINKS_PROMPT: {
                return this.field_74358_q;
            }
            case SNOOPER_ENABLED: {
                if (this.field_74355_t) {
                    // empty if block
                }
                return false;
            }
            case USE_FULLSCREEN: {
                return this.field_74353_u;
            }
            case ENABLE_VSYNC: {
                return this.field_74352_v;
            }
            case USE_VBO: {
                return this.field_178881_t;
            }
            case TOUCHSCREEN: {
                return this.field_85185_A;
            }
            case FORCE_UNICODE_FONT: {
                return this.field_211842_aO;
            }
            case REDUCED_DEBUG_INFO: {
                return this.field_178879_v;
            }
            case ENTITY_SHADOWS: {
                return this.field_181151_V;
            }
            case SHOW_SUBTITLES: {
                return this.field_186717_N;
            }
            case REALMS_NOTIFICATIONS: {
                return this.field_183509_X;
            }
            case ENABLE_WEAK_ATTACKS: {
                return this.field_189422_N;
            }
            case AUTO_JUMP: {
                return this.field_189989_R;
            }
            case AUTO_SUGGESTIONS: {
                return this.field_198018_T;
            }
        }
        return false;
    }

    private static String func_74299_a(String[] strArray, int index) {
        if (index < 0 || index >= strArray.length) {
            index = 0;
        }
        return I18n.func_135052_a(strArray[index], new Object[0]);
    }

    public String func_74297_c(Options settingOption) {
        String s = I18n.func_135052_a(settingOption.func_74378_d(), new Object[0]) + ": ";
        if (settingOption.func_74380_a()) {
            double d1 = this.func_198015_a(settingOption);
            double d0 = settingOption.func_198008_a(d1);
            if (settingOption == Options.SENSITIVITY) {
                if (d0 == 0.0) {
                    return s + I18n.func_135052_a("options.sensitivity.min", new Object[0]);
                }
                return d0 == 1.0 ? s + I18n.func_135052_a("options.sensitivity.max", new Object[0]) : s + (int)(d0 * 200.0) + "%";
            }
            if (settingOption == Options.BIOME_BLEND_RADIUS) {
                if (d0 == 0.0) {
                    return s + I18n.func_135052_a("options.off", new Object[0]);
                }
                int i = this.field_205217_U * 2 + 1;
                return s + i + "x" + i;
            }
            if (settingOption == Options.FOV) {
                if (d1 == 70.0) {
                    return s + I18n.func_135052_a("options.fov.min", new Object[0]);
                }
                return d1 == 110.0 ? s + I18n.func_135052_a("options.fov.max", new Object[0]) : s + (int)d1;
            }
            if (settingOption == Options.FRAMERATE_LIMIT) {
                return d1 == settingOption.field_148272_O ? s + I18n.func_135052_a("options.framerateLimit.max", new Object[0]) : s + I18n.func_135052_a("options.framerate", (int)d1);
            }
            if (settingOption == Options.RENDER_CLOUDS) {
                return d1 == settingOption.field_148271_N ? s + I18n.func_135052_a("options.cloudHeight.min", new Object[0]) : s + ((int)d1 + 128);
            }
            if (settingOption == Options.GAMMA) {
                if (d0 == 0.0) {
                    return s + I18n.func_135052_a("options.gamma.min", new Object[0]);
                }
                return d0 == 1.0 ? s + I18n.func_135052_a("options.gamma.max", new Object[0]) : s + "+" + (int)(d0 * 100.0) + "%";
            }
            if (settingOption == Options.SATURATION) {
                return s + (int)(d0 * 400.0) + "%";
            }
            if (settingOption == Options.CHAT_OPACITY) {
                return s + (int)(d0 * 90.0 + 10.0) + "%";
            }
            if (settingOption == Options.CHAT_HEIGHT_UNFOCUSED) {
                return s + GuiNewChat.func_194816_c((double)d0) + "px";
            }
            if (settingOption == Options.CHAT_HEIGHT_FOCUSED) {
                return s + GuiNewChat.func_194816_c((double)d0) + "px";
            }
            if (settingOption == Options.CHAT_WIDTH) {
                return s + GuiNewChat.func_194814_b((double)d0) + "px";
            }
            if (settingOption == Options.RENDER_DISTANCE) {
                return s + I18n.func_135052_a("options.chunks", (int)d1);
            }
            if (settingOption == Options.MOUSE_WHEEL_SENSITIVITY) {
                return d0 == 1.0 ? s + I18n.func_135052_a("options.mouseWheelSensitivity.default", new Object[0]) : s + "+" + (int)d0 + "." + (int)(d0 * 10.0) % 10;
            }
            if (settingOption == Options.MIPMAP_LEVELS) {
                return d1 == 0.0 ? s + I18n.func_135052_a("options.off", new Object[0]) : s + (int)d1;
            }
            if (settingOption == Options.FULLSCREEN_RESOLUTION) {
                return d1 == 0.0 ? s + I18n.func_135052_a("options.fullscreen.current", new Object[0]) : s + this.field_74317_L.field_195558_d.func_198088_a((int)d1 - 1);
            }
            return d0 == 0.0 ? s + I18n.func_135052_a("options.off", new Object[0]) : s + (int)(d0 * 100.0) + "%";
        }
        if (settingOption.func_74382_b()) {
            boolean flag = this.func_74308_b(settingOption);
            return flag ? s + I18n.func_135052_a("options.on", new Object[0]) : s + I18n.func_135052_a("options.off", new Object[0]);
        }
        if (settingOption == Options.MAIN_HAND) {
            return s + this.field_186715_A;
        }
        if (settingOption == Options.GUI_SCALE) {
            return s + (this.field_74335_Z == 0 ? I18n.func_135052_a("options.guiScale.auto", new Object[0]) : Integer.valueOf(this.field_74335_Z));
        }
        if (settingOption == Options.CHAT_VISIBILITY) {
            return s + I18n.func_135052_a(this.field_74343_n.func_151429_b(), new Object[0]);
        }
        if (settingOption == Options.PARTICLES) {
            return s + GameSettings.func_74299_a(field_74364_ag, this.field_74362_aa);
        }
        if (settingOption == Options.AMBIENT_OCCLUSION) {
            return s + GameSettings.func_74299_a(field_98303_au, this.field_74348_k);
        }
        if (settingOption == Options.RENDER_CLOUDS) {
            return s + GameSettings.func_74299_a(field_181149_aW, this.field_74345_l);
        }
        if (settingOption == Options.GRAPHICS) {
            if (this.field_74347_j) {
                return s + I18n.func_135052_a("options.graphics.fancy", new Object[0]);
            }
            String s1 = "options.graphics.fast";
            return s + I18n.func_135052_a("options.graphics.fast", new Object[0]);
        }
        if (settingOption == Options.ATTACK_INDICATOR) {
            return s + GameSettings.func_74299_a(field_186713_aK, this.field_186716_M);
        }
        if (settingOption == Options.NARRATOR) {
            return NarratorChatListener.field_193643_a.func_193640_a() ? s + GameSettings.func_74299_a(field_193632_b, this.field_192571_R) : s + I18n.func_135052_a("options.narrator.notavailable", new Object[0]);
        }
        return s;
    }

    public void func_74300_a() {
        try {
            if (!this.field_74354_ai.exists()) {
                return;
            }
            this.field_186714_aM.clear();
            List list = IOUtils.readLines((InputStream)new FileInputStream(this.field_74354_ai));
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            for (String s : list) {
                try {
                    Iterator iterator = field_189990_a.omitEmptyStrings().limit(2).split((CharSequence)s).iterator();
                    nbttagcompound.func_74778_a((String)iterator.next(), (String)iterator.next());
                }
                catch (Exception var10) {
                    field_151454_ax.warn("Skipping bad option: {}", (Object)s);
                }
            }
            nbttagcompound = this.func_189988_a(nbttagcompound);
            for (String s1 : nbttagcompound.func_150296_c()) {
                String s2 = nbttagcompound.func_74779_i(s1);
                try {
                    if ("mouseSensitivity".equals(s1)) {
                        this.field_74341_c = this.func_74305_a(s2);
                    }
                    if ("fov".equals(s1)) {
                        this.field_74334_X = this.func_74305_a(s2) * 40.0f + 70.0f;
                    }
                    if ("gamma".equals(s1)) {
                        this.field_74333_Y = this.func_74305_a(s2);
                    }
                    if ("saturation".equals(s1)) {
                        this.field_151452_as = this.func_74305_a(s2);
                    }
                    if ("invertYMouse".equals(s1)) {
                        this.field_74338_d = "true".equals(s2);
                    }
                    if ("renderDistance".equals(s1)) {
                        this.field_151451_c = Integer.parseInt(s2);
                    }
                    if ("guiScale".equals(s1)) {
                        this.field_74335_Z = Integer.parseInt(s2);
                    }
                    if ("particles".equals(s1)) {
                        this.field_74362_aa = Integer.parseInt(s2);
                    }
                    if ("bobView".equals(s1)) {
                        this.field_74336_f = "true".equals(s2);
                    }
                    if ("maxFps".equals(s1)) {
                        this.field_74350_i = Integer.parseInt(s2);
                    }
                    if ("fboEnable".equals(s1)) {
                        this.field_151448_g = "true".equals(s2);
                    }
                    if ("difficulty".equals(s1)) {
                        this.field_74318_M = EnumDifficulty.func_151523_a((int)Integer.parseInt(s2));
                    }
                    if ("fancyGraphics".equals(s1)) {
                        this.field_74347_j = "true".equals(s2);
                    }
                    if ("tutorialStep".equals(s1)) {
                        this.field_193631_S = TutorialSteps.func_193307_a((String)s2);
                    }
                    if ("ao".equals(s1)) {
                        this.field_74348_k = "true".equals(s2) ? 2 : ("false".equals(s2) ? 0 : Integer.parseInt(s2));
                    }
                    if ("renderClouds".equals(s1)) {
                        if ("true".equals(s2)) {
                            this.field_74345_l = 2;
                        } else if ("false".equals(s2)) {
                            this.field_74345_l = 0;
                        } else if ("fast".equals(s2)) {
                            this.field_74345_l = 1;
                        }
                    }
                    if ("attackIndicator".equals(s1)) {
                        if ("0".equals(s2)) {
                            this.field_186716_M = 0;
                        } else if ("1".equals(s2)) {
                            this.field_186716_M = 1;
                        } else if ("2".equals(s2)) {
                            this.field_186716_M = 2;
                        }
                    }
                    if ("resourcePacks".equals(s1)) {
                        this.field_151453_l = (List)JsonUtils.func_193840_a((Gson)field_151450_ay, (String)s2, (Type)field_151449_az);
                        if (this.field_151453_l == null) {
                            this.field_151453_l = Lists.newArrayList();
                        }
                    }
                    if ("incompatibleResourcePacks".equals(s1)) {
                        this.field_183018_l = (List)JsonUtils.func_193840_a((Gson)field_151450_ay, (String)s2, (Type)field_151449_az);
                        if (this.field_183018_l == null) {
                            this.field_183018_l = Lists.newArrayList();
                        }
                    }
                    if ("lastServer".equals(s1)) {
                        this.field_74332_R = s2;
                    }
                    if ("lang".equals(s1)) {
                        this.field_74363_ab = s2;
                    }
                    if ("chatVisibility".equals(s1)) {
                        this.field_74343_n = EntityPlayer.EnumChatVisibility.func_151426_a(Integer.parseInt(s2));
                    }
                    if ("chatColors".equals(s1)) {
                        this.field_74344_o = "true".equals(s2);
                    }
                    if ("chatLinks".equals(s1)) {
                        this.field_74359_p = "true".equals(s2);
                    }
                    if ("chatLinksPrompt".equals(s1)) {
                        this.field_74358_q = "true".equals(s2);
                    }
                    if ("chatOpacity".equals(s1)) {
                        this.field_74357_r = this.func_74305_a(s2);
                    }
                    if ("snooperEnabled".equals(s1)) {
                        this.field_74355_t = "true".equals(s2);
                    }
                    if ("fullscreen".equals(s1)) {
                        this.field_74353_u = "true".equals(s2);
                    }
                    if ("fullscreenResolution".equals(s1)) {
                        this.field_198019_u = s2;
                    }
                    if ("enableVsync".equals(s1)) {
                        this.field_74352_v = "true".equals(s2);
                    }
                    if ("useVbo".equals(s1)) {
                        this.field_178881_t = "true".equals(s2);
                    }
                    if ("hideServerAddress".equals(s1)) {
                        this.field_80005_w = "true".equals(s2);
                    }
                    if ("advancedItemTooltips".equals(s1)) {
                        this.field_82882_x = "true".equals(s2);
                    }
                    if ("pauseOnLostFocus".equals(s1)) {
                        this.field_82881_y = "true".equals(s2);
                    }
                    if ("touchscreen".equals(s1)) {
                        this.field_85185_A = "true".equals(s2);
                    }
                    if ("overrideHeight".equals(s1)) {
                        this.field_92119_C = Integer.parseInt(s2);
                    }
                    if ("overrideWidth".equals(s1)) {
                        this.field_92118_B = Integer.parseInt(s2);
                    }
                    if ("heldItemTooltips".equals(s1)) {
                        this.field_92117_D = "true".equals(s2);
                    }
                    if ("chatHeightFocused".equals(s1)) {
                        this.field_96694_H = this.func_74305_a(s2);
                    }
                    if ("chatHeightUnfocused".equals(s1)) {
                        this.field_96693_G = this.func_74305_a(s2);
                    }
                    if ("chatScale".equals(s1)) {
                        this.field_96691_E = this.func_74305_a(s2);
                    }
                    if ("chatWidth".equals(s1)) {
                        this.field_96692_F = this.func_74305_a(s2);
                    }
                    if ("mipmapLevels".equals(s1)) {
                        this.field_151442_I = Integer.parseInt(s2);
                    }
                    if ("forceUnicodeFont".equals(s1)) {
                        this.field_211842_aO = "true".equals(s2);
                    }
                    if ("reducedDebugInfo".equals(s1)) {
                        this.field_178879_v = "true".equals(s2);
                    }
                    if ("useNativeTransport".equals(s1)) {
                        this.field_181150_U = "true".equals(s2);
                    }
                    if ("entityShadows".equals(s1)) {
                        this.field_181151_V = "true".equals(s2);
                    }
                    if ("mainHand".equals(s1)) {
                        EnumHandSide enumHandSide = this.field_186715_A = "left".equals(s2) ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
                    }
                    if ("showSubtitles".equals(s1)) {
                        this.field_186717_N = "true".equals(s2);
                    }
                    if ("realmsNotifications".equals(s1)) {
                        this.field_183509_X = "true".equals(s2);
                    }
                    if ("enableWeakAttacks".equals(s1)) {
                        this.field_189422_N = "true".equals(s2);
                    }
                    if ("autoJump".equals(s1)) {
                        this.field_189989_R = "true".equals(s2);
                    }
                    if ("narrator".equals(s1)) {
                        this.field_192571_R = Integer.parseInt(s2);
                    }
                    if ("autoSuggestions".equals(s1)) {
                        this.field_198018_T = "true".equals(s2);
                    }
                    if ("biomeBlendRadius".equals(s1)) {
                        this.field_205217_U = Integer.parseInt(s2);
                    }
                    if ("mouseWheelSensitivity".equals(s1)) {
                        this.field_208033_V = this.func_74305_a(s2);
                    }
                    if ("glDebugVerbosity".equals(s1)) {
                        this.field_209231_W = Integer.parseInt(s2);
                    }
                    for (KeyBinding keyBinding : this.field_74324_K) {
                        if (!s1.equals("key_" + keyBinding.func_151464_g())) continue;
                        if (s2.indexOf(58) != -1) {
                            String[] pts = s2.split(":");
                            keyBinding.setKeyModifierAndCode(KeyModifier.valueFromString((String)pts[1]), InputMappings.func_197955_a((String)pts[0]));
                            continue;
                        }
                        keyBinding.setKeyModifierAndCode(KeyModifier.NONE, InputMappings.func_197955_a((String)s2));
                    }
                    for (KeyBinding keyBinding : SoundCategory.values()) {
                        if (!s1.equals("soundCategory_" + keyBinding.func_187948_a())) continue;
                        this.field_186714_aM.put((SoundCategory)keyBinding, Float.valueOf(this.func_74305_a(s2)));
                    }
                    for (KeyBinding keyBinding : EnumPlayerModelParts.values()) {
                        if (!s1.equals("modelPart_" + keyBinding.func_179329_c())) continue;
                        this.func_178878_a((EnumPlayerModelParts)keyBinding, "true".equals(s2));
                    }
                }
                catch (Exception var11) {
                    field_151454_ax.warn("Skipping bad option: {}:{}", (Object)s1, (Object)s2);
                }
            }
            KeyBinding.func_74508_b();
        }
        catch (Exception exception) {
            field_151454_ax.error("Failed to load options", (Throwable)exception);
        }
    }

    private NBTTagCompound func_189988_a(NBTTagCompound nbt) {
        int i = 0;
        try {
            i = Integer.parseInt(nbt.func_74779_i("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NBTUtil.func_210822_a((DataFixer)this.field_74317_L.func_184126_aj(), (DSL.TypeReference)DataFixTypes.OPTIONS, (NBTTagCompound)nbt, (int)i);
    }

    private float func_74305_a(String str) {
        if ("true".equals(str)) {
            return 1.0f;
        }
        return "false".equals(str) ? 0.0f : Float.parseFloat(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_74303_b() {
        if (ClientModLoader.isLoading()) {
            return;
        }
        PrintWriter printwriter = null;
        try {
            printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.field_74354_ai), StandardCharsets.UTF_8));
            printwriter.println("version:1631");
            printwriter.println("invertYMouse:" + this.field_74338_d);
            printwriter.println("mouseSensitivity:" + this.field_74341_c);
            printwriter.println("fov:" + (this.field_74334_X - 70.0) / 40.0);
            printwriter.println("gamma:" + this.field_74333_Y);
            printwriter.println("saturation:" + this.field_151452_as);
            printwriter.println("renderDistance:" + this.field_151451_c);
            printwriter.println("guiScale:" + this.field_74335_Z);
            printwriter.println("particles:" + this.field_74362_aa);
            printwriter.println("bobView:" + this.field_74336_f);
            printwriter.println("maxFps:" + this.field_74350_i);
            printwriter.println("fboEnable:" + this.field_151448_g);
            printwriter.println("difficulty:" + this.field_74318_M.func_151525_a());
            printwriter.println("fancyGraphics:" + this.field_74347_j);
            printwriter.println("ao:" + this.field_74348_k);
            printwriter.println("biomeBlendRadius:" + this.field_205217_U);
            switch (this.field_74345_l) {
                case 0: {
                    printwriter.println("renderClouds:false");
                    break;
                }
                case 1: {
                    printwriter.println("renderClouds:fast");
                    break;
                }
                case 2: {
                    printwriter.println("renderClouds:true");
                }
            }
            printwriter.println("resourcePacks:" + field_151450_ay.toJson(this.field_151453_l));
            printwriter.println("incompatibleResourcePacks:" + field_151450_ay.toJson(this.field_183018_l));
            printwriter.println("lastServer:" + this.field_74332_R);
            printwriter.println("lang:" + this.field_74363_ab);
            printwriter.println("chatVisibility:" + this.field_74343_n.func_151428_a());
            printwriter.println("chatColors:" + this.field_74344_o);
            printwriter.println("chatLinks:" + this.field_74359_p);
            printwriter.println("chatLinksPrompt:" + this.field_74358_q);
            printwriter.println("chatOpacity:" + this.field_74357_r);
            printwriter.println("snooperEnabled:" + this.field_74355_t);
            printwriter.println("fullscreen:" + this.field_74353_u);
            if (this.field_74317_L.field_195558_d.func_198106_d().isPresent()) {
                printwriter.println("fullscreenResolution:" + ((VideoMode)this.field_74317_L.field_195558_d.func_198106_d().get()).func_198066_g());
            }
            printwriter.println("enableVsync:" + this.field_74352_v);
            printwriter.println("useVbo:" + this.field_178881_t);
            printwriter.println("hideServerAddress:" + this.field_80005_w);
            printwriter.println("advancedItemTooltips:" + this.field_82882_x);
            printwriter.println("pauseOnLostFocus:" + this.field_82881_y);
            printwriter.println("touchscreen:" + this.field_85185_A);
            printwriter.println("overrideWidth:" + this.field_92118_B);
            printwriter.println("overrideHeight:" + this.field_92119_C);
            printwriter.println("heldItemTooltips:" + this.field_92117_D);
            printwriter.println("chatHeightFocused:" + this.field_96694_H);
            printwriter.println("chatHeightUnfocused:" + this.field_96693_G);
            printwriter.println("chatScale:" + this.field_96691_E);
            printwriter.println("chatWidth:" + this.field_96692_F);
            printwriter.println("mipmapLevels:" + this.field_151442_I);
            printwriter.println("forceUnicodeFont:" + this.field_211842_aO);
            printwriter.println("reducedDebugInfo:" + this.field_178879_v);
            printwriter.println("useNativeTransport:" + this.field_181150_U);
            printwriter.println("entityShadows:" + this.field_181151_V);
            printwriter.println("mainHand:" + (this.field_186715_A == EnumHandSide.LEFT ? "left" : "right"));
            printwriter.println("attackIndicator:" + this.field_186716_M);
            printwriter.println("showSubtitles:" + this.field_186717_N);
            printwriter.println("realmsNotifications:" + this.field_183509_X);
            printwriter.println("enableWeakAttacks:" + this.field_189422_N);
            printwriter.println("autoJump:" + this.field_189989_R);
            printwriter.println("narrator:" + this.field_192571_R);
            printwriter.println("tutorialStep:" + this.field_193631_S.func_193308_a());
            printwriter.println("autoSuggestions:" + this.field_198018_T);
            printwriter.println("mouseWheelSensitivity:" + this.field_208033_V);
            printwriter.println("glDebugVerbosity:" + this.field_209231_W);
            for (KeyBinding keyBinding : this.field_74324_K) {
                printwriter.println("key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_197982_m() + (keyBinding.getKeyModifier() != KeyModifier.NONE ? ":" + keyBinding.getKeyModifier() : ""));
            }
            for (KeyBinding keyBinding : SoundCategory.values()) {
                printwriter.println("soundCategory_" + keyBinding.func_187948_a() + ":" + this.func_186711_a((SoundCategory)keyBinding));
            }
            for (KeyBinding keyBinding : EnumPlayerModelParts.values()) {
                printwriter.println("modelPart_" + keyBinding.func_179329_c() + ":" + this.field_178882_aU.contains(keyBinding));
            }
            IOUtils.closeQuietly((Writer)printwriter);
        }
        catch (Exception exception) {
            field_151454_ax.error("Failed to save options", (Throwable)exception);
        }
        finally {
            IOUtils.closeQuietly(printwriter);
        }
        this.func_82879_c();
    }

    public float func_186711_a(SoundCategory category) {
        return this.field_186714_aM.containsKey(category) ? this.field_186714_aM.get(category).floatValue() : 1.0f;
    }

    public void func_186712_a(SoundCategory category, float volume) {
        this.field_74317_L.func_147118_V().func_184399_a(category, volume);
        this.field_186714_aM.put(category, Float.valueOf(volume));
    }

    public void func_82879_c() {
        if (this.field_74317_L.field_71439_g != null) {
            int i = 0;
            for (EnumPlayerModelParts enumplayermodelparts : this.field_178882_aU) {
                i |= enumplayermodelparts.func_179327_a();
            }
            this.field_74317_L.field_71439_g.field_71174_a.func_147297_a((Packet<?>)new CPacketClientSettings(this.field_74363_ab, this.field_151451_c, this.field_74343_n, this.field_74344_o, i, this.field_186715_A));
        }
    }

    public Set<EnumPlayerModelParts> func_178876_d() {
        return ImmutableSet.copyOf(this.field_178882_aU);
    }

    public void func_178878_a(EnumPlayerModelParts modelPart, boolean enable) {
        if (enable) {
            this.field_178882_aU.add(modelPart);
        } else {
            this.field_178882_aU.remove(modelPart);
        }
        this.func_82879_c();
    }

    public void func_178877_a(EnumPlayerModelParts modelPart) {
        if (this.func_178876_d().contains(modelPart)) {
            this.field_178882_aU.remove(modelPart);
        } else {
            this.field_178882_aU.add(modelPart);
        }
        this.func_82879_c();
    }

    public int func_181147_e() {
        return this.field_151451_c >= 4 ? this.field_74345_l : 0;
    }

    public boolean func_181148_f() {
        return this.field_181150_U;
    }

    public void func_198017_a(ResourcePackList<ResourcePackInfoClient> resourcePackListIn) {
        resourcePackListIn.func_198983_a();
        LinkedHashSet set = Sets.newLinkedHashSet();
        Iterator<String> iterator = this.field_151453_l.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            ResourcePackInfoClient resourcepackinfoclient = (ResourcePackInfoClient)resourcePackListIn.func_198981_a(s);
            if (resourcepackinfoclient == null && !s.startsWith("file/")) {
                resourcepackinfoclient = (ResourcePackInfoClient)resourcePackListIn.func_198981_a("file/" + s);
            }
            if (resourcepackinfoclient == null) {
                field_151454_ax.warn("Removed resource pack {} from options because it doesn't seem to exist anymore", (Object)s);
                iterator.remove();
                continue;
            }
            if (!resourcepackinfoclient.func_195791_d().func_198968_a() && !this.field_183018_l.contains(s)) {
                field_151454_ax.warn("Removed resource pack {} from options because it is no longer compatible", (Object)s);
                iterator.remove();
                continue;
            }
            if (resourcepackinfoclient.func_195791_d().func_198968_a() && this.field_183018_l.contains(s)) {
                field_151454_ax.info("Removed resource pack {} from incompatibility list because it's now compatible", (Object)s);
                this.field_183018_l.remove(s);
                continue;
            }
            set.add(resourcepackinfoclient);
        }
        resourcePackListIn.func_198985_a((Collection)set);
    }

    private void setForgeKeybindProperties() {
        KeyConflictContext inGame = KeyConflictContext.IN_GAME;
        this.field_74351_w.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74370_x.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74368_y.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74366_z.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74314_A.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74311_E.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_151444_V.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74312_F.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74310_D.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74321_H.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_74323_J.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_151457_aa.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_151458_ab.setKeyConflictContext((IKeyConflictContext)inGame);
        this.field_186718_X.setKeyConflictContext((IKeyConflictContext)inGame);
    }

    public void onGuiClosed() {
        if (this.needsBlockModelRefresh) {
            this.field_74317_L.func_152344_a(() -> ForgeHooksClient.refreshResources((Minecraft)this.field_74317_L, (VanillaResourceType[])new VanillaResourceType[]{VanillaResourceType.MODELS}));
            this.needsBlockModelRefresh = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Options {
        INVERT_MOUSE("options.invertMouse", false, true),
        SENSITIVITY("options.sensitivity", true, false),
        FOV("options.fov", true, false, 30.0, 110.0, 1.0f),
        GAMMA("options.gamma", true, false),
        SATURATION("options.saturation", true, false),
        RENDER_DISTANCE("options.renderDistance", true, false, 2.0, 16.0, 1.0f),
        VIEW_BOBBING("options.viewBobbing", false, true),
        FRAMERATE_LIMIT("options.framerateLimit", true, false, 10.0, 260.0, 10.0f),
        FBO_ENABLE("options.fboEnable", false, true),
        RENDER_CLOUDS("options.renderClouds", false, false),
        GRAPHICS("options.graphics", false, false),
        AMBIENT_OCCLUSION("options.ao", false, false),
        GUI_SCALE("options.guiScale", false, false),
        PARTICLES("options.particles", false, false),
        CHAT_VISIBILITY("options.chat.visibility", false, false),
        CHAT_COLOR("options.chat.color", false, true),
        CHAT_LINKS("options.chat.links", false, true),
        CHAT_OPACITY("options.chat.opacity", true, false),
        CHAT_LINKS_PROMPT("options.chat.links.prompt", false, true),
        SNOOPER_ENABLED("options.snooper", false, true),
        FULLSCREEN_RESOLUTION("options.fullscreen.resolution", true, false, 0.0, 0.0, 1.0f),
        USE_FULLSCREEN("options.fullscreen", false, true),
        ENABLE_VSYNC("options.vsync", false, true),
        USE_VBO("options.vbo", false, true),
        TOUCHSCREEN("options.touchscreen", false, true),
        CHAT_SCALE("options.chat.scale", true, false),
        CHAT_WIDTH("options.chat.width", true, false),
        CHAT_HEIGHT_FOCUSED("options.chat.height.focused", true, false),
        CHAT_HEIGHT_UNFOCUSED("options.chat.height.unfocused", true, false),
        MIPMAP_LEVELS("options.mipmapLevels", true, false, 0.0, 4.0, 1.0f),
        FORCE_UNICODE_FONT("options.forceUnicodeFont", false, true),
        REDUCED_DEBUG_INFO("options.reducedDebugInfo", false, true),
        ENTITY_SHADOWS("options.entityShadows", false, true),
        MAIN_HAND("options.mainHand", false, false),
        ATTACK_INDICATOR("options.attackIndicator", false, false),
        ENABLE_WEAK_ATTACKS("options.enableWeakAttacks", false, true),
        SHOW_SUBTITLES("options.showSubtitles", false, true),
        REALMS_NOTIFICATIONS("options.realmsNotifications", false, true),
        AUTO_JUMP("options.autoJump", false, true),
        NARRATOR("options.narrator", false, false),
        AUTO_SUGGESTIONS("options.autoSuggestCommands", false, true),
        BIOME_BLEND_RADIUS("options.biomeBlendRadius", true, false, 0.0, 7.0, 1.0f),
        MOUSE_WHEEL_SENSITIVITY("options.mouseWheelSensitivity", true, false, 1.0, 10.0, 0.5f);

        private final boolean field_74385_A;
        private final boolean field_74386_B;
        private final String field_74387_C;
        private final float field_148270_M;
        private double field_148271_N;
        private double field_148272_O;

        public static Options func_74379_a(int ordinal) {
            for (Options gamesettings$options : Options.values()) {
                if (gamesettings$options.func_74381_c() != ordinal) continue;
                return gamesettings$options;
            }
            return null;
        }

        private Options(String translation, boolean isFloat, boolean isBoolean) {
            this(translation, isFloat, isBoolean, 0.0, 1.0, 0.0f);
        }

        private Options(String translationIn, boolean isFloatIn, boolean isBooleanIn, double valMin, double valMax, float valStep) {
            this.field_74387_C = translationIn;
            this.field_74385_A = isFloatIn;
            this.field_74386_B = isBooleanIn;
            this.field_148271_N = valMin;
            this.field_148272_O = valMax;
            this.field_148270_M = valStep;
        }

        public boolean func_74380_a() {
            return this.field_74385_A;
        }

        public boolean func_74382_b() {
            return this.field_74386_B;
        }

        public int func_74381_c() {
            return this.ordinal();
        }

        public String func_74378_d() {
            return this.field_74387_C;
        }

        public double func_198007_e() {
            return this.field_148271_N;
        }

        public double func_198009_f() {
            return this.field_148272_O;
        }

        public void func_148263_a(float value) {
            this.field_148272_O = value;
        }

        public double func_198008_a(double value) {
            return MathHelper.func_151237_a((double)((this.func_198011_c(value) - this.field_148271_N) / (this.field_148272_O - this.field_148271_N)), (double)0.0, (double)1.0);
        }

        public double func_198004_b(double value) {
            return this.func_198011_c(this.field_148271_N + (this.field_148272_O - this.field_148271_N) * MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0));
        }

        public double func_198011_c(double value) {
            value = this.func_198006_d(value);
            return MathHelper.func_151237_a((double)value, (double)this.field_148271_N, (double)this.field_148272_O);
        }

        private double func_198006_d(double value) {
            if (this.field_148270_M > 0.0f) {
                value = this.field_148270_M * (float)Math.round(value / (double)this.field_148270_M);
            }
            return value;
        }
    }
}

