/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailState;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public abstract class BlockRailBase
extends Block {
    protected static final VoxelShape field_185590_a = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    protected static final VoxelShape field_190959_b = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private final boolean field_196277_c;

    public static boolean func_208488_a(World p_208488_0_, BlockPos p_208488_1_) {
        return BlockRailBase.func_208487_j(p_208488_0_.func_180495_p(p_208488_1_));
    }

    public static boolean func_208487_j(IBlockState p_208487_0_) {
        return p_208487_0_.func_203425_a(BlockTags.field_203437_y);
    }

    protected BlockRailBase(boolean p_i48444_1_, Block.Properties p_i48444_2_) {
        super(p_i48444_2_);
        this.field_196277_c = p_i48444_1_;
    }

    public boolean func_208490_b() {
        return this.field_196277_c;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        RailShape railshape = state.func_177230_c() == this ? this.getRailDirection(state, worldIn, pos, null) : null;
        return railshape != null && railshape.func_208092_c() ? field_190959_b : field_185590_a;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        return down.func_185896_q() || down.func_193401_d((IBlockReader)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    @Override
    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K) {
            state = this.func_208489_a(worldIn, pos, state, true);
            if (this.field_196277_c) {
                state.func_189546_a(worldIn, pos, this, pos);
            }
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            RailShape railshape = this.getRailDirection(state, (IBlockReader)worldIn, pos, null);
            boolean flag = false;
            if (!state.func_196955_c(worldIn, pos)) {
                flag = true;
            }
            if (railshape == RailShape.ASCENDING_EAST && !state.func_196955_c(worldIn, pos.func_177974_f().func_177984_a())) {
                flag = true;
            } else if (railshape == RailShape.ASCENDING_WEST && !state.func_196955_c(worldIn, pos.func_177976_e().func_177984_a())) {
                flag = true;
            } else if (railshape == RailShape.ASCENDING_NORTH && !state.func_196955_c(worldIn, pos.func_177978_c().func_177984_a())) {
                flag = true;
            } else if (railshape == RailShape.ASCENDING_SOUTH && !state.func_196955_c(worldIn, pos.func_177968_d().func_177984_a())) {
                flag = true;
            }
            if (flag && !worldIn.func_175623_d(pos)) {
                state.func_196941_a(worldIn, pos, 1.0f, 0);
                worldIn.func_175698_g(pos);
            } else {
                this.func_189541_b(state, worldIn, pos, blockIn);
            }
        }
    }

    protected void func_189541_b(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
    }

    protected IBlockState func_208489_a(World p_208489_1_, BlockPos p_208489_2_, IBlockState p_208489_3_, boolean p_208489_4_) {
        return p_208489_1_.field_72995_K ? p_208489_3_ : new BlockRailState(p_208489_1_, p_208489_2_, p_208489_3_).func_208511_a(p_208489_1_.func_175640_z(p_208489_2_), p_208489_4_).func_196916_c();
    }

    @Override
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (!isMoving) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (this.getRailDirection(state, (IBlockReader)worldIn, pos, null).func_208092_c()) {
                worldIn.func_195593_d(pos.func_177984_a(), this);
            }
            if (this.field_196277_c) {
                worldIn.func_195593_d(pos, this);
                worldIn.func_195593_d(pos.func_177977_b(), this);
            }
        }
    }

    public abstract IProperty<RailShape> func_176560_l();

    public boolean isFlexibleRail(IBlockState state, IBlockReader world, BlockPos pos) {
        return !this.field_196277_c;
    }

    public boolean canMakeSlopes(IBlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public RailShape getRailDirection(IBlockState state, IBlockReader world, BlockPos pos, @Nullable EntityMinecart cart) {
        return (RailShape)state.func_177229_b(this.func_176560_l());
    }

    public float getRailMaxSpeed(IBlockState state, World world, BlockPos pos, EntityMinecart cart) {
        return 0.4f;
    }

    public void onMinecartPass(IBlockState state, World world, BlockPos pos, EntityMinecart cart) {
    }
}

