/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFourWay;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPane
extends BlockFourWay {
    protected BlockPane(Block.Properties builder) {
        super(1.0f, 1.0f, 16.0f, 16.0f, 16.0f, builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_196409_a, Boolean.valueOf(false))).func_206870_a((IProperty)field_196411_b, Boolean.valueOf(false))).func_206870_a((IProperty)field_196413_c, Boolean.valueOf(false))).func_206870_a((IProperty)field_196414_y, Boolean.valueOf(false))).func_206870_a((IProperty)field_204514_u, Boolean.valueOf(false)));
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)field_196409_a, Boolean.valueOf(this.canPaneConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.NORTH)))).func_206870_a((IProperty)field_196413_c, Boolean.valueOf(this.canPaneConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.SOUTH)))).func_206870_a((IProperty)field_196414_y, Boolean.valueOf(this.canPaneConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.WEST)))).func_206870_a((IProperty)field_196411_b, Boolean.valueOf(this.canPaneConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.EAST)))).func_206870_a((IProperty)field_204514_u, Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_204514_u)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
        }
        return facing.func_176740_k().func_176722_c() ? (IBlockState)stateIn.func_206870_a((IProperty)field_196415_z.get((Object)facing), Boolean.valueOf(this.canPaneConnectTo((IBlockReader)worldIn, currentPos, facing))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(IBlockState state, IBlockState adjacentBlockState, EnumFacing side) {
        if (adjacentBlockState.func_177230_c() == this) {
            if (!side.func_176740_k().func_176722_c()) {
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)field_196415_z.get((Object)side))).booleanValue() && ((Boolean)adjacentBlockState.func_177229_b((IProperty)field_196415_z.get((Object)side.func_176734_d()))).booleanValue()) {
                return true;
            }
        }
        return super.func_200122_a(state, adjacentBlockState, side);
    }

    public final boolean func_196417_a(IBlockState p_196417_1_, BlockFaceShape p_196417_2_) {
        Block block = p_196417_1_.func_177230_c();
        return !BlockPane.func_196418_h(block) && p_196417_2_ == BlockFaceShape.SOLID || p_196417_2_ == BlockFaceShape.MIDDLE_POLE_THIN;
    }

    public static boolean func_196418_h(Block p_196418_0_) {
        return p_196418_0_ instanceof BlockShulkerBox || p_196418_0_ instanceof BlockLeaves || p_196418_0_ == Blocks.field_150461_bJ || p_196418_0_ == Blocks.field_150383_bp || p_196418_0_ == Blocks.field_150426_aN || p_196418_0_ == Blocks.field_150432_aD || p_196418_0_ == Blocks.field_180398_cJ || p_196418_0_ == Blocks.field_150331_J || p_196418_0_ == Blocks.field_150320_F || p_196418_0_ == Blocks.field_150332_K || p_196418_0_ == Blocks.field_150440_ba || p_196418_0_ == Blocks.field_150423_aK || p_196418_0_ == Blocks.field_196625_cS || p_196418_0_ == Blocks.field_196628_cT || p_196418_0_ == Blocks.field_180401_cv;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196409_a, field_196411_b, field_196414_y, field_196413_c, field_204514_u});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL;
    }

    public boolean canBeConnectedTo(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing facing) {
        IBlockState other = world.func_180495_p(pos.func_177972_a(facing));
        return this.func_196417_a(other, other.func_193401_d(world, pos.func_177972_a(facing), facing.func_176734_d()));
    }

    private boolean canPaneConnectTo(IBlockReader world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        IBlockState other = world.func_180495_p(offset);
        return other.canBeConnectedTo(world, offset, facing.func_176734_d()) || this.func_176223_P().canBeConnectedTo(world, pos, facing);
    }
}

