/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BlockMushroom
extends BlockBush
implements IGrowable {
    protected static final VoxelShape field_196385_a = Block.func_208617_a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);

    public BlockMushroom(Block.Properties builder) {
        super(builder);
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196385_a;
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (random.nextInt(25) == 0) {
            int i = 5;
            int j = 4;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (worldIn.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (worldIn.func_175623_d(blockpos1) && state.func_196955_c(worldIn, blockpos1)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            }
            if (worldIn.func_175623_d(blockpos1) && state.func_196955_c(worldIn, blockpos1)) {
                worldIn.func_180501_a(blockpos1, state, 2);
            }
        }
    }

    @Override
    protected boolean func_200014_a_(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200015_d(worldIn, pos);
    }

    @Override
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (block != Blocks.field_150391_bh && block != Blocks.field_196661_l) {
            return worldIn.func_201669_a(pos, 0) < 13 && iblockstate.canSustainPlant((IBlockReader)worldIn, blockpos, EnumFacing.UP, this);
        }
        return true;
    }

    public boolean func_176485_d(IWorld worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175698_g(pos);
        Feature<NoFeatureConfig> feature = null;
        if (this == Blocks.field_150338_P) {
            feature = Feature.field_202319_S;
        } else if (this == Blocks.field_150337_Q) {
            feature = Feature.field_202318_R;
        }
        if (feature != null && feature.func_212245_a(worldIn, (IChunkGenerator<IChunkGenSettings>)worldIn.func_72863_F().func_201711_g(), rand, pos, IFeatureConfig.field_202429_e)) {
            return true;
        }
        worldIn.func_180501_a(pos, state, 3);
        return false;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.func_176485_d(worldIn, pos, state, rand);
    }

    @Override
    public boolean func_201783_b(IBlockState p_201783_1_, IBlockReader worldIn, BlockPos pos) {
        return true;
    }
}

