/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFourWay;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockFence
extends BlockFourWay {
    private final VoxelShape[] field_199609_B;

    public BlockFence(Block.Properties builder) {
        super(2.0f, 2.0f, 16.0f, 16.0f, 24.0f, builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_196409_a, Boolean.valueOf(false))).func_206870_a((IProperty)field_196411_b, Boolean.valueOf(false))).func_206870_a((IProperty)field_196413_c, Boolean.valueOf(false))).func_206870_a((IProperty)field_196414_y, Boolean.valueOf(false))).func_206870_a((IProperty)field_204514_u, Boolean.valueOf(false)));
        this.field_199609_B = this.func_196408_a(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
    }

    public VoxelShape func_196247_c(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.field_199609_B[this.func_196406_i(state)];
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean func_196416_a(IBlockState p_196416_1_, BlockFaceShape p_196416_2_) {
        Block block = p_196416_1_.func_177230_c();
        boolean flag = p_196416_2_ == BlockFaceShape.MIDDLE_POLE && (p_196416_1_.func_185904_a() == this.field_149764_J || block instanceof BlockFenceGate);
        return !BlockFence.func_194142_e(block) && p_196416_2_ == BlockFaceShape.SOLID || flag;
    }

    public static boolean func_194142_e(Block p_194142_0_) {
        return Block.func_193382_c(p_194142_0_) || p_194142_0_ == Blocks.field_180401_cv || p_194142_0_ == Blocks.field_150440_ba || p_194142_0_ == Blocks.field_150423_aK || p_194142_0_ == Blocks.field_196625_cS || p_194142_0_ == Blocks.field_196628_cT || p_194142_0_ == Blocks.field_185778_de || p_194142_0_ == Blocks.field_150335_W;
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return ItemLead.func_180618_a((EntityPlayer)player, (World)worldIn, (BlockPos)pos);
        }
        ItemStack itemstack = player.func_184586_b(hand);
        return itemstack.func_77973_b() == Items.field_151058_ca || itemstack.func_190926_b();
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)super.func_196258_a(context).func_206870_a((IProperty)field_196409_a, Boolean.valueOf(this.canFenceConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.NORTH)))).func_206870_a((IProperty)field_196411_b, Boolean.valueOf(this.canFenceConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.EAST)))).func_206870_a((IProperty)field_196413_c, Boolean.valueOf(this.canFenceConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.SOUTH)))).func_206870_a((IProperty)field_196414_y, Boolean.valueOf(this.canFenceConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.WEST)))).func_206870_a((IProperty)field_204514_u, Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_204514_u)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
        }
        return facing.func_176740_k().func_176716_d() == EnumFacing.Plane.HORIZONTAL ? (IBlockState)stateIn.func_206870_a((IProperty)field_196415_z.get((Object)facing), Boolean.valueOf(this.canFenceConnectTo((IBlockReader)worldIn, currentPos, facing))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196409_a, field_196411_b, field_196414_y, field_196413_c, field_204514_u});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
    }

    public boolean canBeConnectedTo(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing facing) {
        IBlockState other = world.func_180495_p(pos.func_177972_a(facing));
        return this.func_196416_a(other, other.func_193401_d(world, pos.func_177972_a(facing), facing.func_176734_d()));
    }

    private boolean canFenceConnectTo(IBlockReader world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        IBlockState other = world.func_180495_p(offset);
        return other.canBeConnectedTo(world, offset, facing.func_176734_d()) || this.func_176223_P().canBeConnectedTo(world, pos, facing);
    }
}

