/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockAttachedStem;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBannerWall;
import net.minecraft.block.BlockBarrier;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockBlueIce;
import net.minecraft.block.BlockBookshelf;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockBubbleColumn;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.BlockButtonWood;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCarvedPumpkin;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockChorusPlant;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockConduit;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockCoral;
import net.minecraft.block.BlockCoralFan;
import net.minecraft.block.BlockCoralFin;
import net.minecraft.block.BlockCoralPlant;
import net.minecraft.block.BlockCoralPlantDead;
import net.minecraft.block.BlockCoralWallFan;
import net.minecraft.block.BlockCoralWallFanDead;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDirtSnowy;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFlowingFluid;
import net.minecraft.block.BlockFrostedIce;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGlassPane;
import net.minecraft.block.BlockGlazedTerracotta;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHay;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockKelp;
import net.minecraft.block.BlockKelpTop;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockPressurePlateWeighted;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedstone;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneLamp;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneTorchWall;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSeaGrass;
import net.minecraft.block.BlockSeaGrassTall;
import net.minecraft.block.BlockSeaLantern;
import net.minecraft.block.BlockSeaPickle;
import net.minecraft.block.BlockShearableDoublePlant;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSkullPlayer;
import net.minecraft.block.BlockSkullWall;
import net.minecraft.block.BlockSkullWallPlayer;
import net.minecraft.block.BlockSkullWither;
import net.minecraft.block.BlockSkullWitherWall;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowLayer;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStemGrown;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.BlockStructureVoid;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockTallFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTorchWall;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTrappedChest;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockTurtleEgg;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.BlockWetSponge;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.trees.AbstractTree;
import net.minecraft.block.trees.AcaciaTree;
import net.minecraft.block.trees.BirchTree;
import net.minecraft.block.trees.DarkOakTree;
import net.minecraft.block.trees.JungleTree;
import net.minecraft.block.trees.OakTree;
import net.minecraft.block.trees.SpruceTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.StatList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Block
extends ForgeRegistryEntry<Block>
implements IItemProvider,
IForgeBlock {
    protected static final Logger field_196273_d = LogManager.getLogger();
    @Deprecated
    public static final ObjectIntIdentityMap<IBlockState> field_176229_d = GameData.getBlockStateIDMap();
    private static final EnumFacing[] field_212556_a = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.UP};
    protected final int field_149784_t;
    protected final float field_149782_v;
    protected final float field_149781_w;
    protected final boolean field_149789_z;
    protected final SoundType field_149762_H;
    protected final Material field_149764_J;
    protected final MaterialColor field_181083_K;
    private final float field_149765_K;
    protected final StateContainer<Block, IBlockState> field_176227_L;
    private IBlockState field_196275_y;
    protected final boolean field_196274_w;
    private final boolean field_208621_p;
    @Nullable
    private String field_149770_b;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> field_210300_r = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    protected Random RANDOM = new Random();
    protected ThreadLocal<EntityPlayer> harvesters = new ThreadLocal();
    private ToolType harvestTool;
    private int harvestLevel;
    protected static ThreadLocal<Boolean> captureDrops = ThreadLocal.withInitial(() -> false);
    protected static ThreadLocal<NonNullList<ItemStack>> capturedDrops = ThreadLocal.withInitial(NonNullList::func_191196_a);

    public static int func_196246_j(@Nullable IBlockState state) {
        if (state == null) {
            return 0;
        }
        int i = field_176229_d.func_148747_b((Object)state);
        return i == -1 ? 0 : i;
    }

    public static IBlockState func_196257_b(int id) {
        IBlockState iblockstate = (IBlockState)field_176229_d.func_148745_a(id);
        return iblockstate == null ? Blocks.field_150350_a.func_176223_P() : iblockstate;
    }

    public static Block func_149634_a(@Nullable Item itemIn) {
        return itemIn instanceof ItemBlock ? ((ItemBlock)itemIn).func_179223_d() : Blocks.field_150350_a;
    }

    public static IBlockState func_199601_a(IBlockState oldState, IBlockState newState, World worldIn, BlockPos pos) {
        VoxelShape voxelshape = VoxelShapes.func_197882_b((VoxelShape)oldState.func_196952_d((IBlockReader)worldIn, pos), (VoxelShape)newState.func_196952_d((IBlockReader)worldIn, pos), (IBooleanFunction)IBooleanFunction.ONLY_SECOND).func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        for (Entity entity : worldIn.func_72839_b(null, voxelshape.func_197752_a())) {
            double d0 = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Y, (AxisAlignedBB)entity.func_174813_aQ().func_72317_d(0.0, 1.0, 0.0), Stream.of(voxelshape), (double)-1.0);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 1.0 + d0, entity.field_70161_v);
        }
        return newState;
    }

    public static VoxelShape func_208617_a(double x1, double y1, double z1, double x2, double y2, double z2) {
        return VoxelShapes.func_197873_a((double)(x1 / 16.0), (double)(y1 / 16.0), (double)(z1 / 16.0), (double)(x2 / 16.0), (double)(y2 / 16.0), (double)(z2 / 16.0));
    }

    @Deprecated
    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return true;
    }

    @Deprecated
    public boolean func_196261_e(IBlockState state) {
        return false;
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return this.field_149784_t;
    }

    @Deprecated
    public Material func_149688_o(IBlockState state) {
        return this.field_149764_J;
    }

    @Deprecated
    public MaterialColor func_180659_g(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.field_181083_K;
    }

    @Deprecated
    public void func_196242_c(IBlockState stateIn, IWorld worldIn, BlockPos pos, int flags) {
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumfacing : field_212556_a) {
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing);
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                IBlockState iblockstate1 = iblockstate.func_196956_a(enumfacing.func_176734_d(), stateIn, worldIn, (BlockPos)blockpos$pooledmutableblockpos, pos);
                Block.func_196263_a(iblockstate, iblockstate1, worldIn, (BlockPos)blockpos$pooledmutableblockpos, flags);
            }
        }
    }

    public boolean func_203417_a(Tag<Block> tagIn) {
        return tagIn.func_199685_a_(this);
    }

    public static IBlockState func_199770_b(IBlockState currentState, IWorld worldIn, BlockPos pos) {
        IBlockState iblockstate = currentState;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (EnumFacing enumfacing : field_212556_a) {
            blockpos$mutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing);
            iblockstate = iblockstate.func_196956_a(enumfacing, worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos), worldIn, pos, (BlockPos)blockpos$mutableblockpos);
        }
        return iblockstate;
    }

    public static void func_196263_a(IBlockState oldState, IBlockState newState, IWorld worldIn, BlockPos pos, int flags) {
        if (newState != oldState) {
            if (newState.func_196958_f()) {
                if (!worldIn.func_201670_d()) {
                    worldIn.func_175655_b(pos, (flags & 0x20) == 0);
                }
            } else {
                worldIn.func_180501_a(pos, newState, flags & 0xFFFFFFDF);
            }
        }
    }

    @Deprecated
    public void func_196248_b(IBlockState state, IWorld worldIn, BlockPos pos, int flags) {
    }

    @Deprecated
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state;
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state;
    }

    public Block(Properties properties) {
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_206840_a((StateContainer.Builder<Block, IBlockState>)builder);
        this.field_176227_L = builder.func_206893_a(BlockState::new);
        this.func_180632_j((IBlockState)this.field_176227_L.func_177621_b());
        this.field_149764_J = properties.field_200953_a;
        this.field_181083_K = properties.field_200954_b;
        this.field_196274_w = properties.field_200955_c;
        this.field_149762_H = properties.field_200956_d;
        this.field_149784_t = properties.field_200957_e;
        this.field_149781_w = properties.field_200958_f;
        this.field_149782_v = properties.field_200959_g;
        this.field_149789_z = properties.field_200960_h;
        this.field_149765_K = properties.field_200961_i;
        this.field_208621_p = properties.field_208772_j;
    }

    public static boolean func_193384_b(Block attachBlock) {
        return attachBlock instanceof BlockShulkerBox || attachBlock instanceof BlockLeaves || attachBlock.func_203417_a(BlockTags.field_212185_E) || attachBlock instanceof BlockStainedGlass || attachBlock == Blocks.field_150461_bJ || attachBlock == Blocks.field_150383_bp || attachBlock == Blocks.field_150359_w || attachBlock == Blocks.field_150426_aN || attachBlock == Blocks.field_150432_aD || attachBlock == Blocks.field_180398_cJ || attachBlock == Blocks.field_205165_jY;
    }

    public static boolean func_193382_c(Block attachBlock) {
        return Block.func_193384_b(attachBlock) || attachBlock == Blocks.field_150331_J || attachBlock == Blocks.field_150320_F || attachBlock == Blocks.field_150332_K;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return state.func_185904_a().func_76230_c() && state.func_185917_h();
    }

    @Deprecated
    public boolean func_149721_r(IBlockState state) {
        return state.func_185904_a().func_76218_k() && state.func_185917_h() && !state.func_185897_m();
    }

    @Deprecated
    public boolean func_176214_u(IBlockState state) {
        return this.field_149764_J.func_76230_c() && state.func_185917_h();
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    @Deprecated
    public boolean func_185481_k(IBlockState state) {
        return state.func_185904_a().func_76218_k() && state.func_185917_h();
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return !Block.func_208062_a(this.func_196268_f(state, worldIn, pos));
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return !Block.func_208062_a(this.func_196268_f(state, worldIn, pos));
            }
        }
        return false;
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_196253_a(IBlockState state, BlockItemUseContext useContext) {
        return state.func_185904_a().func_76222_j() && useContext.func_195996_i().func_77973_b() != this.func_199767_j();
    }

    @Deprecated
    public float func_176195_g(IBlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return this.field_149782_v;
    }

    public boolean func_149653_t(IBlockState p_149653_1_) {
        return this.field_149789_z;
    }

    @Deprecated
    public boolean func_149716_u() {
        return this.hasTileEntity(this.func_176223_P());
    }

    @Deprecated
    public boolean func_201783_b(IBlockState p_201783_1_, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public int func_185484_c(IBlockState state, IWorldReader source, BlockPos pos) {
        int i = source.func_175626_b(pos, state.getLightValue(source, pos));
        if (i == 0 && state.func_177230_c() instanceof BlockSlab) {
            pos = pos.func_177977_b();
            state = source.func_180495_p(pos);
            return source.func_175626_b(pos, state.getLightValue(source, pos));
        }
        return i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean func_176225_a(IBlockState adjacentState, IBlockReader blockState, BlockPos blockAccess, EnumFacing pos) {
        BlockPos blockpos = blockAccess.func_177972_a(pos);
        IBlockState iblockstate = blockState.func_180495_p(blockpos);
        if (adjacentState.func_200017_a(iblockstate, pos)) {
            return false;
        }
        if (iblockstate.func_200132_m()) {
            VoxelShape voxelshape1;
            boolean flag;
            RenderSideCacheKey block$rendersidecachekey = new RenderSideCacheKey(adjacentState, iblockstate, pos);
            Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = field_210300_r.get();
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block$rendersidecachekey);
            if (b0 != 127) {
                return b0 != 0;
            }
            VoxelShape voxelshape = adjacentState.func_196951_e(blockState, blockAccess);
            boolean bl = flag = !VoxelShapes.func_197875_a((VoxelShape)voxelshape, (VoxelShape)(voxelshape1 = iblockstate.func_196951_e(blockState, blockpos)), (EnumFacing)pos);
            if (object2bytelinkedopenhashmap.size() == 200) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block$rendersidecachekey, (byte)(flag ? 1 : 0));
            return flag;
        }
        return true;
    }

    @Deprecated
    public boolean func_200124_e(IBlockState state) {
        return this.field_196274_w && state.func_177230_c().func_180664_k() == BlockRenderLayer.SOLID;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(IBlockState state, IBlockState adjacentBlockState, EnumFacing side) {
        return false;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    @Deprecated
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.field_196274_w ? state.func_196954_c(worldIn, pos) : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_196247_c(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_196954_c(worldIn, pos);
    }

    @Deprecated
    public VoxelShape func_199600_g(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public static boolean func_208061_a(VoxelShape shape, EnumFacing side) {
        VoxelShape voxelshape = shape.func_212434_a(side);
        return Block.func_208062_a(voxelshape);
    }

    public static boolean func_208062_a(VoxelShape shape) {
        return !VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.ONLY_FIRST);
    }

    @Deprecated
    public final boolean func_200012_i(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        boolean flag = state.func_200132_m();
        VoxelShape voxelshape = flag ? state.func_196951_e(worldIn, pos) : VoxelShapes.func_197880_a();
        return Block.func_208062_a(voxelshape);
    }

    public boolean func_200123_i(IBlockState state, IBlockReader reader, BlockPos pos) {
        return !Block.func_208062_a(state.func_196954_c(reader, pos)) && state.func_204520_s().func_206888_e();
    }

    @Deprecated
    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (state.func_200015_d(worldIn, pos)) {
            return worldIn.func_201572_C();
        }
        return state.func_200131_a(worldIn, pos) ? 0 : 1;
    }

    @Deprecated
    public final boolean func_200125_k(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return !state.func_200015_d(worldIn, pos) && state.func_200016_a(worldIn, pos) == worldIn.func_201572_C();
    }

    public boolean func_200293_a(IBlockState state) {
        return this.func_149703_v();
    }

    public boolean func_149703_v() {
        return true;
    }

    @Deprecated
    public void func_196265_a(IBlockState state, World worldIn, BlockPos pos, Random random) {
        this.func_196267_b(state, worldIn, pos, random);
    }

    @Deprecated
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, IBlockState state) {
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public int func_149738_a(IWorldReaderBase worldIn) {
        return 10;
    }

    @Deprecated
    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
    }

    @Deprecated
    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (this.hasTileEntity(state) && !(this instanceof BlockContainer) && !(this instanceof BlockBed) && !(this instanceof BlockRedstoneDiode) && state.func_177230_c() != newState.func_177230_c()) {
            worldIn.func_175713_t(pos);
        }
    }

    @Deprecated
    public int func_196264_a(IBlockState state, Random random) {
        return 1;
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return this;
    }

    @Deprecated
    public float func_180647_a(IBlockState state, EntityPlayer player, IBlockReader worldIn, BlockPos pos) {
        float f = state.func_185887_b(worldIn, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.canHarvestBlock((IBlockState)state, (EntityPlayer)player, (IBlockReader)worldIn, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    @Deprecated
    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops(state, drops, worldIn, pos, fortune);
            chancePerItem = ForgeEventFactory.fireBlockHarvesting((NonNullList)drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chancePerItem, (boolean)false, (EntityPlayer)this.harvesters.get());
            for (ItemStack stack : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chancePerItem)) continue;
                Block.func_180635_a(worldIn, pos, stack);
            }
        }
    }

    public static void func_180635_a(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_82766_b("doTileDrops") && !worldIn.restoringBlockSnapshots) {
            if (captureDrops.get().booleanValue()) {
                capturedDrops.get().add((Object)stack);
                return;
            }
            float f = 0.5f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174869_p();
            worldIn.func_72838_d(entityitem);
        }
    }

    public void func_180637_b(World worldIn, BlockPos pos, int amount) {
        if (!worldIn.field_72995_K && worldIn.func_82736_K().func_82766_b("doTileDrops")) {
            while (amount > 0) {
                int i = EntityXPOrb.func_70527_a(amount);
                amount -= i;
                worldIn.func_72838_d(new EntityXPOrb(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, i));
            }
        }
    }

    @Deprecated
    public float func_149638_a() {
        return this.field_149781_w;
    }

    @Nullable
    public static RayTraceResult func_180636_a(IBlockState state, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult raytraceresult1;
        RayTraceResult raytraceresult = state.func_196954_c((IBlockReader)worldIn, pos).func_212433_a(start, end, pos);
        if (raytraceresult != null && (raytraceresult1 = state.func_199611_f((IBlockReader)worldIn, pos).func_212433_a(start, end, pos)) != null && raytraceresult1.field_72307_f.func_178788_d(start).func_189985_c() < raytraceresult.field_72307_f.func_178788_d(start).func_189985_c()) {
            raytraceresult.field_178784_b = raytraceresult1.field_178784_b;
        }
        return state.func_177230_c().getRayTraceResult(state, worldIn, pos, start, end, raytraceresult);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @Deprecated
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        return true;
    }

    @Deprecated
    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        return this.func_176223_P();
    }

    @Deprecated
    public void func_196270_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player) {
    }

    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return false;
    }

    @Deprecated
    public void func_196262_a(IBlockState state, World worldIn, BlockPos pos, Entity entityIn) {
    }

    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
        if (this.canSilkHarvest(state, worldIn, pos, player) && EnchantmentHelper.func_77506_a(Enchantments.field_185306_r, stack) > 0) {
            NonNullList items = NonNullList.func_191196_a();
            ItemStack itemstack = this.func_180643_i(state);
            if (!itemstack.func_190926_b()) {
                items.add((Object)itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting((NonNullList)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            items.forEach(e -> Block.func_180635_a(worldIn, pos, e));
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77506_a(Enchantments.field_185308_t, stack);
            state.func_196949_c(worldIn, pos, i);
            this.harvesters.set(null);
        }
    }

    @Deprecated
    protected boolean func_149700_E() {
        return this.func_176223_P().func_185917_h() && !this.func_149716_u();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(this);
    }

    public int func_196251_a(IBlockState state, int fortune, World worldIn, BlockPos pos, Random random) {
        return this.func_196264_a(state, random);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, @Nullable EntityLivingBase placer, ItemStack stack) {
    }

    public boolean func_181623_g() {
        return !this.field_149764_J.func_76220_a() && !this.field_149764_J.func_76224_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200291_n() {
        return new TextComponentTranslation(this.func_149739_a(), new Object[0]);
    }

    public String func_149739_a() {
        if (this.field_149770_b == null) {
            this.field_149770_b = Util.func_200697_a((String)"block", (ResourceLocation)IRegistry.field_212618_g.func_177774_c(this));
        }
        return this.field_149770_b;
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        return false;
    }

    @Deprecated
    public EnumPushReaction func_149656_h(IBlockState state) {
        return this.field_149764_J.func_186274_m();
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_185485_f(IBlockState state) {
        return state.func_185898_k() ? 0.2f : 1.0f;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_180430_e(fallDistance, 1.0f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        entityIn.field_70181_x = 0.0;
    }

    @Deprecated
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack(this));
    }

    @Deprecated
    public IFluidState func_204507_t(IBlockState state) {
        return Fluids.field_204541_a.func_207188_f();
    }

    public float func_208618_m() {
        return this.field_149765_K;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(IBlockState state, BlockPos pos) {
        return MathHelper.func_180186_a((Vec3i)pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        worldIn.func_180498_a(player, 2001, pos, Block.func_196246_j(state));
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return false;
    }

    @Deprecated
    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
    }

    public StateContainer<Block, IBlockState> func_176194_O() {
        return this.field_176227_L;
    }

    protected final void func_180632_j(IBlockState state) {
        this.field_196275_y = state;
    }

    public final IBlockState func_176223_P() {
        return this.field_196275_y;
    }

    public EnumOffsetType func_176218_Q() {
        return EnumOffsetType.NONE;
    }

    @Deprecated
    public Vec3d func_190949_e(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        EnumOffsetType block$enumoffsettype = this.func_176218_Q();
        if (block$enumoffsettype == EnumOffsetType.NONE) {
            return Vec3d.field_186680_a;
        }
        long i = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
        return new Vec3d(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.5, block$enumoffsettype == EnumOffsetType.XYZ ? ((double)((float)(i >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5);
    }

    @Deprecated
    public SoundType func_185467_w() {
        return this.field_149762_H;
    }

    public Item func_199767_j() {
        return Item.func_150898_a(this);
    }

    public boolean func_208619_r() {
        return this.field_208621_p;
    }

    public String toString() {
        return "Block{" + IRegistry.field_212618_g.func_177774_c(this) + "}";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    public static boolean func_196252_e(Block blockIn) {
        return Tags.Blocks.STONE.func_199685_a_(blockIn);
    }

    public static boolean func_196245_f(Block blockIn) {
        return Tags.Blocks.DIRT.func_199685_a_(blockIn);
    }

    public static void func_149671_p() {
        BlockAir block = new BlockAir(Properties.func_200945_a(Material.field_151579_a).func_200942_a());
        Block.func_196249_a(IRegistry.field_212618_g.func_212609_b(), (Block)block);
        BlockStone block1 = new BlockStone(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("stone", (Block)block1);
        Block.func_196254_a("granite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151664_l).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("polished_granite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151664_l).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("diorite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("polished_diorite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("andesite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("polished_andesite", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("grass_block", (Block)new BlockGrass(Properties.func_200945_a(Material.field_151577_b).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("dirt", new Block(Properties.func_200949_a(Material.field_151578_c, MaterialColor.field_151664_l).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b)));
        Block.func_196254_a("coarse_dirt", new Block(Properties.func_200949_a(Material.field_151578_c, MaterialColor.field_151664_l).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b)));
        Block.func_196254_a("podzol", (Block)new BlockDirtSnowy(Properties.func_200949_a(Material.field_151578_c, MaterialColor.field_151654_J).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b)));
        Block block2 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(2.0f, 6.0f));
        Block.func_196254_a("cobblestone", block2);
        Block block3 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block block4 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block block5 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block block6 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block block7 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block block8 = new Block(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("oak_planks", block3);
        Block.func_196254_a("spruce_planks", block4);
        Block.func_196254_a("birch_planks", block5);
        Block.func_196254_a("jungle_planks", block6);
        Block.func_196254_a("acacia_planks", block7);
        Block.func_196254_a("dark_oak_planks", block8);
        BlockSapling block9 = new BlockSapling((AbstractTree)new OakTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling block10 = new BlockSapling((AbstractTree)new SpruceTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling block11 = new BlockSapling((AbstractTree)new BirchTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling block12 = new BlockSapling((AbstractTree)new JungleTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling block13 = new BlockSapling((AbstractTree)new AcaciaTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockSapling block14 = new BlockSapling((AbstractTree)new DarkOakTree(), Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("oak_sapling", block9);
        Block.func_196254_a("spruce_sapling", block10);
        Block.func_196254_a("birch_sapling", block11);
        Block.func_196254_a("jungle_sapling", block12);
        Block.func_196254_a("acacia_sapling", block13);
        Block.func_196254_a("dark_oak_sapling", block14);
        Block.func_196254_a("bedrock", (Block)new BlockEmptyDrops(Properties.func_200945_a(Material.field_151576_e).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("water", (Block)new BlockFlowingFluid(Fluids.field_204546_a, Properties.func_200945_a(Material.field_151586_h).func_200942_a().func_200943_b(100.0f)));
        Block.func_196254_a("lava", (Block)new BlockFlowingFluid(Fluids.field_204547_b, Properties.func_200945_a(Material.field_151587_i).func_200942_a().func_200944_c().func_200943_b(100.0f).func_200951_a(15)));
        Block.func_196254_a("sand", (Block)new BlockSand(14406560, Properties.func_200949_a(Material.field_151595_p, MaterialColor.field_151658_d).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("red_sand", (Block)new BlockSand(11098145, Properties.func_200949_a(Material.field_151595_p, MaterialColor.field_151676_q).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("gravel", (Block)new BlockGravel(Properties.func_200949_a(Material.field_151595_p, MaterialColor.field_151665_m).func_200943_b(0.6f).func_200947_a(SoundType.field_185849_b)));
        Block.func_196254_a("gold_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("iron_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("coal_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("oak_log", (Block)new BlockLog(MaterialColor.field_151663_o, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_log", (Block)new BlockLog(MaterialColor.field_151654_J, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_log", (Block)new BlockLog(MaterialColor.field_151658_d, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151677_p).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_log", (Block)new BlockLog(MaterialColor.field_151664_l, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_log", (Block)new BlockLog(MaterialColor.field_151676_q, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151665_m).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_log", (Block)new BlockLog(MaterialColor.field_151650_B, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_spruce_log", (Block)new BlockLog(MaterialColor.field_151654_J, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_birch_log", (Block)new BlockLog(MaterialColor.field_151658_d, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_jungle_log", (Block)new BlockLog(MaterialColor.field_151664_l, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_acacia_log", (Block)new BlockLog(MaterialColor.field_151676_q, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_dark_oak_log", (Block)new BlockLog(MaterialColor.field_151650_B, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_oak_log", (Block)new BlockLog(MaterialColor.field_151663_o, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("oak_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_oak_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_spruce_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_birch_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_jungle_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_acacia_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stripped_dark_oak_wood", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("oak_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("spruce_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("birch_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("jungle_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("acacia_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("dark_oak_leaves", new BlockLeaves(Properties.func_200945_a(Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("sponge", (Block)new BlockSponge(Properties.func_200945_a(Material.field_151583_m).func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("wet_sponge", (Block)new BlockWetSponge(Properties.func_200945_a(Material.field_151583_m).func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("glass", (Block)new BlockGlass(Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("lapis_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("lapis_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151652_H).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("dispenser", (Block)new BlockDispenser(Properties.func_200945_a(Material.field_151576_e).func_200943_b(3.5f)));
        Block block15 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(0.8f));
        Block.func_196254_a("sandstone", block15);
        Block.func_196254_a("chiseled_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(0.8f)));
        Block.func_196254_a("cut_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(0.8f)));
        Block.func_196254_a("note_block", new BlockNote(Properties.func_200945_a(Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(0.8f)));
        Block.func_196254_a("white_bed", (Block)((Object)new BlockBed(EnumDyeColor.WHITE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("orange_bed", (Block)((Object)new BlockBed(EnumDyeColor.ORANGE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("magenta_bed", (Block)((Object)new BlockBed(EnumDyeColor.MAGENTA, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("light_blue_bed", (Block)((Object)new BlockBed(EnumDyeColor.LIGHT_BLUE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("yellow_bed", (Block)((Object)new BlockBed(EnumDyeColor.YELLOW, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("lime_bed", (Block)((Object)new BlockBed(EnumDyeColor.LIME, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("pink_bed", (Block)((Object)new BlockBed(EnumDyeColor.PINK, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("gray_bed", (Block)((Object)new BlockBed(EnumDyeColor.GRAY, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("light_gray_bed", (Block)((Object)new BlockBed(EnumDyeColor.LIGHT_GRAY, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("cyan_bed", (Block)((Object)new BlockBed(EnumDyeColor.CYAN, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("purple_bed", (Block)((Object)new BlockBed(EnumDyeColor.PURPLE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("blue_bed", (Block)((Object)new BlockBed(EnumDyeColor.BLUE, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("brown_bed", (Block)((Object)new BlockBed(EnumDyeColor.BROWN, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("green_bed", (Block)((Object)new BlockBed(EnumDyeColor.GREEN, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("red_bed", (Block)((Object)new BlockBed(EnumDyeColor.RED, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("black_bed", (Block)((Object)new BlockBed(EnumDyeColor.BLACK, Properties.func_200945_a(Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f))));
        Block.func_196254_a("powered_rail", new BlockRailPowered(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("detector_rail", new BlockRailDetector(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("sticky_piston", (Block)((Object)new BlockPistonBase(true, Properties.func_200945_a(Material.field_76233_E).func_200943_b(0.5f))));
        Block.func_196254_a("cobweb", new BlockWeb(Properties.func_200945_a(Material.field_151569_G).func_200942_a().func_200943_b(4.0f)));
        BlockTallGrass block16 = new BlockTallGrass(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockTallGrass block17 = new BlockTallGrass(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockDeadBush block18 = new BlockDeadBush(Properties.func_200949_a(Material.field_151582_l, MaterialColor.field_151663_o).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("grass", block16);
        Block.func_196254_a("fern", block17);
        Block.func_196254_a("dead_bush", block18);
        BlockSeaGrass block19 = new BlockSeaGrass(Properties.func_200945_a(Material.field_204868_h).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m));
        Block.func_196254_a("seagrass", block19);
        Block.func_196254_a("tall_seagrass", (Block)new BlockSeaGrassTall((Block)block19, Properties.func_200945_a(Material.field_204868_h).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("piston", (Block)((Object)new BlockPistonBase(false, Properties.func_200945_a(Material.field_76233_E).func_200943_b(0.5f))));
        Block.func_196254_a("piston_head", (Block)new BlockPistonExtension(Properties.func_200945_a(Material.field_76233_E).func_200943_b(0.5f)));
        Block.func_196254_a("white_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151666_j).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("orange_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151676_q).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("magenta_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151675_r).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("light_blue_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151674_s).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("yellow_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151673_t).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("lime_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151672_u).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("pink_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151671_v).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("gray_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151670_w).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("light_gray_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_197656_x).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("cyan_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151679_y).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("purple_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151678_z).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("blue_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151649_A).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("brown_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151650_B).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("green_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151651_C).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("red_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151645_D).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("black_wool", new Block(Properties.func_200949_a(Material.field_151580_n, MaterialColor.field_151646_E).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("moving_piston", (Block)((Object)new BlockPistonMoving(Properties.func_200945_a(Material.field_76233_E).func_200943_b(-1.0f).func_208770_d())));
        BlockFlower block20 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block21 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block22 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block23 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block24 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block25 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block26 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block27 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block28 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        BlockFlower block29 = new BlockFlower(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("dandelion", (Block)block20);
        Block.func_196254_a("poppy", (Block)block21);
        Block.func_196254_a("blue_orchid", (Block)block22);
        Block.func_196254_a("allium", (Block)block23);
        Block.func_196254_a("azure_bluet", (Block)block24);
        Block.func_196254_a("red_tulip", (Block)block25);
        Block.func_196254_a("orange_tulip", (Block)block26);
        Block.func_196254_a("white_tulip", (Block)block27);
        Block.func_196254_a("pink_tulip", (Block)block28);
        Block.func_196254_a("oxeye_daisy", (Block)block29);
        BlockMushroom block30 = new BlockMushroom(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c).func_200951_a(1));
        BlockMushroom block31 = new BlockMushroom(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("brown_mushroom", block30);
        Block.func_196254_a("red_mushroom", block31);
        Block.func_196254_a("gold_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151647_F).func_200948_a(3.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("iron_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151668_h).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block block32 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200948_a(2.0f, 6.0f));
        Block.func_196254_a("bricks", block32);
        Block.func_196254_a("tnt", (Block)new BlockTNT(Properties.func_200945_a(Material.field_151590_u).func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("bookshelf", (Block)new BlockBookshelf(Properties.func_200945_a(Material.field_151575_d).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("mossy_cobblestone", new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("obsidian", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151646_E).func_200948_a(50.0f, 1200.0f)));
        Block.func_196254_a("torch", new BlockTorch(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b().func_200951_a(14).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("wall_torch", (Block)new BlockTorchWall(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b().func_200951_a(14).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("fire", new BlockFire(Properties.func_200949_a(Material.field_151581_o, MaterialColor.field_151656_f).func_200942_a().func_200944_c().func_200946_b().func_200951_a(15).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("spawner", (Block)((Object)new BlockMobSpawner(Properties.func_200945_a(Material.field_151576_e).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e))));
        Block.func_196254_a("oak_stairs", (Block)new BlockStairs(block3.func_176223_P(), Properties.func_200950_a(block3)));
        Block.func_196254_a("chest", (Block)((Object)new BlockChest(Properties.func_200945_a(Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("redstone_wire", new BlockRedstoneWire(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b()));
        Block.func_196254_a("diamond_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("diamond_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151648_G).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("crafting_table", (Block)new BlockWorkbench(Properties.func_200945_a(Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("wheat", new BlockCrops(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        BlockFarmland block33 = new BlockFarmland(Properties.func_200945_a(Material.field_151578_c).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185849_b));
        Block.func_196254_a("farmland", block33);
        Block.func_196254_a("furnace", (Block)new BlockFurnace(Properties.func_200945_a(Material.field_151576_e).func_200943_b(3.5f).func_200951_a(13)));
        Block.func_196254_a("sign", (Block)new BlockStandingSign(Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("oak_door", (Block)new BlockDoor(Properties.func_200949_a(Material.field_151575_d, block3.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("ladder", new BlockLadder(Properties.func_200945_a(Material.field_151594_q).func_200943_b(0.4f).func_200947_a(SoundType.field_185857_j)));
        Block.func_196254_a("rail", (Block)new BlockRail(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("cobblestone_stairs", (Block)new BlockStairs(block2.func_176223_P(), Properties.func_200950_a(block2)));
        Block.func_196254_a("wall_sign", (Block)new BlockWallSign(Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("lever", (Block)new BlockLever(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stone_pressure_plate", (Block)new BlockPressurePlate(BlockPressurePlate.Sensitivity.MOBS, Properties.func_200945_a(Material.field_151576_e).func_200942_a().func_200943_b(0.5f)));
        Block.func_196254_a("iron_door", (Block)new BlockDoor(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151668_h).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("oak_pressure_plate", (Block)new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, block3.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_pressure_plate", (Block)new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, block4.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_pressure_plate", (Block)new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, block5.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_pressure_plate", (Block)new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, block6.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_pressure_plate", (Block)new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, block7.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_pressure_plate", (Block)new BlockPressurePlate(BlockPressurePlate.Sensitivity.EVERYTHING, Properties.func_200949_a(Material.field_151575_d, block8.field_181083_K).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("redstone_ore", new BlockRedstoneOre(Properties.func_200945_a(Material.field_151576_e).func_200944_c().func_200951_a(9).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("redstone_torch", new BlockRedstoneTorch(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b().func_200951_a(7).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("redstone_wall_torch", (Block)new BlockRedstoneTorchWall(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200946_b().func_200951_a(7).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stone_button", (Block)new BlockButtonStone(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f)));
        Block.func_196254_a("snow", new BlockSnowLayer(Properties.func_200945_a(Material.field_151597_y).func_200944_c().func_200943_b(0.1f).func_200947_a(SoundType.field_185856_i)));
        Block.func_196254_a("ice", (Block)((Object)new BlockIce(Properties.func_200945_a(Material.field_151588_w).func_200941_a(0.98f).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f))));
        Block.func_196254_a("snow_block", (Block)new BlockSnow(Properties.func_200945_a(Material.field_151596_z).func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185856_i)));
        BlockCactus block34 = new BlockCactus(Properties.func_200945_a(Material.field_151570_A).func_200944_c().func_200943_b(0.4f).func_200947_a(SoundType.field_185854_g));
        Block.func_196254_a("cactus", block34);
        Block.func_196254_a("clay", (Block)new BlockClay(Properties.func_200945_a(Material.field_151571_B).func_200943_b(0.6f).func_200947_a(SoundType.field_185849_b)));
        Block.func_196254_a("sugar_cane", new BlockReed(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("jukebox", (Block)new BlockJukebox(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("oak_fence", (Block)((Object)new BlockFence(Properties.func_200949_a(Material.field_151575_d, block3.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        BlockPumpkin blockstemgrown = new BlockPumpkin(Properties.func_200949_a(Material.field_151572_C, MaterialColor.field_151676_q).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("pumpkin", (Block)blockstemgrown);
        Block.func_196254_a("netherrack", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200943_b(0.4f)));
        Block.func_196254_a("soul_sand", (Block)new BlockSoulSand(Properties.func_200949_a(Material.field_151595_p, MaterialColor.field_151650_B).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("glowstone", (Block)new BlockGlowstone(Properties.func_200949_a(Material.field_151592_s, MaterialColor.field_151658_d).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_200951_a(15)));
        Block.func_196254_a("nether_portal", new BlockPortal(Properties.func_200945_a(Material.field_151567_E).func_200942_a().func_200944_c().func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_200951_a(11)));
        Block.func_196254_a("carved_pumpkin", (Block)new BlockCarvedPumpkin(Properties.func_200949_a(Material.field_151572_C, MaterialColor.field_151676_q).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jack_o_lantern", (Block)new BlockCarvedPumpkin(Properties.func_200949_a(Material.field_151572_C, MaterialColor.field_151676_q).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_200951_a(15)));
        Block.func_196254_a("cake", (Block)new BlockCake(Properties.func_200945_a(Material.field_151568_F).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("repeater", (Block)new BlockRedstoneRepeater(Properties.func_200945_a(Material.field_151594_q).func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("white_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.WHITE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.WHITE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("orange_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.ORANGE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.ORANGE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("magenta_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.MAGENTA, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.MAGENTA).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("light_blue_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.LIGHT_BLUE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.LIGHT_BLUE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("yellow_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.YELLOW, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.YELLOW).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("lime_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.LIME, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.LIME).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("pink_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.PINK, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.PINK).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("gray_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.GRAY, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.GRAY).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("light_gray_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.LIGHT_GRAY, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.LIGHT_GRAY).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("cyan_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.CYAN, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.CYAN).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("purple_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.PURPLE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.PURPLE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("blue_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.BLUE, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.BLUE).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("brown_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.BROWN, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.BROWN).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("green_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.GREEN, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.GREEN).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("red_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.RED, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.RED).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("black_stained_glass", (Block)new BlockStainedGlass(EnumDyeColor.BLACK, Properties.func_200952_a(Material.field_151592_s, EnumDyeColor.BLACK).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("oak_trapdoor", (Block)((Object)new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("spruce_trapdoor", (Block)((Object)new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("birch_trapdoor", (Block)((Object)new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("jungle_trapdoor", (Block)((Object)new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("acacia_trapdoor", (Block)((Object)new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("dark_oak_trapdoor", (Block)((Object)new BlockTrapDoor(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a))));
        Block block35 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(1.5f, 6.0f));
        Block block36 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(1.5f, 6.0f));
        Block block37 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(1.5f, 6.0f));
        Block block38 = new Block(Properties.func_200945_a(Material.field_151576_e).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("infested_stone", (Block)new BlockSilverfish((Block)block1, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_cobblestone", (Block)new BlockSilverfish(block2, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_stone_bricks", (Block)new BlockSilverfish(block35, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_mossy_stone_bricks", (Block)new BlockSilverfish(block36, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_cracked_stone_bricks", (Block)new BlockSilverfish(block37, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("infested_chiseled_stone_bricks", (Block)new BlockSilverfish(block38, Properties.func_200945_a(Material.field_151571_B).func_200948_a(0.0f, 0.75f)));
        Block.func_196254_a("stone_bricks", block35);
        Block.func_196254_a("mossy_stone_bricks", block36);
        Block.func_196254_a("cracked_stone_bricks", block37);
        Block.func_196254_a("chiseled_stone_bricks", block38);
        BlockHugeMushroom block39 = new BlockHugeMushroom((Block)block30, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200943_b(0.2f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("brown_mushroom_block", (Block)block39);
        BlockHugeMushroom block40 = new BlockHugeMushroom((Block)block31, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151645_D).func_200943_b(0.2f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("red_mushroom_block", (Block)block40);
        Block.func_196254_a("mushroom_stem", (Block)new BlockHugeMushroom((Block)null, Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_193561_M).func_200943_b(0.2f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("iron_bars", (Block)((Object)new BlockPane(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151660_b).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e))));
        Block.func_196254_a("glass_pane", (Block)new BlockGlassPane(Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        BlockMelon blockstemgrown1 = new BlockMelon(Properties.func_200949_a(Material.field_151572_C, MaterialColor.field_151672_u).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("melon", (Block)blockstemgrown1);
        Block.func_196254_a("attached_pumpkin_stem", (Block)new BlockAttachedStem((BlockStemGrown)blockstemgrown, Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("attached_melon_stem", (Block)new BlockAttachedStem((BlockStemGrown)blockstemgrown1, Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("pumpkin_stem", new BlockStem((BlockStemGrown)blockstemgrown, Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("melon_stem", new BlockStem((BlockStemGrown)blockstemgrown1, Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("vine", new BlockVine(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("oak_fence_gate", (Block)((Object)new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, block3.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("brick_stairs", (Block)new BlockStairs(block32.func_176223_P(), Properties.func_200950_a(block32)));
        Block.func_196254_a("stone_brick_stairs", (Block)new BlockStairs(block35.func_176223_P(), Properties.func_200950_a(block35)));
        Block.func_196254_a("mycelium", (Block)new BlockMycelium(Properties.func_200949_a(Material.field_151577_b, MaterialColor.field_151678_z).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("lily_pad", (Block)new BlockLilyPad(Properties.func_200945_a(Material.field_151585_k).func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block block41 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(2.0f, 6.0f));
        Block.func_196254_a("nether_bricks", block41);
        Block.func_196254_a("nether_brick_fence", (Block)((Object)new BlockFence(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(2.0f, 6.0f))));
        Block.func_196254_a("nether_brick_stairs", (Block)new BlockStairs(block41.func_176223_P(), Properties.func_200950_a(block41)));
        Block.func_196254_a("nether_wart", new BlockNetherWart(Properties.func_200949_a(Material.field_151585_k, MaterialColor.field_151645_D).func_200942_a().func_200944_c()));
        Block.func_196254_a("enchanting_table", (Block)((Object)new BlockEnchantmentTable(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200948_a(5.0f, 1200.0f))));
        Block.func_196254_a("brewing_stand", (Block)new BlockBrewingStand(Properties.func_200945_a(Material.field_151573_f).func_200943_b(0.5f).func_200951_a(1)));
        Block.func_196254_a("cauldron", (Block)new BlockCauldron(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151665_m).func_200943_b(2.0f)));
        Block.func_196254_a("end_portal", (Block)new BlockEndPortal(Properties.func_200949_a(Material.field_151567_E, MaterialColor.field_151646_E).func_200942_a().func_200951_a(15).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("end_portal_frame", (Block)new BlockEndPortalFrame(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151651_C).func_200947_a(SoundType.field_185853_f).func_200951_a(1).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("end_stone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200948_a(3.0f, 9.0f)));
        Block.func_196254_a("dragon_egg", (Block)new BlockDragonEgg(Properties.func_200949_a(Material.field_151566_D, MaterialColor.field_151646_E).func_200948_a(3.0f, 9.0f).func_200951_a(1)));
        Block.func_196254_a("redstone_lamp", (Block)new BlockRedstoneLamp(Properties.func_200945_a(Material.field_151591_t).func_200951_a(15).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("cocoa", (Block)((Object)new BlockCocoa(Properties.func_200945_a(Material.field_151585_k).func_200944_c().func_200948_a(0.2f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("sandstone_stairs", (Block)new BlockStairs(block15.func_176223_P(), Properties.func_200950_a(block15)));
        Block.func_196254_a("emerald_ore", new BlockOre(Properties.func_200945_a(Material.field_151576_e).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("ender_chest", (Block)((Object)new BlockEnderChest(Properties.func_200945_a(Material.field_151576_e).func_200948_a(22.5f, 600.0f).func_200951_a(7))));
        BlockTripWireHook blocktripwirehook = new BlockTripWireHook(Properties.func_200945_a(Material.field_151594_q).func_200942_a());
        Block.func_196254_a("tripwire_hook", (Block)blocktripwirehook);
        Block.func_196254_a("tripwire", (Block)new BlockTripWire(blocktripwirehook, Properties.func_200945_a(Material.field_151594_q).func_200942_a()));
        Block.func_196254_a("emerald_block", new Block(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151653_I).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("spruce_stairs", (Block)new BlockStairs(block4.func_176223_P(), Properties.func_200950_a(block4)));
        Block.func_196254_a("birch_stairs", (Block)new BlockStairs(block5.func_176223_P(), Properties.func_200950_a(block5)));
        Block.func_196254_a("jungle_stairs", (Block)new BlockStairs(block6.func_176223_P(), Properties.func_200950_a(block6)));
        Block.func_196254_a("command_block", (Block)new BlockCommandBlock(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151650_B).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("beacon", (Block)new BlockBeacon(Properties.func_200949_a(Material.field_151592_s, MaterialColor.field_151648_G).func_200943_b(3.0f).func_200951_a(15)));
        Block.func_196254_a("cobblestone_wall", (Block)((Object)new BlockWall(Properties.func_200950_a(block2))));
        Block.func_196254_a("mossy_cobblestone_wall", (Block)((Object)new BlockWall(Properties.func_200950_a(block2))));
        Block.func_196254_a("flower_pot", new BlockFlowerPot((Block)block, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_oak_sapling", new BlockFlowerPot(block9, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_spruce_sapling", new BlockFlowerPot(block10, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_birch_sapling", new BlockFlowerPot(block11, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_jungle_sapling", new BlockFlowerPot(block12, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_acacia_sapling", new BlockFlowerPot(block13, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_dark_oak_sapling", new BlockFlowerPot(block14, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_fern", new BlockFlowerPot(block17, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_dandelion", new BlockFlowerPot((Block)block20, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_poppy", new BlockFlowerPot((Block)block21, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_blue_orchid", new BlockFlowerPot((Block)block22, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_allium", new BlockFlowerPot((Block)block23, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_azure_bluet", new BlockFlowerPot((Block)block24, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_red_tulip", new BlockFlowerPot((Block)block25, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_orange_tulip", new BlockFlowerPot((Block)block26, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_white_tulip", new BlockFlowerPot((Block)block27, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_pink_tulip", new BlockFlowerPot((Block)block28, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_oxeye_daisy", new BlockFlowerPot((Block)block29, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_red_mushroom", new BlockFlowerPot(block31, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_brown_mushroom", new BlockFlowerPot(block30, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_dead_bush", new BlockFlowerPot(block18, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("potted_cactus", new BlockFlowerPot(block34, Properties.func_200945_a(Material.field_151594_q).func_200946_b()));
        Block.func_196254_a("carrots", (Block)new BlockCarrot(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("potatoes", new BlockPotato(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("oak_button", (Block)new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_button", (Block)new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_button", (Block)new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_button", (Block)new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_button", (Block)new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_button", (Block)new BlockButtonWood(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("skeleton_wall_skull", (Block)new BlockSkullWall((BlockSkull.ISkullType)BlockSkull.Types.SKELETON, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("skeleton_skull", (Block)new BlockSkull((BlockSkull.ISkullType)BlockSkull.Types.SKELETON, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("wither_skeleton_wall_skull", (Block)new BlockSkullWitherWall(Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("wither_skeleton_skull", (Block)new BlockSkullWither(Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("zombie_wall_head", (Block)new BlockSkullWall((BlockSkull.ISkullType)BlockSkull.Types.ZOMBIE, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("zombie_head", (Block)new BlockSkull((BlockSkull.ISkullType)BlockSkull.Types.ZOMBIE, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("player_wall_head", (Block)new BlockSkullWallPlayer(Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("player_head", (Block)new BlockSkullPlayer(Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("creeper_wall_head", (Block)new BlockSkullWall((BlockSkull.ISkullType)BlockSkull.Types.CREEPER, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("creeper_head", (Block)new BlockSkull((BlockSkull.ISkullType)BlockSkull.Types.CREEPER, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("dragon_wall_head", (Block)new BlockSkullWall((BlockSkull.ISkullType)BlockSkull.Types.DRAGON, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("dragon_head", (Block)new BlockSkull((BlockSkull.ISkullType)BlockSkull.Types.DRAGON, Properties.func_200945_a(Material.field_151594_q).func_200943_b(1.0f)));
        Block.func_196254_a("anvil", (Block)new BlockAnvil(Properties.func_200949_a(Material.field_151574_g, MaterialColor.field_151668_h).func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k)));
        Block.func_196254_a("chipped_anvil", (Block)new BlockAnvil(Properties.func_200949_a(Material.field_151574_g, MaterialColor.field_151668_h).func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k)));
        Block.func_196254_a("damaged_anvil", (Block)new BlockAnvil(Properties.func_200949_a(Material.field_151574_g, MaterialColor.field_151668_h).func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k)));
        Block.func_196254_a("trapped_chest", (Block)new BlockTrappedChest(Properties.func_200945_a(Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_weighted_pressure_plate", (Block)new BlockPressurePlateWeighted(15, Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151647_F).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("heavy_weighted_pressure_plate", (Block)new BlockPressurePlateWeighted(150, Properties.func_200945_a(Material.field_151573_f).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("comparator", (Block)((Object)new BlockRedstoneComparator(Properties.func_200945_a(Material.field_151594_q).func_200946_b().func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("daylight_detector", (Block)new BlockDaylightDetector(Properties.func_200945_a(Material.field_151575_d).func_200943_b(0.2f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("redstone_block", (Block)new BlockRedstone(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151656_f).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)));
        Block.func_196254_a("nether_quartz_ore", new BlockOre(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(3.0f, 3.0f)));
        Block.func_196254_a("hopper", (Block)new BlockHopper(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151665_m).func_200948_a(3.0f, 4.8f).func_200947_a(SoundType.field_185852_e)));
        Block block42 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200943_b(0.8f));
        Block.func_196254_a("quartz_block", block42);
        Block.func_196254_a("chiseled_quartz_block", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200943_b(0.8f)));
        Block.func_196254_a("quartz_pillar", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200943_b(0.8f)));
        Block.func_196254_a("quartz_stairs", (Block)new BlockStairs(block42.func_176223_P(), Properties.func_200950_a(block42)));
        Block.func_196254_a("activator_rail", new BlockRailPowered(Properties.func_200945_a(Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e), true));
        Block.func_196254_a("dropper", (Block)((Object)new BlockDropper(Properties.func_200945_a(Material.field_151576_e).func_200943_b(3.5f))));
        Block.func_196254_a("white_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193561_M).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("orange_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193562_N).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("magenta_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193563_O).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("light_blue_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193564_P).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("yellow_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193565_Q).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("lime_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193566_R).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("pink_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193567_S).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("gray_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193568_T).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("light_gray_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_197655_T).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("cyan_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193570_V).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("purple_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193571_W).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("blue_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193572_X).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("brown_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193573_Y).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("green_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193574_Z).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("red_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193559_aa).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("black_terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193560_ab).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("white_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.WHITE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("orange_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.ORANGE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("magenta_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.MAGENTA, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("light_blue_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.LIGHT_BLUE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("yellow_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.YELLOW, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("lime_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.LIME, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("pink_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.PINK, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("gray_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.GRAY, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("light_gray_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.LIGHT_GRAY, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("cyan_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.CYAN, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("purple_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.PURPLE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("blue_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.BLUE, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("brown_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.BROWN, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("green_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.GREEN, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("red_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.RED, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("black_stained_glass_pane", (Block)new BlockStainedGlassPane(EnumDyeColor.BLACK, Properties.func_200945_a(Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("acacia_stairs", (Block)new BlockStairs(block7.func_176223_P(), Properties.func_200950_a(block7)));
        Block.func_196254_a("dark_oak_stairs", (Block)new BlockStairs(block8.func_176223_P(), Properties.func_200950_a(block8)));
        Block.func_196254_a("slime_block", (Block)new BlockSlime(Properties.func_200949_a(Material.field_151571_B, MaterialColor.field_151661_c).func_200941_a(0.8f).func_200947_a(SoundType.field_185859_l)));
        Block.func_196254_a("barrier", (Block)new BlockBarrier(Properties.func_200945_a(Material.field_175972_I).func_200948_a(-1.0f, 3600000.8f)));
        Block.func_196254_a("iron_trapdoor", (Block)((Object)new BlockTrapDoor(Properties.func_200945_a(Material.field_151573_f).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e))));
        Block block43 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151679_y).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("prismarine", block43);
        Block block44 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151648_G).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("prismarine_bricks", block44);
        Block block45 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151648_G).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("dark_prismarine", block45);
        Block.func_196254_a("prismarine_stairs", (Block)new BlockStairs(block43.func_176223_P(), Properties.func_200950_a(block43)));
        Block.func_196254_a("prismarine_brick_stairs", (Block)new BlockStairs(block44.func_176223_P(), Properties.func_200950_a(block44)));
        Block.func_196254_a("dark_prismarine_stairs", (Block)new BlockStairs(block45.func_176223_P(), Properties.func_200950_a(block45)));
        Block.func_196254_a("prismarine_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151679_y).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("prismarine_brick_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151648_G).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("dark_prismarine_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151648_G).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("sea_lantern", (Block)new BlockSeaLantern(Properties.func_200949_a(Material.field_151592_s, MaterialColor.field_151677_p).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_200951_a(15)));
        Block.func_196254_a("hay_block", (Block)new BlockHay(Properties.func_200949_a(Material.field_151577_b, MaterialColor.field_151673_t).func_200943_b(0.5f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("white_carpet", (Block)new BlockCarpet(EnumDyeColor.WHITE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151666_j).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("orange_carpet", (Block)new BlockCarpet(EnumDyeColor.ORANGE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151676_q).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("magenta_carpet", (Block)new BlockCarpet(EnumDyeColor.MAGENTA, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151675_r).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("light_blue_carpet", (Block)new BlockCarpet(EnumDyeColor.LIGHT_BLUE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151674_s).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("yellow_carpet", (Block)new BlockCarpet(EnumDyeColor.YELLOW, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151673_t).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("lime_carpet", (Block)new BlockCarpet(EnumDyeColor.LIME, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151672_u).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("pink_carpet", (Block)new BlockCarpet(EnumDyeColor.PINK, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151671_v).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("gray_carpet", (Block)new BlockCarpet(EnumDyeColor.GRAY, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151670_w).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("light_gray_carpet", (Block)new BlockCarpet(EnumDyeColor.LIGHT_GRAY, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_197656_x).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("cyan_carpet", (Block)new BlockCarpet(EnumDyeColor.CYAN, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151679_y).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("purple_carpet", (Block)new BlockCarpet(EnumDyeColor.PURPLE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151678_z).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("blue_carpet", (Block)new BlockCarpet(EnumDyeColor.BLUE, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151649_A).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("brown_carpet", (Block)new BlockCarpet(EnumDyeColor.BROWN, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151650_B).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("green_carpet", (Block)new BlockCarpet(EnumDyeColor.GREEN, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151651_C).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("red_carpet", (Block)new BlockCarpet(EnumDyeColor.RED, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151645_D).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("black_carpet", (Block)new BlockCarpet(EnumDyeColor.BLACK, Properties.func_200949_a(Material.field_151593_r, MaterialColor.field_151646_E).func_200943_b(0.1f).func_200947_a(SoundType.field_185854_g)));
        Block.func_196254_a("terracotta", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200948_a(1.25f, 4.2f)));
        Block.func_196254_a("coal_block", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151646_E).func_200948_a(5.0f, 6.0f)));
        Block.func_196254_a("packed_ice", (Block)new BlockPackedIce(Properties.func_200945_a(Material.field_151598_x).func_200941_a(0.98f).func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("sunflower", (Block)new BlockTallFlower(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("lilac", (Block)new BlockTallFlower(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("rose_bush", (Block)new BlockTallFlower(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("peony", (Block)new BlockTallFlower(Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("tall_grass", new BlockShearableDoublePlant(block16, Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("large_fern", new BlockShearableDoublePlant(block17, Properties.func_200945_a(Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("white_banner", (Block)new BlockBanner(EnumDyeColor.WHITE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("orange_banner", (Block)new BlockBanner(EnumDyeColor.ORANGE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("magenta_banner", (Block)new BlockBanner(EnumDyeColor.MAGENTA, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_blue_banner", (Block)new BlockBanner(EnumDyeColor.LIGHT_BLUE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("yellow_banner", (Block)new BlockBanner(EnumDyeColor.YELLOW, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("lime_banner", (Block)new BlockBanner(EnumDyeColor.LIME, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("pink_banner", (Block)new BlockBanner(EnumDyeColor.PINK, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("gray_banner", (Block)new BlockBanner(EnumDyeColor.GRAY, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_gray_banner", (Block)new BlockBanner(EnumDyeColor.LIGHT_GRAY, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("cyan_banner", (Block)new BlockBanner(EnumDyeColor.CYAN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("purple_banner", (Block)new BlockBanner(EnumDyeColor.PURPLE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("blue_banner", (Block)new BlockBanner(EnumDyeColor.BLUE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("brown_banner", (Block)new BlockBanner(EnumDyeColor.BROWN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("green_banner", (Block)new BlockBanner(EnumDyeColor.GREEN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("red_banner", (Block)new BlockBanner(EnumDyeColor.RED, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("black_banner", (Block)new BlockBanner(EnumDyeColor.BLACK, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("white_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.WHITE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("orange_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.ORANGE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("magenta_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.MAGENTA, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_blue_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.LIGHT_BLUE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("yellow_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.YELLOW, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("lime_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.LIME, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("pink_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.PINK, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("gray_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.GRAY, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("light_gray_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.LIGHT_GRAY, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("cyan_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.CYAN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("purple_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.PURPLE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("blue_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.BLUE, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("brown_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.BROWN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("green_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.GREEN, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("red_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.RED, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("black_wall_banner", (Block)new BlockBannerWall(EnumDyeColor.BLACK, Properties.func_200945_a(Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block block46 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200943_b(0.8f));
        Block.func_196254_a("red_sandstone", block46);
        Block.func_196254_a("chiseled_red_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200943_b(0.8f)));
        Block.func_196254_a("cut_red_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200943_b(0.8f)));
        Block.func_196254_a("red_sandstone_stairs", (Block)new BlockStairs(block46.func_176223_P(), Properties.func_200950_a(block46)));
        Block.func_196254_a("oak_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("spruce_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151654_J).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151658_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151664_l).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151676_q).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151575_d, MaterialColor.field_151650_B).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("stone_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("sandstone_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("petrified_oak_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151663_o).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("cobblestone_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("brick_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("stone_brick_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("nether_brick_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("quartz_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("red_sandstone_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("purpur_slab", (Block)new BlockSlab(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151675_r).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("smooth_stone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("smooth_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("smooth_quartz", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151677_p).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("smooth_red_sandstone", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("spruce_fence_gate", (Block)((Object)new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, block4.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("birch_fence_gate", (Block)((Object)new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, block5.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("jungle_fence_gate", (Block)((Object)new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, block6.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("acacia_fence_gate", (Block)((Object)new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, block7.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("dark_oak_fence_gate", (Block)((Object)new BlockFenceGate(Properties.func_200949_a(Material.field_151575_d, block8.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("spruce_fence", (Block)((Object)new BlockFence(Properties.func_200949_a(Material.field_151575_d, block4.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("birch_fence", (Block)((Object)new BlockFence(Properties.func_200949_a(Material.field_151575_d, block5.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("jungle_fence", (Block)((Object)new BlockFence(Properties.func_200949_a(Material.field_151575_d, block6.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("acacia_fence", (Block)((Object)new BlockFence(Properties.func_200949_a(Material.field_151575_d, block7.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("dark_oak_fence", (Block)((Object)new BlockFence(Properties.func_200949_a(Material.field_151575_d, block8.field_181083_K).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
        Block.func_196254_a("spruce_door", (Block)new BlockDoor(Properties.func_200949_a(Material.field_151575_d, block4.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("birch_door", (Block)new BlockDoor(Properties.func_200949_a(Material.field_151575_d, block5.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("jungle_door", (Block)new BlockDoor(Properties.func_200949_a(Material.field_151575_d, block6.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("acacia_door", (Block)new BlockDoor(Properties.func_200949_a(Material.field_151575_d, block7.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("dark_oak_door", (Block)new BlockDoor(Properties.func_200949_a(Material.field_151575_d, block8.field_181083_K).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("end_rod", (Block)new BlockEndRod(Properties.func_200945_a(Material.field_151594_q).func_200946_b().func_200951_a(14).func_200947_a(SoundType.field_185848_a)));
        BlockChorusPlant blockchorusplant = new BlockChorusPlant(Properties.func_200949_a(Material.field_151585_k, MaterialColor.field_151678_z).func_200943_b(0.4f).func_200947_a(SoundType.field_185848_a));
        Block.func_196254_a("chorus_plant", (Block)blockchorusplant);
        Block.func_196254_a("chorus_flower", new BlockChorusFlower(blockchorusplant, Properties.func_200949_a(Material.field_151585_k, MaterialColor.field_151678_z).func_200944_c().func_200943_b(0.4f).func_200947_a(SoundType.field_185848_a)));
        Block block47 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151675_r).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("purpur_block", block47);
        Block.func_196254_a("purpur_pillar", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151675_r).func_200948_a(1.5f, 6.0f)));
        Block.func_196254_a("purpur_stairs", (Block)new BlockStairs(block47.func_176223_P(), Properties.func_200950_a(block47)));
        Block.func_196254_a("end_stone_bricks", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(0.8f)));
        Block.func_196254_a("beetroots", (Block)new BlockBeetroot(Properties.func_200945_a(Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c)));
        BlockGrassPath block48 = new BlockGrassPath(Properties.func_200945_a(Material.field_151578_c).func_200943_b(0.65f).func_200947_a(SoundType.field_185850_c));
        Block.func_196254_a("grass_path", (Block)block48);
        Block.func_196254_a("end_gateway", (Block)new BlockEndGateway(Properties.func_200949_a(Material.field_151567_E, MaterialColor.field_151646_E).func_200942_a().func_200951_a(15).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("repeating_command_block", (Block)new BlockCommandBlock(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151678_z).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("chain_command_block", (Block)new BlockCommandBlock(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_151651_C).func_200948_a(-1.0f, 3600000.0f)));
        Block.func_196254_a("frosted_ice", (Block)new BlockFrostedIce(Properties.func_200945_a(Material.field_151588_w).func_200941_a(0.98f).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("magma_block", (Block)new BlockMagma(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200951_a(3).func_200944_c().func_200943_b(0.5f)));
        Block.func_196254_a("nether_wart_block", new Block(Properties.func_200949_a(Material.field_151577_b, MaterialColor.field_151645_D).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)));
        Block.func_196254_a("red_nether_bricks", new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151655_K).func_200948_a(2.0f, 6.0f)));
        Block.func_196254_a("bone_block", (Block)new BlockRotatedPillar(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151658_d).func_200943_b(2.0f)));
        Block.func_196254_a("structure_void", (Block)new BlockStructureVoid(Properties.func_200945_a(Material.field_189963_J).func_200942_a()));
        Block.func_196254_a("observer", (Block)new BlockObserver(Properties.func_200945_a(Material.field_151576_e).func_200943_b(3.0f)));
        Block.func_196254_a("shulker_box", (Block)new BlockShulkerBox((EnumDyeColor)null, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151678_z).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("white_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.WHITE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151666_j).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("orange_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.ORANGE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151676_q).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("magenta_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.MAGENTA, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151675_r).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("light_blue_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.LIGHT_BLUE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151674_s).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("yellow_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.YELLOW, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151673_t).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("lime_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.LIME, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151672_u).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("pink_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.PINK, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151671_v).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("gray_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.GRAY, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("light_gray_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.LIGHT_GRAY, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_197656_x).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("cyan_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.CYAN, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151679_y).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("purple_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.PURPLE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_193571_W).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("blue_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.BLUE, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151649_A).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("brown_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.BROWN, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151650_B).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("green_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.GREEN, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151651_C).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("red_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.RED, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("black_shulker_box", (Block)new BlockShulkerBox(EnumDyeColor.BLACK, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151646_E).func_200943_b(2.0f).func_208770_d()));
        Block.func_196254_a("white_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.WHITE).func_200943_b(1.4f)));
        Block.func_196254_a("orange_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.ORANGE).func_200943_b(1.4f)));
        Block.func_196254_a("magenta_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.MAGENTA).func_200943_b(1.4f)));
        Block.func_196254_a("light_blue_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIGHT_BLUE).func_200943_b(1.4f)));
        Block.func_196254_a("yellow_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.YELLOW).func_200943_b(1.4f)));
        Block.func_196254_a("lime_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIME).func_200943_b(1.4f)));
        Block.func_196254_a("pink_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.PINK).func_200943_b(1.4f)));
        Block.func_196254_a("gray_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.GRAY).func_200943_b(1.4f)));
        Block.func_196254_a("light_gray_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIGHT_GRAY).func_200943_b(1.4f)));
        Block.func_196254_a("cyan_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.CYAN).func_200943_b(1.4f)));
        Block.func_196254_a("purple_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.PURPLE).func_200943_b(1.4f)));
        Block.func_196254_a("blue_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BLUE).func_200943_b(1.4f)));
        Block.func_196254_a("brown_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BROWN).func_200943_b(1.4f)));
        Block.func_196254_a("green_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.GREEN).func_200943_b(1.4f)));
        Block.func_196254_a("red_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.RED).func_200943_b(1.4f)));
        Block.func_196254_a("black_glazed_terracotta", (Block)new BlockGlazedTerracotta(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BLACK).func_200943_b(1.4f)));
        Block block49 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.WHITE).func_200943_b(1.8f));
        Block block50 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.ORANGE).func_200943_b(1.8f));
        Block block51 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.MAGENTA).func_200943_b(1.8f));
        Block block52 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIGHT_BLUE).func_200943_b(1.8f));
        Block block53 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.YELLOW).func_200943_b(1.8f));
        Block block54 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIME).func_200943_b(1.8f));
        Block block55 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.PINK).func_200943_b(1.8f));
        Block block56 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.GRAY).func_200943_b(1.8f));
        Block block57 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.LIGHT_GRAY).func_200943_b(1.8f));
        Block block58 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.CYAN).func_200943_b(1.8f));
        Block block59 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.PURPLE).func_200943_b(1.8f));
        Block block60 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BLUE).func_200943_b(1.8f));
        Block block61 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BROWN).func_200943_b(1.8f));
        Block block62 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.GREEN).func_200943_b(1.8f));
        Block block63 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.RED).func_200943_b(1.8f));
        Block block64 = new Block(Properties.func_200952_a(Material.field_151576_e, EnumDyeColor.BLACK).func_200943_b(1.8f));
        Block.func_196254_a("white_concrete", block49);
        Block.func_196254_a("orange_concrete", block50);
        Block.func_196254_a("magenta_concrete", block51);
        Block.func_196254_a("light_blue_concrete", block52);
        Block.func_196254_a("yellow_concrete", block53);
        Block.func_196254_a("lime_concrete", block54);
        Block.func_196254_a("pink_concrete", block55);
        Block.func_196254_a("gray_concrete", block56);
        Block.func_196254_a("light_gray_concrete", block57);
        Block.func_196254_a("cyan_concrete", block58);
        Block.func_196254_a("purple_concrete", block59);
        Block.func_196254_a("blue_concrete", block60);
        Block.func_196254_a("brown_concrete", block61);
        Block.func_196254_a("green_concrete", block62);
        Block.func_196254_a("red_concrete", block63);
        Block.func_196254_a("black_concrete", block64);
        Block.func_196254_a("white_concrete_powder", (Block)new BlockConcretePowder(block49, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.WHITE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("orange_concrete_powder", (Block)new BlockConcretePowder(block50, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.ORANGE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("magenta_concrete_powder", (Block)new BlockConcretePowder(block51, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.MAGENTA).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("light_blue_concrete_powder", (Block)new BlockConcretePowder(block52, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.LIGHT_BLUE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("yellow_concrete_powder", (Block)new BlockConcretePowder(block53, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.YELLOW).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("lime_concrete_powder", (Block)new BlockConcretePowder(block54, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.LIME).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("pink_concrete_powder", (Block)new BlockConcretePowder(block55, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.PINK).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("gray_concrete_powder", (Block)new BlockConcretePowder(block56, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.GRAY).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("light_gray_concrete_powder", (Block)new BlockConcretePowder(block57, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.LIGHT_GRAY).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("cyan_concrete_powder", (Block)new BlockConcretePowder(block58, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.CYAN).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("purple_concrete_powder", (Block)new BlockConcretePowder(block59, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.PURPLE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("blue_concrete_powder", (Block)new BlockConcretePowder(block60, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.BLUE).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("brown_concrete_powder", (Block)new BlockConcretePowder(block61, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.BROWN).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("green_concrete_powder", (Block)new BlockConcretePowder(block62, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.GREEN).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("red_concrete_powder", (Block)new BlockConcretePowder(block63, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.RED).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        Block.func_196254_a("black_concrete_powder", (Block)new BlockConcretePowder(block64, Properties.func_200952_a(Material.field_151595_p, EnumDyeColor.BLACK).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)));
        BlockKelpTop blockkelptop = new BlockKelpTop(Properties.func_200945_a(Material.field_203243_f).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_211382_m));
        Block.func_196254_a("kelp", (Block)blockkelptop);
        Block.func_196254_a("kelp_plant", (Block)new BlockKelp(blockkelptop, Properties.func_200945_a(Material.field_203243_f).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("dried_kelp_block", new Block(Properties.func_200949_a(Material.field_151577_b, MaterialColor.field_151650_B).func_200948_a(0.5f, 2.5f).func_200947_a(SoundType.field_185850_c)));
        Block.func_196254_a("turtle_egg", (Block)new BlockTurtleEgg(Properties.func_200949_a(Material.field_151566_D, MaterialColor.field_197656_x).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e).func_200944_c()));
        Block block65 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block block66 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block block67 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block block68 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block block69 = new Block(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200948_a(1.5f, 6.0f));
        Block.func_196254_a("dead_tube_coral_block", block65);
        Block.func_196254_a("dead_brain_coral_block", block66);
        Block.func_196254_a("dead_bubble_coral_block", block67);
        Block.func_196254_a("dead_fire_coral_block", block68);
        Block.func_196254_a("dead_horn_coral_block", block69);
        Block.func_196254_a("tube_coral_block", (Block)new BlockCoral(block65, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151649_A).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        Block.func_196254_a("brain_coral_block", (Block)new BlockCoral(block66, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151671_v).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        Block.func_196254_a("bubble_coral_block", (Block)new BlockCoral(block67, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151678_z).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        Block.func_196254_a("fire_coral_block", (Block)new BlockCoral(block68, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151645_D).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        Block.func_196254_a("horn_coral_block", (Block)new BlockCoral(block69, Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151673_t).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_211383_n)));
        BlockCoralPlantDead block70 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralPlantDead block71 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralPlantDead block72 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralPlantDead block73 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralPlantDead block74 = new BlockCoralPlantDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        Block.func_196254_a("dead_tube_coral", (Block)block70);
        Block.func_196254_a("dead_brain_coral", (Block)block71);
        Block.func_196254_a("dead_bubble_coral", (Block)block72);
        Block.func_196254_a("dead_fire_coral", (Block)block73);
        Block.func_196254_a("dead_horn_coral", (Block)block74);
        Block.func_196254_a("tube_coral", (Block)new BlockCoralPlant((Block)block70, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151649_A).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("brain_coral", (Block)new BlockCoralPlant((Block)block71, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151671_v).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("bubble_coral", (Block)new BlockCoralPlant((Block)block72, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151678_z).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("fire_coral", (Block)new BlockCoralPlant((Block)block73, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151645_D).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("horn_coral", (Block)new BlockCoralPlant((Block)block74, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151673_t).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        BlockCoralWallFanDead block75 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralWallFanDead block76 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralWallFanDead block77 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralWallFanDead block78 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralWallFanDead block79 = new BlockCoralWallFanDead(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        Block.func_196254_a("dead_tube_coral_wall_fan", (Block)block75);
        Block.func_196254_a("dead_brain_coral_wall_fan", (Block)block76);
        Block.func_196254_a("dead_bubble_coral_wall_fan", (Block)block77);
        Block.func_196254_a("dead_fire_coral_wall_fan", (Block)block78);
        Block.func_196254_a("dead_horn_coral_wall_fan", (Block)block79);
        Block.func_196254_a("tube_coral_wall_fan", (Block)new BlockCoralWallFan((Block)block75, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151649_A).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("brain_coral_wall_fan", (Block)new BlockCoralWallFan((Block)block76, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151671_v).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("bubble_coral_wall_fan", (Block)new BlockCoralWallFan((Block)block77, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151678_z).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("fire_coral_wall_fan", (Block)new BlockCoralWallFan((Block)block78, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151645_D).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("horn_coral_wall_fan", (Block)new BlockCoralWallFan((Block)block79, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151673_t).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        BlockCoralFan block80 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralFan block81 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralFan block82 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralFan block83 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        BlockCoralFan block84 = new BlockCoralFan(Properties.func_200949_a(Material.field_151576_e, MaterialColor.field_151670_w).func_200942_a().func_200946_b());
        Block.func_196254_a("dead_tube_coral_fan", (Block)block80);
        Block.func_196254_a("dead_brain_coral_fan", (Block)block81);
        Block.func_196254_a("dead_bubble_coral_fan", (Block)block82);
        Block.func_196254_a("dead_fire_coral_fan", (Block)block83);
        Block.func_196254_a("dead_horn_coral_fan", (Block)block84);
        Block.func_196254_a("tube_coral_fan", (Block)new BlockCoralFin((Block)block80, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151649_A).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("brain_coral_fan", (Block)new BlockCoralFin((Block)block81, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151671_v).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("bubble_coral_fan", (Block)new BlockCoralFin((Block)block82, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151678_z).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("fire_coral_fan", (Block)new BlockCoralFin((Block)block83, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151645_D).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("horn_coral_fan", (Block)new BlockCoralFin((Block)block84, Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151673_t).func_200942_a().func_200946_b().func_200947_a(SoundType.field_211382_m)));
        Block.func_196254_a("sea_pickle", (Block)new BlockSeaPickle(Properties.func_200949_a(Material.field_203243_f, MaterialColor.field_151651_C).func_200951_a(3).func_200947_a(SoundType.field_185859_l)));
        Block.func_196254_a("blue_ice", (Block)new BlockBlueIce(Properties.func_200945_a(Material.field_151598_x).func_200943_b(2.8f).func_200941_a(0.989f).func_200947_a(SoundType.field_185853_f)));
        Block.func_196254_a("conduit", (Block)new BlockConduit(Properties.func_200949_a(Material.field_151592_s, MaterialColor.field_151648_G).func_200943_b(3.0f).func_200951_a(15)));
        Block.func_196254_a("void_air", (Block)new BlockAir(Properties.func_200945_a(Material.field_151579_a).func_200942_a()));
        Block.func_196254_a("cave_air", (Block)new BlockAir(Properties.func_200945_a(Material.field_151579_a).func_200942_a()));
        Block.func_196254_a("bubble_column", (Block)new BlockBubbleColumn(Properties.func_200945_a(Material.field_203244_i).func_200942_a()));
        Block.func_196254_a("structure_block", (Block)new BlockStructure(Properties.func_200949_a(Material.field_151573_f, MaterialColor.field_197656_x).func_200948_a(-1.0f, 3600000.0f)));
    }

    private static void func_196249_a(ResourceLocation key, Block blockIn) {
        IRegistry.field_212618_g.func_82595_a(key, blockIn);
    }

    private static void func_196254_a(String key, Block blockIn) {
        Block.func_196249_a(new ResourceLocation(key), blockIn);
    }

    protected NonNullList<ItemStack> captureDrops(boolean start) {
        if (start) {
            captureDrops.set(true);
            capturedDrops.get().clear();
            return NonNullList.func_191196_a();
        }
        captureDrops.set(false);
        return capturedDrops.get();
    }

    public float getSlipperiness(IBlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.field_149765_K;
    }

    public boolean canSilkHarvest(IBlockState state, IWorldReader world, BlockPos pos, EntityPlayer player) {
        return this.func_149700_E() && !state.hasTileEntity();
    }

    @Nullable
    public ToolType getHarvestTool(IBlockState state) {
        return this.harvestTool;
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestLevel;
    }

    public boolean canSustainPlant(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing facing, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        EnumPlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this.getBlock() == Blocks.field_150434_aF || this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_196611_F;
        }
        if (plant.func_177230_c() == Blocks.field_196608_cF && this == Blocks.field_196608_cF) {
            return true;
        }
        if (plantable instanceof BlockBush && ((BlockBush)plantable).func_200014_a_(state, world, pos)) {
            return true;
        }
        switch (type) {
            case Desert: {
                return this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_150405_ch || this.getBlock() instanceof BlockGlazedTerracotta;
            }
            case Nether: {
                return this.getBlock() == Blocks.field_150425_aM;
            }
            case Crop: {
                return this.getBlock() == Blocks.field_150458_ak;
            }
            case Cave: {
                return state.func_185896_q();
            }
            case Plains: {
                return this.getBlock() == Blocks.field_196658_i || Block.func_196245_f(this) || this.getBlock() == Blocks.field_150458_ak;
            }
            case Water: {
                return state.func_185904_a() == Material.field_151586_h;
            }
            case Beach: {
                boolean isBeach = this.getBlock() == Blocks.field_196658_i || Block.func_196245_f(this) || this.getBlock() == Blocks.field_150354_m;
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    static {
        ForgeHooks.setBlockToolSetter((block, tool, level) -> {
            block.harvestTool = tool;
            block.harvestLevel = level;
        });
    }

    public static final class RenderSideCacheKey {
        private final IBlockState field_212164_a;
        private final IBlockState field_212165_b;
        private final EnumFacing field_212166_c;

        public RenderSideCacheKey(IBlockState state, IBlockState adjacentState, EnumFacing side) {
            this.field_212164_a = state;
            this.field_212165_b = adjacentState;
            this.field_212166_c = side;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.field_212164_a == block$rendersidecachekey.field_212164_a && this.field_212165_b == block$rendersidecachekey.field_212165_b && this.field_212166_c == block$rendersidecachekey.field_212166_c;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.field_212164_a, this.field_212165_b, this.field_212166_c});
        }
    }

    public static class Properties {
        private Material field_200953_a;
        private MaterialColor field_200954_b;
        private boolean field_200955_c = true;
        private SoundType field_200956_d = SoundType.field_185851_d;
        private int field_200957_e;
        private float field_200958_f;
        private float field_200959_g;
        private boolean field_200960_h;
        private float field_200961_i = 0.6f;
        private boolean field_208772_j;

        private Properties(Material materialIn, MaterialColor mapColorIn) {
            this.field_200953_a = materialIn;
            this.field_200954_b = mapColorIn;
        }

        public static Properties func_200945_a(Material materialIn) {
            return Properties.func_200949_a(materialIn, materialIn.func_151565_r());
        }

        public static Properties func_200952_a(Material materialIn, EnumDyeColor color) {
            return Properties.func_200949_a(materialIn, color.func_196055_e());
        }

        public static Properties func_200949_a(Material materialIn, MaterialColor mapColorIn) {
            return new Properties(materialIn, mapColorIn);
        }

        public static Properties func_200950_a(Block blockIn) {
            Properties block$properties = new Properties(blockIn.field_149764_J, blockIn.field_181083_K);
            block$properties.field_200953_a = blockIn.field_149764_J;
            block$properties.field_200959_g = blockIn.field_149782_v;
            block$properties.field_200958_f = blockIn.field_149781_w;
            block$properties.field_200955_c = blockIn.field_196274_w;
            block$properties.field_200960_h = blockIn.field_149789_z;
            block$properties.field_200957_e = blockIn.field_149784_t;
            block$properties.field_200953_a = blockIn.field_149764_J;
            block$properties.field_200954_b = blockIn.field_181083_K;
            block$properties.field_200956_d = blockIn.field_149762_H;
            block$properties.field_200961_i = blockIn.func_208618_m();
            block$properties.field_208772_j = blockIn.field_208621_p;
            return block$properties;
        }

        public Properties func_200942_a() {
            this.field_200955_c = false;
            return this;
        }

        public Properties func_200941_a(float slipperinessIn) {
            this.field_200961_i = slipperinessIn;
            return this;
        }

        public Properties func_200947_a(SoundType soundTypeIn) {
            this.field_200956_d = soundTypeIn;
            return this;
        }

        public Properties func_200951_a(int lightValueIn) {
            this.field_200957_e = lightValueIn;
            return this;
        }

        public Properties func_200948_a(float hardnessIn, float resistanceIn) {
            this.field_200959_g = hardnessIn;
            this.field_200958_f = Math.max(0.0f, resistanceIn);
            return this;
        }

        protected Properties func_200946_b() {
            return this.func_200943_b(0.0f);
        }

        public Properties func_200943_b(float hardnessAndResistance) {
            this.func_200948_a(hardnessAndResistance, hardnessAndResistance);
            return this;
        }

        public Properties func_200944_c() {
            this.field_200960_h = true;
            return this;
        }

        public Properties func_208770_d() {
            this.field_208772_j = true;
            return this;
        }
    }

    public static enum EnumOffsetType {
        NONE,
        XZ,
        XYZ;

    }
}

