/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.util;

import com.google.common.base.Charsets;
import com.lenis0012.bukkit.loginsecurity.util.UserIdMode;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ProfileUtil {
    private static final UserIdMode userIdMode = ProfileUtil.useOnlineUUID() ? UserIdMode.MOJANG : UserIdMode.OFFLINE;

    public static UserIdMode getUserIdMode() {
        return userIdMode;
    }

    public static UUID getUUID(Player player) {
        return ProfileUtil.getUUID(player.getName(), player.getUniqueId());
    }

    public static UUID getUUID(String name, UUID fallback) {
        if (ProfileUtil.useOnlineUUID()) {
            return fallback;
        }
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name.toLowerCase()).getBytes(Charsets.UTF_8));
    }

    public static boolean useOnlineUUID() {
        return Bukkit.getOnlineMode() || ProfileUtil.isBungeecord();
    }

    public static boolean isBungeecord() {
        return false;
    }
}

