/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.session;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.session.AuthActionType;
import com.lenis0012.bukkit.loginsecurity.session.AuthMode;
import com.lenis0012.bukkit.loginsecurity.session.AuthService;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.session.action.ActionResponse;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerInventory;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerLocation;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerProfile;
import com.lenis0012.bukkit.loginsecurity.util.InventorySerializer;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public abstract class AuthAction {
    private final AuthActionType type;
    private final AuthService service;
    private final Object serviceProvider;

    public <T> AuthAction(AuthActionType type, AuthService<T> service, T serviceProvider) {
        this.type = type;
        this.service = service;
        this.serviceProvider = serviceProvider;
    }

    public AuthActionType getType() {
        return this.type;
    }

    public AuthService getService() {
        return this.service;
    }

    protected Object getServiceProvider() {
        return this.serviceProvider;
    }

    public abstract AuthMode run(PlayerSession var1, ActionResponse var2);

    protected void rehabPlayer(PlayerSession session) {
        Player player = session.getPlayer();
        PlayerProfile profile = session.getProfile();
        Bukkit.getScheduler().runTask((Plugin)LoginSecurity.getInstance(), () -> player.removePotionEffect(PotionEffectType.BLINDNESS));
        if (profile.getInventoryId() != null) {
            try {
                PlayerInventory serializedInventory = LoginSecurity.getDatastore().getInventoryRepository().findByIdBlocking(profile.getInventoryId());
                if (serializedInventory != null) {
                    Bukkit.getScheduler().runTask((Plugin)LoginSecurity.getInstance(), () -> {
                        InventorySerializer.deserializeInventory(serializedInventory, player.getInventory());
                        profile.setInventoryId(null);
                        session.saveProfileAsync();
                    });
                } else {
                    LoginSecurity.getInstance().getLogger().log(Level.WARNING, "Couldn't find player's inventory");
                    profile.setInventoryId(null);
                    session.saveProfileAsync();
                }
            }
            catch (SQLException e) {
                LoginSecurity.getInstance().getLogger().log(Level.SEVERE, "Failed to load player inventory", e);
            }
        }
        if (profile.getLoginLocationId() != null) {
            try {
                PlayerLocation serializedLocation = LoginSecurity.getDatastore().getLocationRepository().findByIdBlocking(profile.getLoginLocationId());
                Bukkit.getScheduler().runTask((Plugin)LoginSecurity.getInstance(), () -> {
                    player.teleport(serializedLocation.asLocation());
                    profile.setLoginLocationId(null);
                    session.saveProfileAsync();
                });
                if (serializedLocation != null) {
                    LoginSecurity.getInstance().getLogger().log(Level.WARNING, "Couldn't find player's login location");
                    profile.setLoginLocationId(null);
                    session.saveProfileAsync();
                }
            }
            catch (SQLException e) {
                LoginSecurity.getInstance().getLogger().log(Level.SEVERE, "Failed to load player login location", e);
            }
        }
    }
}

