/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.threading;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageKeys;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.util.MetaData;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class TimeoutTask
extends BukkitRunnable {
    private final LoginSecurity plugin;
    private long loginTimeout;

    public TimeoutTask(LoginSecurity plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            long lastLogin;
            PlayerSession session;
            if (!player.isOnline() || (session = LoginSecurity.getSessionManager().getPlayerSession(player)).isAuthorized() || (lastLogin = MetaData.get(player, "ls_login_time", Long.class).longValue()) + this.loginTimeout >= System.currentTimeMillis()) continue;
            player.kickPlayer(LoginSecurity.translate(LanguageKeys.KICK_TIME_OUT).toString());
        }
    }

    public void reload() {
        this.loginTimeout = (long)this.plugin.config().getLoginTimeout() * 1000L;
    }
}

