/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.threading;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.session.AuthMode;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.util.MetaData;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class MessageTask
extends BukkitRunnable {
    private final LoginSecurity plugin;
    private long messageDelay;

    public MessageTask(LoginSecurity plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            long lastMessage;
            PlayerSession session;
            AuthMode authMode;
            if (!player.isOnline() || !(authMode = (session = LoginSecurity.getSessionManager().getPlayerSession(player)).getAuthMode()).hasAuthMessage() || (lastMessage = MetaData.get(player, "ls_last_message", 0L).longValue()) + this.messageDelay > System.currentTimeMillis()) continue;
            player.sendMessage(ChatColor.RED + authMode.getAuthMessage());
            MetaData.set(player, "ls_last_message", System.currentTimeMillis());
        }
    }

    public void reload() {
        this.messageDelay = (long)this.plugin.config().getLoginMessageDelay() * 1000L;
    }
}

