/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.general;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.LoginSecurityConfig;
import com.lenis0012.bukkit.loginsecurity.bukkit.Metrics;
import com.lenis0012.bukkit.loginsecurity.commands.CommandAdmin;
import com.lenis0012.bukkit.loginsecurity.commands.CommandChangePass;
import com.lenis0012.bukkit.loginsecurity.commands.CommandLogin;
import com.lenis0012.bukkit.loginsecurity.commands.CommandLogout;
import com.lenis0012.bukkit.loginsecurity.commands.CommandRegister;
import com.lenis0012.bukkit.loginsecurity.commands.CommandUnregister;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.Module;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.ReleaseType;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.Updater;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.UpdaterFactory;
import com.lenis0012.bukkit.loginsecurity.libs.updater.api.Version;
import com.lenis0012.bukkit.loginsecurity.modules.general.LocationMode;
import com.lenis0012.bukkit.loginsecurity.modules.general.PlayerListener;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageModule;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GeneralModule
extends Module<LoginSecurity> {
    private LocationMode locationMode;
    private Updater updater;

    public GeneralModule(LoginSecurity plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        this.registerCommands();
        this.registerListeners();
        this.setupUpdater();
        this.setupMetrics();
        this.locationMode = LocationMode.valueOf(LoginSecurity.getConfiguration().getLocation().toUpperCase());
    }

    @Override
    public void disable() {
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics((Plugin)this.plugin);
        metrics.addCustomChart(new Metrics.SimplePie("language", () -> ((LoginSecurity)this.plugin).getModule(LanguageModule.class).getTranslation().getName()));
    }

    private void setupUpdater() {
        UpdaterFactory factory = new UpdaterFactory((Plugin)this.plugin);
        LoginSecurityConfig config = LoginSecurity.getConfiguration();
        this.updater = factory.newUpdater(this.getPluginFile(), config.isUpdaterEnabled());
        this.updater.setChannel(ReleaseType.valueOf(config.getUpdaterChannel().toUpperCase()));
    }

    private void registerCommands() {
        this.logger().log(Level.INFO, "Registering commands...");
        this.register(new CommandLogin((LoginSecurity)this.plugin), "login");
        this.register(new CommandRegister((LoginSecurity)this.plugin), "register");
        this.register(new CommandChangePass((LoginSecurity)this.plugin), "changepassword");
        this.register(new CommandLogout((LoginSecurity)this.plugin), "logout");
        this.register(new CommandUnregister((LoginSecurity)this.plugin), "unregister");
        this.register(new CommandAdmin((LoginSecurity)this.plugin), "lac");
    }

    private void registerListeners() {
        this.logger().log(Level.INFO, "Registering listeners...");
        this.register(new PlayerListener(this));
    }

    private File getPluginFile() {
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke((Object)this.plugin, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get plugin file", e);
        }
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public void checkUpdates(Player player) {
        LoginSecurity.getExecutorService().execute(() -> {
            if (!this.updater.hasUpdate()) {
                return;
            }
            Version version = this.updater.getNewVersion();
            if (version == null || version.getType() == null) {
                this.logger().log(Level.WARNING, "Updater was in unexpected state, please report on https://github.com/lenis0012/LoginSecurity-2/issues");
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&bA new &3" + version.getType().toString() + " &bbuild for LoginSecurity is available! &3" + version.getName() + " &bfor &3" + version.getServerVersion())));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&bUse &3/lac update &bto download the new version."));
            });
        });
    }
}

