/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration;

import com.google.common.collect.Lists;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.misc.Reflection;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.Configuration;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.ConfigurationModule;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.mapping.ConfigHeader;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.mapping.ConfigKey;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.modules.configuration.mapping.ConfigMapper;
import java.lang.reflect.Field;
import java.util.List;

public class AbstractConfig {
    private final List<Field> dataFields = Lists.newArrayList();
    private final ConfigMapper mapper = this.getClass().getAnnotation(ConfigMapper.class);
    private final Configuration config;
    private boolean clearOnSave = false;

    protected AbstractConfig(ConfigurationModule module) {
        this.config = module.getConfiguration(this.mapper.fileName());
        for (Field field : this.getClass().getDeclaredFields()) {
            ConfigKey key = field.getAnnotation(ConfigKey.class);
            if (key == null) continue;
            String keyPath = key.path().isEmpty() ? this.toConfigString(field.getName()) : key.path();
            ConfigHeader header = field.getAnnotation(ConfigHeader.class);
            if (header != null) {
                String path = header.path().isEmpty() ? keyPath : header.path();
                this.config.header(path, header.value());
            }
            field.setAccessible(true);
            this.dataFields.add(field);
        }
    }

    protected boolean isClearOnSave() {
        return this.clearOnSave;
    }

    protected void setClearOnSave(boolean flag) {
        this.clearOnSave = flag;
    }

    public void reload() {
        this.config.reload();
        if (this.mapper.header().length > 0) {
            this.config.mainHeader(this.mapper.header());
        }
        for (Field field : this.dataFields) {
            String path;
            ConfigKey key = field.getAnnotation(ConfigKey.class);
            String string = path = key.path().isEmpty() ? this.toConfigString(field.getName()) : key.path();
            if (!this.config.contains(path)) continue;
            Reflection.setFieldValue(field, this, this.config.get(path));
        }
    }

    public void save() {
        for (Field field : this.dataFields) {
            ConfigKey key = field.getAnnotation(ConfigKey.class);
            String path = key.path().isEmpty() ? this.toConfigString(field.getName()) : key.path();
            this.config.set(path, Reflection.getFieldValue(field, this));
        }
        this.config.save();
    }

    private String toConfigString(String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                builder.append('-').append(Character.toLowerCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

