/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.core.shared;

import com.github.games647.fastlogin.core.BalancedSSLFactory;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.github.games647.fastlogin.core.shared.LoginSession;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;

public abstract class MojangApiConnector {
    private static final int TIMEOUT = 3000;
    private static final String USER_AGENT = "Premium-Checker";
    private static final String UUID_LINK = "https://api.mojang.com/users/profiles/minecraft/";
    private static final String VALID_PLAYERNAME = "^\\w{2,16}$";
    private static final int RATE_LIMIT_CODE = 429;
    private final Pattern nameMatcher = Pattern.compile("^\\w{2,16}$");
    private final Iterator<Proxy> proxies;
    private final ConcurrentMap<Object, Object> requests = FastLoginCore.buildCache(10, -1);
    private final BalancedSSLFactory sslFactory;
    private final int rateLimit;
    private long lastRateLimit;
    protected final Logger logger;

    public MojangApiConnector(Logger logger, Collection<String> localAddresses, int rateLimit, Map<String, Integer> proxies) {
        this.logger = logger;
        this.rateLimit = Math.max(rateLimit, 600);
        this.sslFactory = this.buildAddresses(logger, localAddresses);
        ArrayList proxyBuilder = Lists.newArrayList();
        for (Map.Entry<String, Integer> proxy : proxies.entrySet()) {
            proxyBuilder.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getKey(), (int)proxy.getValue())));
        }
        this.proxies = Iterables.cycle((Iterable)proxyBuilder).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getPremiumUUID(String playerName) {
        if (!this.nameMatcher.matcher(playerName).matches()) {
            return null;
        }
        try {
            HttpsURLConnection connection;
            if (this.requests.size() >= this.rateLimit || System.currentTimeMillis() - this.lastRateLimit < 600000L) {
                Iterator<Proxy> iterator = this.proxies;
                synchronized (iterator) {
                    if (!this.proxies.hasNext()) {
                        return null;
                    }
                    connection = this.getConnection(UUID_LINK + playerName, this.proxies.next());
                }
            } else {
                this.requests.put(new Object(), new Object());
                connection = this.getConnection(UUID_LINK + playerName);
            }
            if (connection.getResponseCode() == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = reader.readLine();
                if (!"null".equals(line)) {
                    return FastLoginCore.parseId(this.getUUIDFromJson(line));
                }
            } else if (connection.getResponseCode() == 429) {
                this.logger.info("RATE_LIMIT REACHED");
                this.lastRateLimit = System.currentTimeMillis();
                if (!connection.usingProxy()) {
                    return this.getPremiumUUID(playerName);
                }
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Failed to check if player has a paid account", ex);
        }
        return null;
    }

    public abstract boolean hasJoinedServer(LoginSession var1, String var2, InetSocketAddress var3);

    protected abstract String getUUIDFromJson(String var1);

    protected HttpsURLConnection getConnection(String url, Proxy proxy) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection(proxy);
        connection.setConnectTimeout(3000);
        connection.setReadTimeout(6000);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        if (this.sslFactory != null) {
            connection.setSSLSocketFactory(this.sslFactory);
        }
        return connection;
    }

    protected HttpsURLConnection getConnection(String url) throws IOException {
        return this.getConnection(url, Proxy.NO_PROXY);
    }

    private BalancedSSLFactory buildAddresses(Logger logger, Collection<String> localAddresses) {
        if (localAddresses.isEmpty()) {
            return null;
        }
        HashSet addresses = Sets.newHashSet();
        for (String localAddress : localAddresses) {
            try {
                InetAddress address = InetAddress.getByName(localAddress);
                if (!address.isAnyLocalAddress()) {
                    logger.log(Level.WARNING, "Submitted IP-Address is not local {0}", address);
                    continue;
                }
                addresses.add(address);
            }
            catch (UnknownHostException ex) {
                logger.log(Level.SEVERE, "IP-Address is unknown to us", ex);
            }
        }
        return new BalancedSSLFactory(HttpsURLConnection.getDefaultSSLSocketFactory(), addresses);
    }
}

