/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bungee.tasks;

import com.github.games647.fastlogin.bungee.BungeeLoginSession;
import com.github.games647.fastlogin.bungee.FastLoginBungee;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.github.games647.fastlogin.core.shared.ForceLoginManagement;
import com.github.games647.fastlogin.core.shared.LoginSession;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;

public class ForceLoginTask
extends ForceLoginManagement<ProxiedPlayer, CommandSender, BungeeLoginSession, FastLoginBungee> {
    private final Server server;

    public ForceLoginTask(FastLoginCore<ProxiedPlayer, CommandSender, FastLoginBungee> core, ProxiedPlayer player, Server server) {
        super(core, player);
        this.server = server;
    }

    @Override
    public void run() {
        PendingConnection pendingConnection = ((ProxiedPlayer)this.player).getPendingConnection();
        this.session = (LoginSession)((FastLoginBungee)this.core.getPlugin()).getSession().get(pendingConnection);
        if (this.session == null) {
            return;
        }
        super.run();
        if (!this.isOnlineMode()) {
            ((BungeeLoginSession)this.session).setAlreadySaved(true);
        }
    }

    @Override
    public boolean forceLogin(ProxiedPlayer player) {
        if (((BungeeLoginSession)this.session).isAlreadyLogged()) {
            return true;
        }
        ((BungeeLoginSession)this.session).setAlreadyLogged(true);
        return super.forceLogin(player);
    }

    @Override
    public boolean forceRegister(ProxiedPlayer player) {
        if (((BungeeLoginSession)this.session).isAlreadyLogged()) {
            return true;
        }
        return super.forceRegister(player);
    }

    @Override
    public void onForceActionSuccess(LoginSession session) {
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        if (session.needsRegistration()) {
            dataOutput.writeUTF("AUTO_REGISTER");
        } else {
            dataOutput.writeUTF("AUTO_LOGIN");
        }
        dataOutput.writeUTF(((ProxiedPlayer)this.player).getName());
        UUID proxyId = UUID.fromString(((FastLoginBungee)this.core.getPlugin()).getProxy().getConfig().getUuid());
        dataOutput.writeLong(proxyId.getMostSignificantBits());
        dataOutput.writeLong(proxyId.getLeastSignificantBits());
        if (this.server != null) {
            this.server.sendData(((FastLoginBungee)this.core.getPlugin()).getName(), dataOutput.toByteArray());
        }
    }

    @Override
    public String getName(ProxiedPlayer player) {
        return player.getName();
    }

    @Override
    public boolean isOnline(ProxiedPlayer player) {
        return player.isConnected();
    }

    @Override
    public boolean isOnlineMode() {
        return ((ProxiedPlayer)this.player).getPendingConnection().isOnlineMode();
    }
}

