/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bungee.listener;

import com.github.games647.fastlogin.bungee.FastLoginBungee;
import com.github.games647.fastlogin.bungee.tasks.AsyncPremiumCheck;
import com.github.games647.fastlogin.bungee.tasks.ForceLoginTask;
import com.github.games647.fastlogin.core.PlayerProfile;
import com.github.games647.fastlogin.core.shared.LoginSession;
import com.google.common.base.Charsets;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.AsyncEvent;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.event.EventHandler;

public class PlayerConnectionListener
implements Listener {
    private final FastLoginBungee plugin;

    public PlayerConnectionListener(FastLoginBungee plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPreLogin(PreLoginEvent preLoginEvent) {
        if (preLoginEvent.isCancelled()) {
            return;
        }
        preLoginEvent.registerIntent((Plugin)this.plugin);
        PendingConnection connection = preLoginEvent.getConnection();
        AsyncPremiumCheck asyncPremiumCheck = new AsyncPremiumCheck(this.plugin, (AsyncEvent<?>)preLoginEvent, connection);
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, (Runnable)asyncPremiumCheck);
    }

    @EventHandler(priority=-64)
    public void onLogin(LoginEvent loginEvent) {
        if (loginEvent.isCancelled()) {
            return;
        }
        PendingConnection connection = loginEvent.getConnection();
        InitialHandler initialHandler = (InitialHandler)connection;
        String username = initialHandler.getLoginRequest().getData();
        if (connection.isOnlineMode()) {
            LoginResult loginProfile;
            LoginSession session = (LoginSession)this.plugin.getSession().get(connection);
            session.setUuid(connection.getUniqueId());
            PlayerProfile playerProfile = session.getProfile();
            playerProfile.setUuid(connection.getUniqueId());
            if (!this.plugin.getCore().getConfig().get("premiumUuid", true).booleanValue()) {
                try {
                    UUID offlineUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(Charsets.UTF_8));
                    Field idField = InitialHandler.class.getDeclaredField("uniqueId");
                    idField.setAccessible(true);
                    idField.set(connection, offlineUUID);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to set offline uuid", ex);
                }
            }
            if (!this.plugin.getCore().getConfig().get("forwardSkin", true).booleanValue() && (loginProfile = initialHandler.getLoginProfile()) != null) {
                loginProfile.setProperties(new LoginResult.Property[0]);
            }
        }
    }

    @EventHandler
    public void onServerConnected(ServerConnectedEvent serverConnectedEvent) {
        ProxiedPlayer player = serverConnectedEvent.getPlayer();
        Server server = serverConnectedEvent.getServer();
        ForceLoginTask loginTask = new ForceLoginTask(this.plugin.getCore(), player, server);
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, (Runnable)loginTask);
    }

    @EventHandler
    public void onDisconnect(PlayerDisconnectEvent disconnectEvent) {
        ProxiedPlayer player = disconnectEvent.getPlayer();
        this.plugin.getSession().remove(player.getPendingConnection());
        this.plugin.getCore().getPendingConfirms().remove(player.getUniqueId());
    }
}

