/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.listener.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.server.SocketInjector;
import com.comphenix.protocol.injector.server.TemporaryPlayerFactory;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.github.games647.fastlogin.bukkit.BukkitLoginSession;
import com.github.games647.fastlogin.bukkit.EncryptionUtil;
import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import org.bukkit.entity.Player;

public class VerifyResponseTask
implements Runnable {
    private final FastLoginBukkit plugin;
    private final PacketEvent packetEvent;
    private final Player fromPlayer;
    private final byte[] sharedSecret;

    public VerifyResponseTask(FastLoginBukkit plugin, PacketEvent packetEvent, Player fromPlayer, byte[] sharedSecret) {
        this.plugin = plugin;
        this.packetEvent = packetEvent;
        this.fromPlayer = fromPlayer;
        this.sharedSecret = sharedSecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BukkitLoginSession session = (BukkitLoginSession)this.plugin.getLoginSessions().get(this.fromPlayer.getAddress().toString());
            if (session == null) {
                this.disconnect(this.plugin.getCore().getMessage("invalid-request"), true, "Player {0} tried to send encryption response at invalid state", this.fromPlayer.getAddress());
            } else {
                this.verifyResponse(session);
            }
        }
        finally {
            Object object = this.packetEvent.getAsyncMarker().getProcessingLock();
            synchronized (object) {
                this.packetEvent.setCancelled(true);
            }
            ProtocolLibrary.getProtocolManager().getAsynchronousManager().signalPacketTransmission(this.packetEvent);
        }
    }

    private void verifyResponse(BukkitLoginSession session) {
        PrivateKey privateKey = this.plugin.getServerKey().getPrivate();
        SecretKey loginKey = EncryptionUtil.decryptSharedKey(privateKey, this.sharedSecret);
        if (!this.checkVerifyToken(session, privateKey) || !this.encryptConnection(loginKey)) {
            return;
        }
        String generatedId = session.getServerId();
        byte[] serverIdHash = EncryptionUtil.getServerIdHash(generatedId, this.plugin.getServerKey().getPublic(), loginKey);
        String serverId = new BigInteger(serverIdHash).toString(16);
        String username = session.getUsername();
        if (this.plugin.getCore().getApiConnector().hasJoinedServer(session, serverId, this.fromPlayer.getAddress())) {
            this.plugin.getLogger().log(Level.INFO, "Player {0} has a verified premium account", username);
            session.setVerified(true);
            this.setPremiumUUID(session.getUuid());
            this.receiveFakeStartPacket(username);
        } else {
            this.disconnect(this.plugin.getCore().getMessage("invalid-session"), true, "Player {0} ({1}) tried to log in with an invalid session ServerId: {2}", session.getUsername(), this.fromPlayer.getAddress(), serverId);
        }
    }

    private void setPremiumUUID(UUID premiumUUID) {
        if (this.plugin.getConfig().getBoolean("premiumUuid") && premiumUUID != null) {
            try {
                Object networkManager = this.getNetworkManager();
                FieldUtils.writeField((Object)networkManager, (String)"spoofedUUID", (Object)premiumUUID, (boolean)true);
            }
            catch (Exception exc) {
                this.plugin.getLogger().log(Level.SEVERE, "Error setting premium uuid", exc);
            }
        }
    }

    private boolean checkVerifyToken(BukkitLoginSession session, Key privateKey) {
        byte[] responseVerify;
        byte[] requestVerify = session.getVerifyToken();
        if (!Arrays.equals(requestVerify, EncryptionUtil.decryptData(privateKey, responseVerify = (byte[])this.packetEvent.getPacket().getByteArrays().read(1)))) {
            this.disconnect(this.plugin.getCore().getMessage("invalid-verify-token"), true, "Player {0} ({1}) tried to login with an invalid verify token. Server: {2} Client: {3}", session.getUsername(), this.packetEvent.getPlayer().getAddress(), requestVerify, responseVerify);
            return false;
        }
        return true;
    }

    private Object getNetworkManager() throws IllegalAccessException, NoSuchFieldException, ClassNotFoundException {
        SocketInjector injectorContainer = TemporaryPlayerFactory.getInjectorFromPlayer((Player)this.fromPlayer);
        Class<?> injectorClass = Class.forName("com.comphenix.protocol.injector.netty.Injector");
        Object rawInjector = FuzzyReflection.getFieldValue((Object)injectorContainer, injectorClass, (boolean)true);
        return FieldUtils.readField((Object)rawInjector, (String)"networkManager", (boolean)true);
    }

    private boolean encryptConnection(SecretKey loginKey) throws IllegalArgumentException {
        try {
            Object networkManager = this.getNetworkManager();
            Method encryptMethod = FuzzyReflection.fromObject((Object)networkManager).getMethodByParameters("a", new Class[]{SecretKey.class});
            encryptMethod.invoke(networkManager, loginKey);
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Couldn't enable encryption", ex);
            this.disconnect(this.plugin.getCore().getMessage("error-kick"), false, "Couldn't enable encryption", new Object[0]);
            return false;
        }
        return true;
    }

    private void disconnect(String kickReason, boolean debug, String logMessage, Object ... arguments) {
        if (debug) {
            this.plugin.getLogger().log(Level.FINE, logMessage, arguments);
        } else {
            this.plugin.getLogger().log(Level.SEVERE, logMessage, arguments);
        }
        this.kickPlayer(this.packetEvent.getPlayer(), kickReason);
    }

    private void kickPlayer(Player player, String reason) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer kickPacket = protocolManager.createPacket(PacketType.Login.Server.DISCONNECT);
        kickPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)reason));
        try {
            protocolManager.sendServerPacket(player, kickPacket);
            player.kickPlayer("Disconnect");
        }
        catch (InvocationTargetException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error sending kick packet", ex);
        }
    }

    private void receiveFakeStartPacket(String username) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer startPacket = protocolManager.createPacket(PacketType.Login.Client.START);
        WrappedGameProfile fakeProfile = new WrappedGameProfile(UUID.randomUUID(), username);
        startPacket.getGameProfiles().write(0, (Object)fakeProfile);
        try {
            protocolManager.recieveClientPacket(this.fromPlayer, startPacket, false);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to fake a new start packet", ex);
            this.kickPlayer(this.fromPlayer, this.plugin.getCore().getMessage("error-kick"));
        }
    }
}

