/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.listener.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.bukkit.listener.protocollib.NameCheckTask;
import com.github.games647.fastlogin.bukkit.listener.protocollib.VerifyResponseTask;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProtocolLibListener
extends PacketAdapter {
    private static final int WORKER_THREADS = 3;
    private final FastLoginBukkit plugin;
    private final Random random = new Random();

    public ProtocolLibListener(FastLoginBukkit plugin) {
        super(ProtocolLibListener.params().plugin((Plugin)plugin).types(new PacketType[]{PacketType.Login.Client.START, PacketType.Login.Client.ENCRYPTION_BEGIN}).optionAsync());
        this.plugin = plugin;
    }

    public static void register(FastLoginBukkit plugin) {
        ProtocolLibrary.getProtocolManager().getAsynchronousManager().registerAsyncHandler((PacketListener)new ProtocolLibListener(plugin)).start(3);
    }

    public void onPacketReceiving(PacketEvent packetEvent) {
        if (packetEvent.isCancelled() || this.plugin.getCore().getAuthPluginHook() == null || !this.plugin.isServerFullyStarted()) {
            return;
        }
        Player sender = packetEvent.getPlayer();
        PacketType packetType = packetEvent.getPacketType();
        if (packetType == PacketType.Login.Client.START) {
            this.onLogin(packetEvent, sender);
        } else {
            this.onEncryptionBegin(packetEvent, sender);
        }
    }

    private void onEncryptionBegin(PacketEvent packetEvent, Player sender) {
        byte[] sharedSecret = (byte[])packetEvent.getPacket().getByteArrays().read(0);
        packetEvent.getAsyncMarker().incrementProcessingDelay();
        VerifyResponseTask verifyTask = new VerifyResponseTask(this.plugin, packetEvent, sender, sharedSecret);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)verifyTask);
    }

    private void onLogin(PacketEvent packetEvent, Player player) {
        String sessionKey = player.getAddress().toString();
        this.plugin.getLoginSessions().remove(sessionKey);
        PacketContainer packet = packetEvent.getPacket();
        String username = ((WrappedGameProfile)packet.getGameProfiles().read(0)).getName();
        this.plugin.getLogger().log(Level.FINER, "Player {0} with {1} connecting", new Object[]{sessionKey, username});
        packetEvent.getAsyncMarker().incrementProcessingDelay();
        NameCheckTask nameCheckTask = new NameCheckTask(this.plugin, packetEvent, this.random, player, username);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)nameCheckTask);
    }
}

