/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.hooks;

import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import fr.xephi.authme.api.NewAPI;
import fr.xephi.authme.api.v3.AuthMeApi;
import org.bukkit.entity.Player;

public class AuthMeHook
implements AuthPlugin<Player> {
    private final boolean v3APIAvailable;

    public AuthMeHook() {
        boolean apiAvailable = true;
        try {
            Class.forName("fr.xephi.authme.api.v3.AuthMeApi");
        }
        catch (ClassNotFoundException classNotFoundEx) {
            apiAvailable = false;
        }
        this.v3APIAvailable = apiAvailable;
    }

    @Override
    public boolean forceLogin(Player player) {
        if (this.v3APIAvailable) {
            if (AuthMeApi.getInstance().isAuthenticated(player)) {
                return false;
            }
            AuthMeApi.getInstance().forceLogin(player);
        } else {
            if (NewAPI.getInstance().isAuthenticated(player)) {
                return false;
            }
            NewAPI.getInstance().forceLogin(player);
        }
        return true;
    }

    @Override
    public boolean isRegistered(String playerName) throws Exception {
        if (this.v3APIAvailable) {
            return AuthMeApi.getInstance().isRegistered(playerName);
        }
        return NewAPI.getInstance().isRegistered(playerName);
    }

    @Override
    public boolean forceRegister(Player player, String password) {
        if (this.v3APIAvailable) {
            AuthMeApi.getInstance().forceRegister(player, password);
        } else {
            NewAPI.getInstance().forceRegister(player, password);
        }
        return true;
    }
}

