/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.commands;

import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.core.PlayerProfile;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PremiumCommand
implements CommandExecutor {
    private final FastLoginBukkit plugin;

    public PremiumCommand(FastLoginBukkit plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.plugin.getCore().sendLocaleMessage("no-console", sender);
                return true;
            }
            if (this.plugin.isBungeeCord()) {
                this.plugin.sendBungeeActivateMessage(sender, sender.getName(), true);
                this.plugin.getCore().sendLocaleMessage("wait-on-proxy", sender);
            } else {
                UUID id = ((Player)sender).getUniqueId();
                if (this.plugin.getConfig().getBoolean("premium-warning") && !this.plugin.getCore().getPendingConfirms().contains(id)) {
                    sender.sendMessage(this.plugin.getCore().getMessage("premium-warning"));
                    this.plugin.getCore().getPendingConfirms().add(id);
                    return true;
                }
                this.plugin.getCore().getPendingConfirms().remove(id);
                PlayerProfile profile = this.plugin.getCore().getStorage().loadProfile(sender.getName());
                if (profile.isPremium()) {
                    this.plugin.getCore().sendLocaleMessage("already-exists", sender);
                } else {
                    profile.setPremium(true);
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.getCore().getStorage().save(profile));
                    this.plugin.getCore().sendLocaleMessage("add-premium", sender);
                }
            }
            return true;
        }
        this.onPremiumOther(sender, command, args);
        return true;
    }

    private void onPremiumOther(CommandSender sender, Command command, String[] args) {
        if (!sender.hasPermission(command.getPermission() + ".other")) {
            this.plugin.getCore().sendLocaleMessage("no-permission", sender);
            return;
        }
        if (this.plugin.isBungeeCord()) {
            this.plugin.sendBungeeActivateMessage(sender, args[0], true);
            this.plugin.getCore().sendLocaleMessage("wait-on-proxy", sender);
        } else {
            PlayerProfile profile = this.plugin.getCore().getStorage().loadProfile(args[0]);
            if (profile == null) {
                this.plugin.getCore().sendLocaleMessage("player-unknown", sender);
                return;
            }
            if (profile.isPremium()) {
                this.plugin.getCore().sendLocaleMessage("already-exists-other", sender);
            } else {
                profile.setPremium(true);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.plugin.getCore().getStorage().save(profile));
                this.plugin.getCore().sendLocaleMessage("add-premium-other", sender);
            }
        }
    }
}

