/*
 * Decompiled with CFR 0.152.
 */
package net.islandearth.anvillogin.listeners;

import fr.xephi.authme.api.v3.AuthMeApi;
import net.islandearth.anvillogin.AnvilLogin;
import net.islandearth.anvillogin.anvilgui.AnvilGUI;
import net.islandearth.anvillogin.translation.Translations;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final AnvilLogin plugin;

    public PlayerListener(AnvilLogin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent pje) {
        boolean pass;
        Player myPlayer = pje.getPlayer();
        boolean bl = pass = !this.plugin.isAuthme() || AuthMeApi.getInstance().isRegistered(myPlayer.getName());
        if (!myPlayer.hasPermission("AnvilLogin.bypass") && !this.plugin.getLoggedIn().contains(myPlayer.getUniqueId()) && pass) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.plugin.getNotLoggedIn().add(myPlayer.getUniqueId());
                new AnvilGUI.Builder().onComplete((player, text) -> {
                    if (text.equalsIgnoreCase(this.plugin.getConfig().getString("Password")) || this.plugin.isAuthme() && AuthMeApi.getInstance().checkPassword(player.getName(), text)) {
                        this.plugin.getLoggedIn().add(player.getUniqueId());
                        this.plugin.getNotLoggedIn().remove(player.getUniqueId());
                        Translations.LOGGED_IN.send((Player)player);
                        if (this.plugin.isAuthme()) {
                            AuthMeApi.getInstance().forceLogin(player);
                        }
                        player.setLevel(player.getLevel());
                        return AnvilGUI.Response.close();
                    }
                    return AnvilGUI.Response.text(Translations.GUI_WRONG.get(myPlayer));
                }).preventClose().text(Translations.GUI_TEXT.get(myPlayer)).item(new ItemStack(Material.ANVIL)).title(Translations.GUI_TITLE.get(myPlayer)).plugin((Plugin)this.plugin).open(myPlayer);
            }, 40L);
            if (this.plugin.getConfig().getBoolean("Timeout")) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (!this.plugin.getLoggedIn().contains(myPlayer.getUniqueId())) {
                        myPlayer.kickPlayer(Translations.KICKED.get(myPlayer));
                    }
                }, this.plugin.getConfig().getLong("Time"));
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent pqe) {
        Player player = pqe.getPlayer();
        this.plugin.getLoggedIn().remove(player.getUniqueId());
        this.plugin.getNotLoggedIn().remove(player.getUniqueId());
    }

    @EventHandler
    public void onClose(InventoryCloseEvent ice) {
        if (ice.getPlayer() instanceof Player) {
            Player player = (Player)ice.getPlayer();
            if (ice.getInventory().getType() == InventoryType.ANVIL && this.plugin.getNotLoggedIn().contains(player.getUniqueId()) && !this.plugin.getLoggedIn().contains(player.getUniqueId())) {
                player.kickPlayer(Translations.CLOSED_INVENTORY.get(player));
            }
        }
    }
}

