package csokicraft.util.signlib;

import java.io.*;
import java.security.*;

import static csokicraft.util.signlib.SignLibHost.PKID_HI;
import static csokicraft.util.signlib.SignLibHost.PKID_SUP;

/** The abstract SignLib user (client). Capable of answering to HIs with SUPs using the local private key.
 * @author CsokiCraft */
public abstract class SignLibUser{
	protected PrivateKey privkey;
	
	public SignLibUser(PrivateKey key){
		privkey=key;
	}
	
	public void onInbound(InputStream in, OutputStream out) throws IOException, GeneralSecurityException{
		int pkid=in.read();
		switch(pkid){
		case PKID_HI:
			processHi(in, out);
			break;
		}
	}

	/** Processes HI and responds with SUP. Calls {@link #sendCmd(OutputStream)} to write the 'clen' and 'cmd' fields */
	private void processHi(InputStream in, OutputStream out) throws IOException, GeneralSecurityException{
		int id=in.read();
		int dataLenLo=in.read();
		int dataLenHi=in.read();
		int dataLen=(dataLenHi<<8)|dataLenLo;
		byte[] bData=new byte[dataLen];
		in.read(bData);
		out.write(PKID_SUP);
		out.write(id);
		byte[] bCmd=getCmd();
		
		byte[] bPayload=new byte[bData.length+bCmd.length];
		System.arraycopy(bData, 0, bPayload, 0, bData.length);
		System.arraycopy(bCmd, 0, bPayload, bData.length, bCmd.length);
		
		SignLibImpl.sign(new ByteArrayInputStream(bPayload), out, privkey);
		
		out.write(bCmd.length);
		out.write(bCmd.length>>8);
		out.write(bCmd);
	}

	protected abstract byte[] getCmd() throws IOException;
}
