package csokicraft.util.geom;

public class Vector3<T extends Number> extends Vector2<T> {
	protected T k;
	
	public Vector3(T a, T b, T c){
		super(a, b);
		k=c;
	}
	
	public Vector3(Vector2<T> vec, T c){
		this(vec.i, vec.j, c);
	}
	
	public T getZ(){
		return k;
	}
	
	@Override
	public IPoint<T> translate(IPoint<T> p){
		Point2<T> pt=(Point2<T>) super.translate(p);
		if(pt!=null) return new Point3<T>(pt, k); //Handle 2D point translation
		if(p instanceof Point3){
			Point3<T> p3=(Point3<T>) p;
			return new Point3<T>(GenericNumberArithmeticHelper.add(getX(), p3.getX()), GenericNumberArithmeticHelper.add(getY(), p3.getY()), GenericNumberArithmeticHelper.add(getZ(), p3.getZ()));
		}
		return null;
	}
	
	@Override
	public int getDimensions() {
		return 3;
	}
	
	@Override
	public double getLength(){
		return Math.sqrt(GenericNumberArithmeticHelper.add(GenericNumberArithmeticHelper.square(i), GenericNumberArithmeticHelper.add(GenericNumberArithmeticHelper.square(j), GenericNumberArithmeticHelper.square(k))).doubleValue());
	}
}
