package csokicraft.util.geom;

/** A basic point interface used by my geometry package
 * @author CsokiCraft*/
public interface IPoint<T extends Number> {
	/** @return the number of dimensions this point has
	  * It is a positive integer between 1 and 5 (1 doesn't make much sense, though)*/
	public int getDimensions();
	/** Please also implement other size-getters aswell
	  * (getY, getZ, getW, getQ)
	  * @return the length of the X base vector.*/
	public T getX();
	/** @return the vector pointing from (0;0) to here*/
	public IVector<T> getBaseVec();
}
