package csokicraft.util.geom;

public class ExactVector2<T extends Number> extends Vector2<T> implements IExactVector<T> {
	/** Coords of starting point */
	protected T i2, j2;
	
	public ExactVector2(Point2<T> start, Point2<T> end) {
		super(end.getX(), end.getY());
		i2=start.getX();
		j2=start.getY();
	}

	@Override
	public IPoint<T> translate(IPoint<T> p) {
		return getBaseVec().translate(p);
	}
	
	@Override
	public IVector<T> getBaseVec() {
		return new Vector2<T>(GenericNumberArithmeticHelper.subtract(i, i2), GenericNumberArithmeticHelper.subtract(j, j2));
	}

	@Override
	public IPoint<T> getBasePoint() {
		return new Point2<T>(i2, j2);
	}

	@Override
	public double getLength(){
		return getBaseVec().getLength();
	}
}
