package csokicraft.util.eqdf.novacompiler.ast;

import java.util.List;

import csokicraft.util.eqdf.compile.EqdfCompiler;
import csokicraft.util.eqdf.novacompiler.ast.impl.ValueNode;

public class OperationNode implements SyntaxNode{
	protected SyntaxNode left, right;
	/** Returns the infix representation of this operator */
	protected char operator;

	public OperationNode(SyntaxNode nLeft, SyntaxNode nRight, char ch){
		left=nLeft;
		right=nRight;
		operator=ch;
	}
	
	@Override
	public void addInstructions(List<Object> l){
		left.addInstructions(l);
		right.addInstructions(l);
		l.add(EqdfCompiler.getOperator(operator));
	}
	
	@Override
	public String toString(){
		String leftStr, rightStr;
		if(left instanceof ValueNode){
			leftStr=left.toString();
		}else{
			leftStr="("+left.toString()+")";
		}
		
		if(right instanceof ValueNode){
			rightStr=right.toString();
		}else{
			rightStr="("+right.toString()+")";
		}
		return leftStr+operator+rightStr;
	}
}
