package csokicraft.util;

import java.io.*;

/** An {@link InputStream} which reads through a given {@link String}.
  * @author CsokiCraft */
public class StringInputStream extends InputStream {
	private String data;
	private int pos;
	
	/** @param offset -1=print length and then start string;0=start from start;n=leave out first n characters*/
	public StringInputStream(String s, int offset) {
		data = s;
		pos = offset;
	}
	
	/** Here, the first read character will be the length of the stream.
	  * To disable this behaviour, call {@link StringInputStream#StringInputStream(String, int)} with 0 as the second parameter.*/
	public StringInputStream(String s) {
		this(s, -1);
	}

	@Override
	public int read() throws IOException {
		if(pos == -1){
			pos++;
			return (byte) data.length();
		}else if(pos >= data.length())
			return -1;
		return (byte) data.charAt(pos++);
	}

	@Override
	public int available() throws IOException {
		return data.length()-pos;
	}
}
