package csokicraft.util;

import java.util.HashMap;

/** A data structure to link every element V, to a unique Integer id.
  * One could say, it's like a "sparse HashMap" with Integers as keys.
  * @author CsokiCraft*/
public class IndexableTable<V> extends HashMap<Integer, V>{
	private static final long serialVersionUID = 7348123393725268887L;

	private int lastIdx=-1;

	public int lastIndexOf(V val){
		for(int i=0;i<size();i++){
			V el=get(i);
			if(el==null){
				if(val==null) return i;
			}else{
				if(el.equals(val)) return i;
			}
		}
		return -1;
	}
	
	@Override
	public V put(Integer key, V value){
		if(key>lastIdx) lastIdx=key;
		return super.put(key, value);
	}
	
	@Override
	public V remove(Object key){
		V tmp=super.remove(key);
		if(lastIdx==(int) key) lastRemoved();
		return tmp;
	}

	private void lastRemoved(){
		while(lastIdx>0&&get(lastIdx)!=null) lastIdx--;
	}
	
	@Override
	public int size(){
		return lastIdx+1;
	}
}
