package csokicraft.util;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

/** A bunch of formatting utils made by me.
  * @author CsokiCraft*/
public class FormatterUtil{
	public static final SimpleDateFormat dateFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	/** Formats the given int/long to have a postfix (k,M,G etc.) after it.
	  * @return the formatted {@link String}
	  * @param n the number to format
	  * @see #formatPostfix2(long)*/
	public static String formatPostfix(long n){
		String[] p=new String[]{"", "k", "M", "G", "T", "Y"};
		int i=0;
		while(n>1000){
			n/=1000;
			i++;
		}
		return n+p[i];
	}
	
	/** Works like {@link #formatPostfix(long)}, but in base 2 (so 1ki=1024 and not 1000)
	  * @see #formatPostfix(long)*/
	public static String formatPostfix2(long n){
		String[] p=new String[]{"", "ki", "Mi", "Gi", "Ti", "Yi"};
		int i=0;
		while(n>1024){
			n/=1024;
			i++;
		}
		return n+p[i];
	}
	
	/** Returns a formatted {@link String} from {@link File#lastModified()}*/
	public static String lastModified(File f){
		return dateFormat.format(new Date(f.lastModified()));
	}
	
	public static String capitalise(String str){
		if(str==null||str.isEmpty()) return str;
		return Character.toUpperCase(str.charAt(0))+str.substring(1);
	}
}
