package csokicraft.util.signlib.test;

import java.io.*;
import java.security.*;

import csokicraft.util.*;
import csokicraft.util.signlib.*;
import csokicraft.util.streaming.TruncatingSafeQueuedStream;

/** A virtual host-client environment
  * @author CsokiCraft */
public class TestSignLib {
	public static void runTest(File pubkey, File privkey){
		try{
			SignLibHost host=new TestHost(pubkey);
			SignLibUser user=new TestUser(privkey);
			
			/** C -> S */
			QueuedStream uplink=new TruncatingSafeQueuedStream();
			/** S -> C */
			QueuedStream downlink=new TruncatingSafeQueuedStream();
			
			host.onConnect(downlink.getOutputStream());
			user.onInbound(downlink.getInputStream(), uplink.getOutputStream());
			host.onInbound(uplink.getInputStream());
			
			System.out.println("Test finished!");
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private static class TestHost extends SignLibHost{

		public TestHost(File pubkey) throws FileNotFoundException, IOException, GeneralSecurityException{
			super(SignLibImpl.readPubKey(new FileInputStream(pubkey)));
		}

		@Override
		protected void processCmd(byte[] bCmd){
			System.out.println("Verified! "+new String(bCmd));
		}

		@Override
		protected void onRefuse(byte[] bCmd){
			System.out.println("Failed! "+new String(bCmd));
			try {
				FileOutputStream fout=new FileOutputStream("fail.dat");
				fout.write(data.get(0).array());
				fout.close();
			} catch (IOException e){
				throw new RuntimeException(e);
			}
		}
	}
	
	private static class TestUser extends SignLibUser{

		public TestUser(File privkey) throws FileNotFoundException, IOException, GeneralSecurityException{
			super(SignLibImpl.readPrivKey(new FileInputStream(privkey)));
		}
		
		@Override
		protected byte[] getCmd() throws IOException{
			return "HelloWorld".getBytes();
		}
	}
}
