package csokicraft.util.signlib;

import static csokicraft.util.signlib.SignLibImpl.*;

import java.io.*;
import java.security.*;
import csokicraft.util.StringInputStream;
import csokicraft.util.signlib.test.TestSignLib;

/** Command line utilities for SignLib<br>
  * Arguments:<br>
  * -g: generates an RSA keypair
  * -s: signs 'data' with the private key
  * -v: verifies 'data' with the signature and public key
  * -m: simulates a client-server environment */
public class SignLibCmd{
	/** String from random.org, with a bit of manual mixing */
	public static final String data="9tC866696niPMclF869KGe885459pztcqLc99111";

	public static void main(String[] args) throws IOException, GeneralSecurityException{
		if(args.length!=3){
			System.err.println("Usage:");
			System.err.println("  signlib -g <pubkey> <privkey>");
			System.err.println("  signlib -s <privkey> <sigfile>");
			System.err.println("  signlib -v <pubkey> <sigfile>");
			System.err.println("  signlib -m <pubkey> <privkey>");
			System.exit(1);
		}
		switch(args[0].toLowerCase()){
		case "-g":
			genKeys(args[1], args[2]);
			break;
		case "-s":
			signData(args[1], args[2], data);
			break;
		case "-v":
			verifyData(args[1], args[2], data);
			break;
		case "-m":
			TestSignLib.runTest(new File(args[1]), new File(args[2]));
			break;
		default:
			System.err.println("No such operation: "+args[0]);
			break;
		}
	}
	private static void genKeys(String pubLoc, String privLoc) throws IOException, GeneralSecurityException{
		FileOutputStream pub=new FileOutputStream(pubLoc),
						priv=new FileOutputStream(privLoc);
		writeKeyPair(createPair(), pub, priv);
		System.out.println("Keypair written!");
	}

	private static void signData(String privLoc, String sigLoc, String data) throws IOException, GeneralSecurityException{
		StringInputStream sin=new StringInputStream(data, 0);
		FileInputStream fin=new FileInputStream(privLoc);
		FileOutputStream fout=new FileOutputStream(sigLoc);
		
		PrivateKey privkey=readPrivKey(fin);
		
		sign(sin, fout, privkey);
		System.out.println("Signed!");
	}

	private static void verifyData(String pubLoc, String sigLoc, String data) throws IOException, GeneralSecurityException{
		StringInputStream sin=new StringInputStream(data, 0);
		FileInputStream fin=new FileInputStream(pubLoc);
		FileInputStream sigFile=new FileInputStream(sigLoc);
		
		PublicKey pubkey=readPubKey(fin);
		
		boolean b=verify(sin, sigFile, pubkey);
		
		if(b){
			System.out.println("Signature verified!");
		}else{
			System.out.println("Signature failed!");
		}
	}

}
