package csokicraft.util.mgmt;

import csokicraft.util.mgmt.ProjectManager.UpdReport;

/** An interface for storing data to be used in {@link ProjectManager}
 * @author CsokiCraft*/
public interface Updatable {
	public void onVersionChecked(UpdReport rep);
	public void onCheckFailed(Throwable cause);
	
	public String name();
	/** A numeric representation of the version, used for comparing
	  * versions. Usually the same as {@link Updatable#verStr()}*/
	public double verNum();
	/** The version to be displayed. May contain non-numbers,
	  * such as a, b, c,...,alpha,beta,release etc.*/
	public String verStr();
}
