package csokicraft.util.mgmt;

import java.io.*;
import java.net.*;
import java.util.*;

import csokicraft.util.MessengerException;

/** A class to handle project-related tasks, such as auto-update
  * @author CsokiCraft*/
public class ProjectManager {
	protected List<UpdTask> tasks;
	
	public static ProjectManager mgr=new ProjectManager();
	
	protected ProjectManager(){
		tasks=new LinkedList<>();
	}
	
	public void register(Updatable cls){
		tasks.add(new UpdTask(cls));
	}
	
	static class UpdTask extends Thread{
		Updatable cls;
		UpdReport rep=null;
		
		public UpdTask(Updatable sender) {
			cls=sender;
		}
		
		@Override
		public void run() {
			if(rep!=null) interrupt();
			try{
				URLConnection con=new URL("http://csokicraft.agyklub.hu/updates?name="+cls.name()).openConnection();
				BufferedReader br=new BufferedReader(new InputStreamReader(con.getInputStream()));
				String name=br.readLine();
				double num=Double.parseDouble(br.readLine());
				String verStr=br.readLine();
				String msg = "", ln;
				while((ln=br.readLine())!=null)
					msg = msg.concat(ln);
				cls.onVersionChecked(new UpdReport(name, num, verStr, msg));
				br.close();
			}catch(IOException e){
				cls.onCheckFailed(e);
			}catch(Exception e){
				cls.onCheckFailed(new MessengerException("Couldn't check for updates", e));
			}
			cls.onVersionChecked(rep);
			mgr.tasks.remove(this);
		}
	}
	
	public static class UpdReport{
		public UpdatableDummy latest;
		public String msg;
		
		public UpdReport(String name, double verNum, String verStr, String updMsg) {
			latest=new UpdatableDummy(name, verNum, verStr);
			msg=updMsg;
		}
	}
}
