package csokicraft.util.mcforge;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;

/** Things I commonly need for MCForge. Do not load in a non-MCForge domain!
  * Disclaimer: This version of UtilMcForge ONLY works on 1.11&1.12.
  * If you need it to work on older versions, use {@link UtilMcForge}
  * @author CsokiCraft*/
@Mod(modid="csokicraftutil-11", version="1.3.1", acceptedMinecraftVersions="1.11+")
public class UtilMcForge11{
	public static void moveAll(IItemHandler src, IItemHandler dest){
		int lenSrc=src.getSlots(), lenDest=dest.getSlots();
		outer:for(int i=0;i<lenSrc;i++){
			ItemStack slot=src.getStackInSlot(i);
			if(slot.isEmpty()) continue outer;
			inner:for(int j=0;j<lenDest;j++){
				ItemStack remain=dest.insertItem(j, slot, true);
				int consumed=slot.getCount();
				if(!remain.isEmpty())
					consumed-=remain.getCount();
				if(consumed>0){
					ItemStack ex=src.extractItem(i, consumed, false);
					dest.insertItem(j, ex, false);
					slot.setCount(slot.getCount()-consumed);
					if(slot.getCount()<=0)
						break inner;
				}
			}
		}
	}

	/** Gives the ItemStack to the player. <br>
	  * Only call server-side! */
	public static void giveItemStack(EntityPlayer p, ItemStack is){
		EntityItem ent=new EntityItem(p.getEntityWorld(), p.posX, p.posY, p.posZ, is);
		ent.setNoPickupDelay();
		ent.setOwner(p.getCommandSenderEntity().getName());
		p.getEntityWorld().spawnEntity(ent);
	}
}
