package csokicraft.util.geom;

/** A basic vector interface used by my geometry package
  * @author CsokiCraft*/
public interface IVector<T extends Number> {
	/** @return the number of dimensions this vector has
	  * It is a positive integer between 1 and 5 (1 doesn't make much sense, though)*/
	public int getDimensions();
	/** Please also implement other size-getters aswell
	  * (getY, getZ, getW, getQ)
	  * @return the X length of the vector.*/
	public T getX();
	
	public IPoint<T> translate(IPoint<T> p);
	/** @return the end point of this vector*/
	public IPoint<T> getEndPoint();
	/** The length of the vector */
	public double getLength();
}
