package csokicraft.util.geom;

/** An {@link IVector} with a given starting point
  * @author CsokiCraft
  * Also note: {@link #getBaseVec()} will return a vector
  * same as this, just its base point at (0;0)*/
public interface IExactVector<T extends Number> extends IVector<T>, IPoint<T> {
	public IPoint<T> getBasePoint();
	/** @return this vector with its base point set to (0;0)*/
	@Override
	public IVector<T> getBaseVec();
}
