package csokicraft.util.geom;

import java.math.*;

/** A helper class for doing arithmetic with generic {@link Number} types
  * @author CsokiCraft */
@SuppressWarnings("unchecked")
public class GenericNumberArithmeticHelper{
	private static <T> void paramsValid(T a, T b){
		if(a==null||b==null)
			throw new NullPointerException("Can't do arithmetic on null!");
		Class<? extends Object> cA=a.getClass();
		Class<? extends Object> cB=b.getClass();
		if(!cA.equals(cB))
			throw new IllegalArgumentException("Type mismatch: "+cA.getName()+" is not "+cB.getName());
	}
	
	public static <T extends Number> T add(T a, T b){
		paramsValid(a, b);
		
		if(a instanceof Integer){
			return (T) Integer.valueOf(a.intValue()+b.intValue());
		}

		if(a instanceof Long){
			return (T) Long.valueOf(a.longValue()+b.longValue());
		}

		if(a instanceof Float){
			return (T) Float.valueOf(a.floatValue()+b.floatValue());
		}

		if(a instanceof Double){
			return (T) Double.valueOf(a.doubleValue()+b.doubleValue());
		}

		if(a instanceof BigDecimal){
			return (T) ((BigDecimal) a).add((BigDecimal) b);
		}

		if(a instanceof BigInteger){
			return (T) ((BigInteger) a).add((BigInteger) b);
		}
		
		throw new RuntimeException("Unexpected number type: "+a.getClass().getName());
	}
	
	public static <T extends Number> T subtract(T a, T b){
		paramsValid(a, b);
		
		if(a instanceof Integer){
			return (T) Integer.valueOf(a.intValue()-b.intValue());
		}

		if(a instanceof Long){
			return (T) Long.valueOf(a.longValue()-b.longValue());
		}

		if(a instanceof Float){
			return (T) Float.valueOf(a.floatValue()-b.floatValue());
		}

		if(a instanceof Double){
			return (T) Double.valueOf(a.doubleValue()-b.doubleValue());
		}

		if(a instanceof BigDecimal){
			return (T) ((BigDecimal) a).subtract((BigDecimal) b);
		}

		if(a instanceof BigInteger){
			return (T) ((BigInteger) a).subtract((BigInteger) b);
		}
		
		throw new RuntimeException("Unexpected number type: "+a.getClass().getName());
	}
	
	public static <T extends Number> T multiply(T a, T b){
		paramsValid(a, b);
		
		if(a instanceof Integer){
			return (T) Integer.valueOf(a.intValue()*b.intValue());
		}

		if(a instanceof Long){
			return (T) Long.valueOf(a.longValue()*b.longValue());
		}

		if(a instanceof Float){
			return (T) Float.valueOf(a.floatValue()*b.floatValue());
		}

		if(a instanceof Double){
			return (T) Double.valueOf(a.doubleValue()*b.doubleValue());
		}

		if(a instanceof BigDecimal){
			return (T) ((BigDecimal) a).multiply((BigDecimal) b);
		}

		if(a instanceof BigInteger){
			return (T) ((BigInteger) a).multiply((BigInteger) b);
		}
		
		throw new RuntimeException("Unexpected number type: "+a.getClass().getName());
	}
	
	public static <T extends Number> T square(T a){
		return multiply(a, a);
	}
}
