package csokicraft.util.eqdf.test;

import java.io.*;

import csokicraft.util.eqdf.MathContext;
import csokicraft.util.eqdf.compile.EqdfCompiler;
import csokicraft.util.eqdf.compile.IEqdfCompiler;
import csokicraft.util.eqdf.novacompiler.NovaEqdfCompiler;

/** A test/demonstration class for the EQDF compiler.
  * Takes an expression from STDIN and executes it. Type "quit" to exit.
  * @author CsokiCraft*/
public class EqdfTest{
	public static void main(String[] args){
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		String ln;
		MathContext last = null;
		IEqdfCompiler compiler;
		if(args.length>0&&"--nova".equals(args[0])) {
			compiler=new NovaEqdfCompiler();
		}else {
			compiler = new EqdfCompiler();
		}
		try {
			while(!(ln = in.readLine()).equals("quit")){
				MathContext ctx = compiler.compile(ln);
				compiler.clean();
				ctx.importVars(last);
				System.out.println(ctx.exec());
				last = ctx;
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
