package csokicraft.util.eqdf.novacompiler.ast.impl;

import java.util.List;

import csokicraft.util.eqdf.compile.EqdfInstructionSet;
import csokicraft.util.eqdf.novacompiler.ast.SyntaxNode;
import csokicraft.util.eqdf.novacompiler.ast.UnaryNode;

public class UnaryNegationNode extends UnaryNode {

	public UnaryNegationNode(SyntaxNode node){
		super(node);
	}

	@Override
	public void addInstructions(List<Object> l){
		child.addInstructions(l);
		l.add(EqdfInstructionSet.CONST);
		l.add(-1.0);
		l.add(EqdfInstructionSet.OP_MUL);
	}

	@Override
	public String getPrefix(){
		return "-";
	}

}
