package csokicraft.util.eqdf.compile;

import java.util.Stack;

/** An utility class where the EQDF functions were exported to.
  * @author CsokiCraft */
public class EqdfFunctions {
	public static final double
			TAU=2*Math.PI,
			PHI=(1+Math.sqrt(5))/2d;
	
	public static void callF(String funName, Stack<Double> stack){
		switch (funName){
		case "pi":
			stack.push(Math.PI);
			break;
		case "tau":
			stack.push(TAU);
			break;
		case "e":
			stack.push(Math.E);
			break;
		case "phi":
			stack.push(PHI);
			break;
		
		case "floor":
			stack.push(Math.floor(stack.pop()));
			break;
		case "ceil":
			stack.push(Math.ceil(stack.pop()));
			break;
		case "round":
			Long res = Long.valueOf(Math.round(stack.pop()));
			stack.push(res.doubleValue());
			break;
		case "frac":
			double x = stack.pop();
			stack.push(x-Math.floor(x));
			break;
		case "sqrt":
			stack.push(Math.sqrt(stack.pop()));
			break;
		case "sgn":
			stack.push(Math.signum(stack.pop()));
			break;
		case "abs":
			stack.push(Math.abs(stack.pop()));
			break;
		case "sin":
			stack.push(Math.sin(stack.pop()));
			break;
		case "cos":
			stack.push(Math.cos(stack.pop()));
			break;
		case "tg":
		case "tan":
			stack.push(Math.tan(stack.pop()));
			break;
		case "ctg":
			stack.push(1.0/Math.tan(stack.pop()));
			break;
		case "sec":
			stack.push(1.0/Math.cos(stack.pop()));
			break;
		case "csc":
		case "cosec":
			stack.push(1.0/Math.sin(stack.pop()));
			break;
		case "arcsin":
			stack.push(Math.asin(stack.pop()));
			break;
		case "arccos":
			stack.push(Math.acos(stack.pop()));
			break;
		case "arctan":
			stack.push(Math.atan(stack.pop()));
			break;
		case "log_e":
		case "ln":
			double n = stack.pop();
			stack.push(Math.log(n));
			break;
		case "log_10":
		case "lg":
			double m = stack.pop();
			stack.push(Math.log10(m));
			break;
		
		case "pow":
			double  b = stack.pop(),
					a = stack.pop();
			stack.push(Math.pow(a, b));
			break;
		}
	}

	public static int getArgc(String value){
		switch(value) {
		case "pi":
		case "tau":
		case "e":
		case "phi":
			return 0;
			
		case "floor":
		case "ceil":
		case "round":
		case "frac":
		case "sqrt":
		case "sgn":
		case "abs":
		case "sin":
		case "cos":
		case "tg":
		case "tan":
		case "ctg":
		case "sec":
		case "csc":
		case "cosec":
		case "arcsin":
		case "arccos":
		case "arctan":
		case "log_e":
		case "ln":
		case "log_10":
		case "lg":
			return 1;
		case "pow":
			return 2;
		}
		return -1;
	}
}
