package csokicraft.util;

import java.io.*;
import java.util.*;

/** An {@link OutputStream} which collects all data into a {@link String}
  * @author CsokiCraft */
public class StringOutputStream extends OutputStream {
	
	private List<Character> data;
	private int pos;
	
	/**@param offset Number of bytes to leave out at the beginning */
	public StringOutputStream(int offset) {
		data = new ArrayList<>();
		pos=offset;
	}
	
	/** Unlike {@link StringInputStream}, it won't take
	  * the first byte to be the length. To void said
	  * byte, use <code>new StringOutputStream(1)</code>*/
	public StringOutputStream() {
		this(0);
	}

	@Override
	public void write(int b) throws IOException {
		if(pos > 0) pos--;
		else data.add((char) b);
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		for(char c:data) sb.append(c);
		return sb.toString();
	}

}
