package csokicraft.util;

import java.io.IOException;

import csokicraft.util.streaming.TruncatingSafeQueuedStream;

/** Where "safe" means it won't crash if an underflow happens.
  * (i.e. reading from an empty {@link SafeQueuedStream} will return -1 w/o throwing {@link IOException})<br>
  * Note: you may have a -1 in the queue. To prevent that, use {@link TruncatingSafeQueuedStream}
  * @author CsokiCraft*/
public class SafeQueuedStream extends QueuedStream {
	@Override
	public int read() throws IOException {
		if(!ready()) return -1;
		return super.read();
	}
}
