package csokicraft.util;

import java.util.*;

/** As the title says, collection utils
  * @author CsokiCraft */
public class CollectionUtils {
	/** Constructs an {@link ArrayList} from the array.
	  * @deprecated Use {@link Arrays#asList(Object...)} */
	@Deprecated
	public static <T> List<T> fromArray(T[] arr){
		List<T> l=new ArrayList<T>();
		for(T o:arr)
			l.add(o);
		return l;
	}
	
	/** Constructs an {@link ArrayList} from the {@link Iterable}.
	  * Allows for wider usage than its array-only counterpart.*/
	public static <T> List<T> toList(Iterable<T> arr) {
		List<T> l=new ArrayList<T>();
		for(T o:arr)
			l.add(o);
		return l;
	}
	
	/** Builds a string from the {@link Iterable}'s elements and appends a separator.
	  * If no separator is to be added, use <code>null</code>*/
	public static String concat(Iterable<? extends Object> arr, String separator){
		StringBuilder b = new StringBuilder();
		Iterator<? extends Object> it = arr.iterator();
		while(it.hasNext()){
			Object o = it.next();
			if(o!=null)
				b.append(o.toString());
			if(it.hasNext()&&separator!=null)
				b.append(separator);
		}
		return b.toString();
	}
	
	/** Checks whether the {@link Iterable} contains the item. The item may be null. */
	public static <T> boolean contains(Iterable<T> coll, T item){
		for(T t:coll)
			if(equals(t, item))
				return true;
		return false;
	}

	/** Checks whether the array contains the item. The item may be null.
	  * Honestly, arrays should be {@link Iterable}s. */
	public static <T> boolean contains(T[] coll, T item){
		for(T t:coll)
			if(equals(t, item))
				return true;
		return false;
	}

	/** Checks whether the two items are either both null, or they're non-null and equal */
	public static <T> boolean equals(T a, T b){
		return a==null?b==null:a.equals(b);
	}
}
