/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.network;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.RoundRobinIterator;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.handler.ServerTickHandler;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.IPowerStorage;
import crazypants.enderio.base.power.PerTickIntAverageCalculator;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.powertools.machine.capbank.CapBankType;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.EnergyReceptor;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.powertools.machine.capbank.network.NetworkState;
import crazypants.enderio.powertools.machine.capbank.network.NetworkUtil;
import crazypants.enderio.powertools.machine.capbank.packet.PacketNetworkEnergyResponse;
import crazypants.enderio.powertools.machine.capbank.packet.PacketNetworkStateResponse;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapBankNetwork
implements ICapBankNetwork,
ServerTickHandler.ITickListener {
    private static final int IO_CAP = 2000000000;
    @Nonnull
    private final List<TileCapBank> capBanks = new ArrayList<TileCapBank>();
    @Nonnull
    private final Set<EnergyReceptor> receptors = new HashSet<EnergyReceptor>();
    private RoundRobinIterator<EnergyReceptor> receptorIterator;
    private final int id;
    private int maxIO;
    private int maxInput = -1;
    private int maxOutput = -1;
    private long energyStored;
    private long prevEnergyStored = -1L;
    private long energyReceived;
    private long energySend;
    private long maxEnergyStored;
    private CapBankType type;
    @Nonnull
    private final Set<BlockPos> redstoneRecievers = new HashSet<BlockPos>();
    @Nonnull
    private RedstoneControlMode inputControlMode = RedstoneControlMode.IGNORE;
    @Nonnull
    private RedstoneControlMode outputControlMode = RedstoneControlMode.IGNORE;
    private boolean inputRedstoneConditionMet = true;
    private boolean outputRedstoneConditionMet = true;
    @Nonnull
    private final PerTickIntAverageCalculator powerTrackerIn = new PerTickIntAverageCalculator(2);
    @Nonnull
    private final PerTickIntAverageCalculator powerTrackerOut = new PerTickIntAverageCalculator(2);
    private boolean firstUpate = true;

    public CapBankNetwork(int id) {
        this.id = id;
    }

    public void init(TileCapBank cap) {
        if (cap.func_145831_w().field_72995_K) {
            throw new UnsupportedOperationException();
        }
        this.type = cap.getType();
        this.inputControlMode = cap.getInputControlMode();
        this.outputControlMode = cap.getOutputControlMode();
        for (TileCapBank con : NetworkUtil.getAllNeigbours(cap)) {
            ICapBankNetwork network = con.getNetwork();
            if (network != null) {
                network.destroyNetwork();
            }
            con.setNetwork(this);
            this.addMember(con);
        }
        this.addEnergy(0);
        ServerTickHandler.addListener(this);
    }

    @Override
    public void destroyNetwork() {
        ServerTickHandler.removeListener(this);
        this.distributeEnergyToBanks();
        for (TileCapBank cb : this.capBanks) {
            cb.setNetwork(null);
        }
        this.capBanks.clear();
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketNetworkStateResponse(this, true));
    }

    @Override
    @Nonnull
    public Collection<TileCapBank> getMembers() {
        return this.capBanks;
    }

    @Override
    public void addMember(@Nonnull TileCapBank cap) {
        if (!this.capBanks.contains(cap)) {
            StringBuilder sb;
            this.capBanks.add(cap);
            long newIO = (long)this.maxIO + (long)cap.getType().getMaxIO();
            if (newIO > 2000000000L) {
                newIO = 2000000000L;
            }
            this.maxIO = (int)newIO;
            this.energyStored += (long)cap.getEnergyStored();
            this.maxEnergyStored += (long)cap.getMaxEnergyStored();
            if (this.maxInput == -1) {
                this.maxInput = cap.getMaxInputOverride();
                if (((Boolean)DiagnosticsConfig.debugTraceCapLimitsExtremelyDetailed.get()).booleanValue()) {
                    sb = new StringBuilder("CapBankNetwork ").append(this).append(" intput changed from -1 to ").append(this.maxInput);
                    for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                        sb.append(" at ").append(elem);
                    }
                    Log.warn(sb);
                }
            }
            if (this.maxOutput == -1) {
                this.maxOutput = cap.getMaxOutputOverride();
                if (((Boolean)DiagnosticsConfig.debugTraceCapLimitsExtremelyDetailed.get()).booleanValue()) {
                    sb = new StringBuilder("CapBankNetwork ").append(this).append(" output changed from -1 to ").append(this.maxOutput);
                    for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                        sb.append(" at ").append(elem);
                    }
                    Log.warn(sb);
                }
            }
            cap.setInputControlMode(this.inputControlMode);
            cap.setOutputControlMode(this.outputControlMode);
            List<EnergyReceptor> recs = cap.getReceptors();
            if (!recs.isEmpty()) {
                this.addReceptors(recs);
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public NetworkState getState() {
        return new NetworkState(this);
    }

    @Override
    public void tickEnd(TickEvent.ServerTickEvent evt, @Nullable Profiler profiler) {
        Prof.start(profiler, "EnergyTransmitting");
        this.transmitEnergy();
        if (this.energyStored != this.prevEnergyStored) {
            Prof.next(profiler, "EnergyBalancing");
            this.distributeEnergyToBanks();
        }
        Prof.next(profiler, "EnergyTracking");
        this.powerTrackerIn.tick(this.energyReceived);
        this.powerTrackerOut.tick(this.energySend);
        this.prevEnergyStored = this.energyStored;
        this.energyReceived = 0L;
        this.energySend = 0L;
        Prof.stop(profiler);
        if (this.firstUpate) {
            if (!this.capBanks.isEmpty()) {
                PacketHandler.sendToAllAround(new PacketNetworkStateResponse(this), (TileEntity)this.capBanks.get(0));
                PacketHandler.sendToAllAround(new PacketNetworkEnergyResponse(this), (TileEntity)this.capBanks.get(0));
            }
            this.firstUpate = false;
        }
    }

    private void transmitEnergy() {
        if (!this.outputRedstoneConditionMet) {
            return;
        }
        if (this.receptors.isEmpty()) {
            return;
        }
        int available = this.getEnergyAvailableForTick(this.getMaxOutput());
        if (available <= 0) {
            return;
        }
        if (this.receptorIterator == null) {
            ArrayList<EnergyReceptor> rl = new ArrayList<EnergyReceptor>(this.receptors);
            this.receptorIterator = new RoundRobinIterator(rl);
        }
        int totalSent = 0;
        Iterator iter = this.receptorIterator.iterator();
        while (available > 0 && iter.hasNext()) {
            int sent = this.sendPowerTo((EnergyReceptor)iter.next(), available);
            totalSent += sent;
            available -= sent;
        }
        this.addEnergy(-totalSent);
    }

    protected int getEnergyAvailableForTick(int limit) {
        int available = this.energyStored > (long)limit ? limit : (int)this.energyStored;
        return available;
    }

    private int sendPowerTo(EnergyReceptor next, int available) {
        IPowerConduit con = next.getConduit();
        if (con != null && next.getMode() == IoMode.NONE && con.getConnectionMode(next.getDir().func_176734_d()) == ConnectionMode.IN_OUT) {
            return 0;
        }
        IPowerInterface inf = next.getReceptor();
        int result = inf.receiveEnergy(available, false);
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public boolean chargeItems(NNList<ItemStack> items) {
        if (items == null) {
            return false;
        }
        boolean chargedItem = false;
        int available = this.getEnergyAvailableForTick(this.getMaxIO());
        for (ItemStack item : items) {
            int canUse;
            int used;
            IEnergyStorage chargable;
            if (item == null || !Prep.isValid(item) || available <= 0 || item.func_190916_E() != 1 || (chargable = PowerHandlerUtil.getCapability(item)) == null) continue;
            int max = chargable.getMaxEnergyStored();
            int cur = chargable.getEnergyStored();
            if (cur >= max || (used = chargable.receiveEnergy(canUse = Math.min(available, max - cur), false)) <= 0) continue;
            this.addEnergy(-used);
            chargedItem = true;
            available -= used;
        }
        return chargedItem;
    }

    private void distributeEnergyToBanks() {
        if (this.capBanks.isEmpty()) {
            return;
        }
        int energyPerCapBank = (int)(this.energyStored / (long)this.capBanks.size());
        int remaining = (int)(this.energyStored % (long)this.capBanks.size());
        for (TileCapBank cb : this.capBanks) {
            cb.setEnergyStored(energyPerCapBank + (remaining-- > 0 ? 1 : 0));
        }
    }

    @Override
    public float getAverageChangePerTick() {
        return this.powerTrackerIn.getAverage() - this.powerTrackerOut.getAverage();
    }

    @Override
    public int getAverageIOPerTick() {
        return Math.round(this.getAverageChangePerTick());
    }

    @Override
    public float getAverageInputPerTick() {
        return this.powerTrackerIn.getAverage();
    }

    @Override
    public float getAverageOutputPerTick() {
        return this.powerTrackerOut.getAverage();
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive <= 0 || !this.inputRedstoneConditionMet) {
            return 0;
        }
        long spaceAvailable = this.maxEnergyStored - this.energyStored;
        if (spaceAvailable > Integer.MAX_VALUE) {
            spaceAvailable = Integer.MAX_VALUE;
        }
        int res = Math.min(maxReceive, (int)spaceAvailable);
        res = Math.min(res, this.getMaxInput());
        if (!simulate) {
            this.addEnergy(res);
        }
        return res;
    }

    @Override
    public int addEnergy(int energy) {
        if (energy > 0) {
            this.energyReceived += (long)energy;
        } else {
            this.energySend -= (long)energy;
        }
        if (!this.type.isCreative()) {
            this.energyStored += (long)energy;
            if (this.energyStored > this.maxEnergyStored) {
                energy = (int)(this.energyStored - this.maxEnergyStored);
                this.energyStored = this.maxEnergyStored;
                this.energyReceived -= (long)energy;
                return energy;
            }
            if (this.energyStored < 0L) {
                this.energyStored = 0L;
            }
            return 0;
        }
        this.energyStored = this.maxEnergyStored / 2L;
        return 0;
    }

    public void addEnergyReceptor(EnergyReceptor rec) {
        this.receptors.add(rec);
        this.receptorIterator = null;
    }

    @Override
    public void addReceptors(@Nonnull Collection<EnergyReceptor> rec) {
        if (rec.isEmpty()) {
            return;
        }
        this.receptors.addAll(rec);
        this.receptorIterator = null;
    }

    @Override
    public void removeReceptors(@Nonnull Collection<EnergyReceptor> rec) {
        if (rec.isEmpty()) {
            return;
        }
        this.receptors.removeAll(rec);
        this.receptorIterator = null;
    }

    public void removeReceptor(EnergyReceptor rec) {
        this.receptors.remove(rec);
        this.receptorIterator = null;
    }

    @Override
    public long getEnergyStoredL() {
        return this.energyStored;
    }

    @Override
    public long getMaxEnergyStoredL() {
        return this.maxEnergyStored;
    }

    @Override
    public int getMaxIO() {
        return this.maxIO;
    }

    @Override
    public int getMaxInput() {
        if (this.maxInput == -1) {
            return this.maxIO;
        }
        return Math.min(this.maxInput, this.maxIO);
    }

    @Override
    public int getMaxOutput() {
        if (this.maxOutput == -1) {
            return this.maxIO;
        }
        return Math.min(this.maxOutput, this.maxIO);
    }

    @Override
    public void setMaxInput(int max) {
        if (((Boolean)DiagnosticsConfig.debugTraceCapLimitsExtremelyDetailed.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder("CapBankNetwork ").append(this).append(" intput changed from ").append(this.maxInput).append(" to ").append(max);
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
        this.maxInput = max >= this.maxIO ? -1 : (max < 0 ? 0 : max);
        for (TileCapBank cb : this.capBanks) {
            cb.setMaxInput(this.maxInput);
        }
    }

    @Override
    public void setMaxOutput(int max) {
        if (((Boolean)DiagnosticsConfig.debugTraceCapLimitsExtremelyDetailed.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder("CapBankNetwork ").append(this).append(" output changed from ").append(this.maxOutput).append(" to ").append(max);
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
        this.maxOutput = max >= this.maxIO ? -1 : (max < 0 ? 0 : max);
        for (TileCapBank cb : this.capBanks) {
            cb.setMaxOutput(this.maxOutput);
        }
    }

    @Override
    @Nonnull
    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    @Override
    public void setInputControlMode(@Nonnull RedstoneControlMode inputControlMode) {
        if (this.inputControlMode == inputControlMode) {
            return;
        }
        this.inputControlMode = inputControlMode;
        for (TileCapBank capBank : this.capBanks) {
            capBank.setInputControlMode(inputControlMode);
        }
        this.updateRedstoneConditions();
    }

    @Override
    @Nonnull
    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    @Override
    public void setOutputControlMode(@Nonnull RedstoneControlMode outputControlMode) {
        if (this.outputControlMode == outputControlMode) {
            return;
        }
        this.outputControlMode = outputControlMode;
        for (TileCapBank capBank : this.capBanks) {
            capBank.setOutputControlMode(outputControlMode);
        }
        this.updateRedstoneConditions();
    }

    @Override
    public void updateRedstoneSignal(@Nonnull TileCapBank tileCapBank, boolean recievingSignal) {
        if (recievingSignal) {
            this.redstoneRecievers.add(tileCapBank.getLocation());
        } else {
            this.redstoneRecievers.remove(tileCapBank.getLocation());
        }
        this.updateRedstoneConditions();
    }

    @Override
    public boolean isInputEnabled() {
        return this.inputRedstoneConditionMet;
    }

    @Override
    public boolean isOutputEnabled() {
        return this.outputRedstoneConditionMet;
    }

    private void updateRedstoneConditions() {
        int powerLevel = this.redstoneRecievers.isEmpty() ? 0 : 15;
        this.inputRedstoneConditionMet = RedstoneControlMode.isConditionMet(this.inputControlMode, powerLevel);
        this.outputRedstoneConditionMet = RedstoneControlMode.isConditionMet(this.outputControlMode, powerLevel);
    }

    @Override
    public IPowerStorage getController() {
        return this;
    }

    @Override
    public boolean isOutputEnabled(@Nonnull EnumFacing direction) {
        return this.isOutputEnabled();
    }

    @Override
    public boolean isInputEnabled(@Nonnull EnumFacing direction) {
        return this.isInputEnabled();
    }

    @Override
    public boolean isCreative() {
        return this.type.isCreative();
    }

    @Override
    public boolean isNetworkControlledIo(@Nonnull EnumFacing direction) {
        return true;
    }

    @Override
    public void invalidateDisplayInfoCache() {
    }

    @Override
    public void tickStart(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
    }
}

