/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.power;

import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.conduit.power.NetworkPowerManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PowerConduitNetwork
extends AbstractConduitNetwork<IPowerConduit, IPowerConduit> {
    NetworkPowerManager powerManager;
    @Nonnull
    private final Set<ReceptorEntry> powerReceptors = new HashSet<ReceptorEntry>();

    public PowerConduitNetwork() {
        super(IPowerConduit.class, IPowerConduit.class);
    }

    @Override
    public void init(@Nonnull IConduitBundle tile, Collection<IPowerConduit> connections, @Nonnull World world) throws ConduitUtil.UnloadedBlockException {
        super.init(tile, connections, world);
        this.powerManager = new NetworkPowerManager(this, world);
        this.powerManager.receptorsChanged();
    }

    @Override
    public void destroyNetwork() {
        for (IPowerConduit con : this.getConduits()) {
            con.setActive(false);
        }
        if (this.powerManager != null) {
            this.powerManager.onNetworkDestroyed();
        }
        super.destroyNetwork();
    }

    public NetworkPowerManager getPowerManager() {
        return this.powerManager;
    }

    @Override
    public void addConduit(@Nonnull IPowerConduit con) {
        super.addConduit(con);
        Set externalDirs = con.getExternalConnections();
        for (EnumFacing dir : externalDirs) {
            IPowerInterface pr;
            if (dir == null || (pr = con.getExternalPowerReceptor(dir)) == null) continue;
            TileEntity te = con.getBundle().getEntity();
            BlockPos p = te.func_174877_v().func_177972_a(dir);
            this.powerReceptorAdded(con, dir, p);
        }
    }

    public void powerReceptorAdded(@Nonnull IPowerConduit powerConduit, @Nonnull EnumFacing direction, @Nonnull BlockPos pos) {
        this.powerReceptors.add(new ReceptorEntry(pos, powerConduit, direction));
        if (this.powerManager != null) {
            this.powerManager.receptorsChanged();
        }
    }

    public void powerReceptorRemoved(@Nonnull IPowerConduit powerConduit, @Nonnull EnumFacing direction, @Nonnull BlockPos pos) {
        this.powerReceptors.remove(new ReceptorEntry(pos, powerConduit, direction));
        if (this.powerManager != null) {
            this.powerManager.receptorsChanged();
        }
    }

    public Collection<ReceptorEntry> getPowerReceptors() {
        return this.powerReceptors;
    }

    @Override
    public void tickEnd(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
        this.powerManager.applyRecievedPower(profiler);
    }

    public static class ReceptorEntry {
        @Nonnull
        final IPowerConduit emmiter;
        @Nonnull
        final BlockPos pos;
        @Nonnull
        final EnumFacing direction;

        public ReceptorEntry(@Nonnull BlockPos pos, @Nonnull IPowerConduit emmiter, @Nonnull EnumFacing direction) {
            this.pos = pos;
            this.emmiter = emmiter;
            this.direction = direction;
        }

        @Nullable
        IPowerInterface getPowerInterface() {
            return PowerHandlerUtil.getPowerInterface((ICapabilityProvider)this.emmiter.getBundle().getBundleworld().func_175625_s(this.pos), this.direction.func_176734_d());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pos.hashCode();
            result = 31 * result + this.direction.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReceptorEntry other = (ReceptorEntry)obj;
            if (!this.pos.equals((Object)other.pos)) {
                return false;
            }
            return this.direction == other.direction;
        }
    }
}

