/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.vat;

import com.enderio.core.common.util.NNList;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class VatRecipe
implements IRecipe {
    @Nonnull
    protected final NNList<ItemStack> inputStacks;
    @Nonnull
    private final NNList<List<ItemStack>> inputStackAlternatives;
    protected final boolean valid;
    @Nonnull
    protected final Table<IRecipeInput, IRecipeInput, FluidStack> inputFluidStacks = HashBasedTable.create();
    @Nonnull
    protected final Table<IRecipeInput, IRecipeInput, FluidStack> outputFluidStacks = HashBasedTable.create();
    @Nonnull
    protected final IRecipeInput[] inputs;
    @Nonnull
    protected final RecipeOutput[] output;
    protected final int energyRequired;
    private int requiredItems;

    public VatRecipe(@Nonnull IRecipe recipe) {
        FluidStack inputFluidStack = null;
        FluidStack outputFluidStack = null;
        this.inputs = recipe.getInputs();
        this.inputStackAlternatives = recipe.getInputStackAlternatives();
        for (RecipeOutput recipeOutput : recipe.getOutputs()) {
            FluidStack fluidOutput = recipeOutput.getFluidOutput();
            if (!recipeOutput.isFluid() || fluidOutput == null) continue;
            outputFluidStack = fluidOutput.copy();
            break;
        }
        if (outputFluidStack == null) {
            Log.warn("Ignoring invalid VAT recipe without output fluid");
            this.output = new RecipeOutput[0];
        } else {
            this.requiredItems = 1;
            for (IRecipeInput iRecipeInput : this.inputs) {
                if (iRecipeInput.isFluid() || iRecipeInput.getSlotNumber() != 1) continue;
                this.requiredItems = 2;
            }
            if (this.requiredItems == 2) {
                for (IRecipeInput iRecipeInput : this.inputs) {
                    if (iRecipeInput.isFluid() || iRecipeInput.getSlotNumber() != 0) continue;
                    for (IRecipeInput r1 : this.inputs) {
                        if (r1.isFluid() || r1.getSlotNumber() != 1) continue;
                        for (IRecipeInput r2 : this.inputs) {
                            if (!r2.isFluid()) continue;
                            float im = iRecipeInput.getMulitplier() * r1.getMulitplier();
                            inputFluidStack = r2.getFluidInput().copy();
                            inputFluidStack.amount = Math.round(1000.0f * im);
                            outputFluidStack.amount = Math.round(im * r2.getMulitplier() * 1000.0f);
                            this.inputFluidStacks.put((Object)iRecipeInput, (Object)r1, (Object)inputFluidStack.copy());
                            this.outputFluidStacks.put((Object)iRecipeInput, (Object)r1, (Object)outputFluidStack.copy());
                        }
                    }
                }
            } else {
                for (IRecipeInput iRecipeInput : this.inputs) {
                    if (iRecipeInput.isFluid()) continue;
                    for (IRecipeInput r2 : this.inputs) {
                        if (!r2.isFluid()) continue;
                        float im = iRecipeInput.getMulitplier();
                        inputFluidStack = r2.getFluidInput().copy();
                        inputFluidStack.amount = Math.round(1000.0f * im);
                        outputFluidStack.amount = Math.round(im * r2.getMulitplier() * 1000.0f);
                        this.inputFluidStacks.put((Object)iRecipeInput, (Object)iRecipeInput, (Object)inputFluidStack.copy());
                        this.outputFluidStacks.put((Object)iRecipeInput, (Object)iRecipeInput, (Object)outputFluidStack.copy());
                    }
                }
            }
            if (inputFluidStack == null) {
                Log.warn("Ignoring invalid VAT recipe without input fluid/stacks");
            }
            this.output = new RecipeOutput[]{new RecipeOutput(outputFluidStack)};
        }
        this.energyRequired = recipe.getEnergyRequired();
        this.inputStacks = recipe.getInputStacks();
        this.valid = inputFluidStack != null && !this.inputStacks.isEmpty() && this.inputStacks.size() > 0 && outputFluidStack != null;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public int getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    @Nonnull
    public RecipeOutput[] getOutputs() {
        return this.output;
    }

    @Override
    @Nonnull
    public IRecipeInput[] getInputs() {
        return this.inputs;
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getInputStacks() {
        return this.inputStacks;
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType() {
        return RecipeBonusType.NONE;
    }

    private IRecipeInput getRecipeInput(int slot, ItemStack item) {
        if (item == null) {
            return null;
        }
        for (IRecipeInput ri : this.inputs) {
            if (ri.getSlotNumber() != slot || !ri.isInput(item)) continue;
            return ri;
        }
        return null;
    }

    @Override
    public boolean isValidInput(int slot, @Nonnull ItemStack item) {
        return this.getRecipeInput(slot, item) != null;
    }

    @Override
    public boolean isValidInput(@Nonnull FluidStack item) {
        for (IRecipeInput ri : this.inputs) {
            if (item.getFluid() == null || !item.isFluidEqual(ri.getFluidInput())) continue;
            return true;
        }
        return false;
    }

    private RecipeMatch matchRecipe(NNList<MachineRecipeInput> recipeInputs) {
        if (!this.isValid() || recipeInputs == null || recipeInputs.size() < this.requiredItems + 1) {
            return null;
        }
        FluidStack inputFluid = null;
        RecipeMatch m = new RecipeMatch();
        for (MachineRecipeInput in : recipeInputs) {
            if (in.isFluid()) {
                inputFluid = in.fluid;
                continue;
            }
            m.setRecipeInput(this.getRecipeInput(in.slotNumber, in.item));
        }
        if (this.requiredItems == 1) {
            m.r1 = m.r0;
        }
        m.in = (FluidStack)this.inputFluidStacks.get((Object)m.r0, (Object)m.r1);
        m.out = (FluidStack)this.outputFluidStacks.get((Object)m.r0, (Object)m.r1);
        if (inputFluid != null && inputFluid.containsFluid(m.in)) {
            return m;
        }
        return null;
    }

    public RecipeMatch matchRecipe(@Nonnull FluidStack inputFluid, @Nonnull ItemStack in0, @Nonnull ItemStack in1) {
        if (!this.isValid() || this.requiredItems == 1 != Prep.isInvalid(in1)) {
            return null;
        }
        RecipeMatch m = new RecipeMatch();
        m.setRecipeInput(this.getRecipeInput(0, in0));
        if (this.requiredItems == 1) {
            m.r1 = m.r0;
        } else {
            m.setRecipeInput(this.getRecipeInput(1, in1));
        }
        m.in = (FluidStack)this.inputFluidStacks.get((Object)m.r0, (Object)m.r1);
        m.out = (FluidStack)this.outputFluidStacks.get((Object)m.r0, (Object)m.r1);
        return m;
    }

    @Override
    public boolean isInputForRecipe(NNList<MachineRecipeInput> recipeInputs) {
        RecipeMatch m = this.matchRecipe(recipeInputs);
        return m != null;
    }

    @Override
    public NNList<FluidStack> getInputFluidStacks() {
        for (IRecipeInput r2 : this.inputs) {
            if (!r2.isFluid()) continue;
            return new NNList((Object[])new FluidStack[]{r2.getFluidInput().copy()});
        }
        return NNList.emptyList();
    }

    public float getMultiplierForInput(FluidStack item) {
        for (IRecipeInput input : this.inputs) {
            if (!input.isInput(item)) continue;
            return input.getMulitplier();
        }
        return 1.0f;
    }

    public FluidStack getRequiredFluidInput(NNList<MachineRecipeInput> recipeInputs) {
        RecipeMatch m = this.matchRecipe(recipeInputs);
        if (m != null) {
            return m.in;
        }
        return new FluidStack(FluidRegistry.WATER, 999000);
    }

    public FluidStack getFluidOutput(NNList<MachineRecipeInput> recipeInputs) {
        RecipeMatch m = this.matchRecipe(recipeInputs);
        if (m != null) {
            return m.out;
        }
        return new FluidStack(FluidRegistry.WATER, 0);
    }

    public int getNumConsumed(ItemStack item) {
        for (IRecipeInput input : this.inputs) {
            if (item == null || !input.isInput(item)) continue;
            return input.getStackSize();
        }
        return 1;
    }

    @Override
    @Nonnull
    public NNList<List<ItemStack>> getInputStackAlternatives() {
        return this.inputStackAlternatives;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    public static class RecipeMatch {
        public IRecipeInput r0;
        public IRecipeInput r1;
        public FluidStack in;
        public FluidStack out;

        void setRecipeInput(IRecipeInput r) {
            if (r != null) {
                if (r.getSlotNumber() == 0) {
                    this.r0 = r;
                } else {
                    this.r1 = r;
                }
            }
        }
    }
}

